/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereConnector;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;
import java.util.Set;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Scannit;
import nl.javadude.scannit.scanner.AbstractScanner;
import nl.javadude.scannit.scanner.TypeAnnotationScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Overthere {
    private static final Logger logger = LoggerFactory.getLogger(Overthere.class);
    private static final OverthereConnector connector = new OverthereConnector();

    private static void boot() {
        Overthere.boot(new Scannit(Configuration.config().scan("com.xebialabs").with(new AbstractScanner[]{new TypeAnnotationScanner()})));
    }

    private static void boot(Scannit scannit) {
        Set protocolClasses = scannit.getTypesAnnotatedWith(Protocol.class);
        for (Class protocol : protocolClasses) {
            if (OverthereConnectionBuilder.class.isAssignableFrom(protocol)) {
                connector.registerProtocol(protocol);
                continue;
            }
            logger.warn("Skipping class {} because it is not a HostConnectionBuilder.", (Object)protocol);
        }
    }

    private Overthere() {
    }

    public static OverthereConnection getConnection(String protocol, ConnectionOptions options) {
        return connector.getConnection(protocol, options);
    }

    static {
        if (Scannit.isBooted()) {
            logger.info("Scannit already booted, checking to see whether it has scanned 'com.xebialabs'");
            Set protocols = Scannit.getInstance().getTypesAnnotatedWith(Protocol.class);
            if (!protocols.isEmpty()) {
                Overthere.boot(Scannit.getInstance());
            } else {
                Overthere.boot();
            }
        } else {
            Overthere.boot();
        }
    }
}

