/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.deployment.DeployedPropertySetter;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.Dictionaries;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployedApplicationFactory {
    private final DeployedPropertySetter deployedPropertySetter;

    @Autowired
    public DeployedApplicationFactory(DeployedPropertySetter deployedPropertySetter) {
        this.deployedPropertySetter = deployedPropertySetter;
    }

    public DeployedApplication createDeployedApplication(Type deployedApplicationType, Version pkg, Environment env, ConsolidatedDictionary dictionary) {
        Descriptor deployedApplicationDescriptor = DescriptorRegistry.getDescriptor((Type)deployedApplicationType);
        String id = IdGenerator.generateId((ConfigurationItem)env, (String)pkg.getApplication().getId());
        DeployedApplication deployedApplication = (DeployedApplication)deployedApplicationDescriptor.newInstance(id);
        deployedApplication.setVersion(pkg);
        deployedApplication.setEnvironment(env);
        this.deployedPropertySetter.setProperties(deployedApplication, null, dictionary);
        return deployedApplication;
    }

    public DeployedApplication createUpgradeDeployedApplication(Version newVersion, DeployedApplication deployedApplication, ConsolidatedDictionary dictionary) {
        Descriptor deployedApplicationDescriptor = DescriptorRegistry.getDescriptor((Type)Type.valueOf(DeployedApplication.class));
        DeployedApplication newDeployedApplication = (DeployedApplication)deployedApplicationDescriptor.newInstance(deployedApplication.getId());
        newDeployedApplication.setEnvironment(deployedApplication.getEnvironment());
        newDeployedApplication.setVersion(newVersion);
        this.deployedPropertySetter.setProperties(newDeployedApplication, deployedApplication, dictionary);
        return newDeployedApplication;
    }

    public void scanMissingPlaceholders(DeployedApplication deployedApplication, Environment environment) {
        this.deployedPropertySetter.setProperties(deployedApplication, null, Dictionaries.of((List)environment.getDictionaries()).consolidate());
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class IncorrectDeployedException
    extends DeployitException {
        IncorrectDeployedException(Throwable cause, String messageTemplate, Object ... params) {
            super(cause, messageTemplate, params);
        }
    }
}

