@echo off
REM
REM Batch script to install XL Deploy Server as a service
REM

setlocal ENABLEDELAYEDEXPANSION

REM Get XL Deploy server home dir
if "%xldeploy_home%"=="" (
    cd /d "%~dp0"
    cd ..
    set xldeploy_home=!CD!
)

call "%xldeploy_home%\bin\.wrapper-env.cmd"

if %errorLevel% neq 0 ( exit /b %errorLevel% )

If NOT exist "%xldeploy_home%\conf\deployit.conf" (
    echo The XL Deploy server is not initialized. Please execute the run.cmd script!
    exit /b 1
)

If NOT exist "%xldeploy_home%\conf\deployit-license.lic" (
    echo A license is required in order to be able to install the XL Deploy Server as a service.
    exit /b 1
)

call %java_exe% %wrapper_java_options% -jar %wrapper_jar% -i %conf_file%
call %java_exe% %wrapper_java_options% -jar %wrapper_jar% -t %conf_file%

endlocal
