/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.reflect.Proxy;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceLocatorInvoker;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.registry.RootNode;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.metadata.ResourceBuilder;
import org.jboss.resteasy.spi.metadata.ResourceClass;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.jboss.resteasy.spi.metadata.ResourceMethod;

public class LocatorRegistry {
    protected RootNode root = new RootNode();
    protected ResteasyProviderFactory providerFactory;

    public LocatorRegistry(Class<?> clazz, ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        ResourceBuilder resourceBuilder = providerFactory.getResourceBuilder();
        if (Proxy.isProxyClass(clazz)) {
            for (Class<?> intf : clazz.getInterfaces()) {
                ResourceClass resourceClass = resourceBuilder.getLocatorFromAnnotations(intf);
                this.register(resourceClass);
            }
        } else {
            ResourceClass resourceClass = resourceBuilder.getLocatorFromAnnotations(clazz);
            this.register(resourceClass);
        }
    }

    public void register(ResourceClass resourceClass) {
        for (ResourceMethod resourceMethod : resourceClass.getResourceMethods()) {
            this.processMethod(resourceMethod);
        }
        for (ResourceLocator resourceLocator : resourceClass.getResourceLocators()) {
            this.processMethod(resourceLocator);
        }
    }

    protected void processMethod(ResourceLocator method) {
        String fullpath = method.getFullpath() == null ? "" : method.getFullpath();
        InjectorFactory injectorFactory = this.providerFactory.getInjectorFactory();
        if (method instanceof ResourceMethod) {
            ResourceMethodInvoker invoker = new ResourceMethodInvoker((ResourceMethod)method, injectorFactory, null, this.providerFactory);
            this.root.addInvoker(fullpath, invoker);
        } else {
            ResourceLocatorInvoker locator = new ResourceLocatorInvoker(null, injectorFactory, this.providerFactory, method);
            this.root.addInvoker(fullpath, locator);
        }
    }

    public ResourceInvoker getResourceInvoker(HttpRequest request) {
        String currentUri = request.getUri().getEncodedMatchedPaths().get(0);
        int startAt = currentUri.length();
        return this.root.match(request, startAt);
    }
}

