/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.asn1.cmc;

import org.python.bouncycastle.asn1.ASN1Sequence;
import org.python.bouncycastle.asn1.DERSequence;
import org.python.bouncycastle.asn1.DERUTF8String;
import org.python.bouncycastle.asn1.cmc.BodyPartID;
import org.python.bouncycastle.asn1.cmc.CMCFailInfo;
import org.python.bouncycastle.asn1.cmc.CMCStatus;
import org.python.bouncycastle.asn1.cmc.CMCStatusInfo;
import org.python.bouncycastle.asn1.cmc.PendInfo;

public class CMCStatusInfoBuilder {
    private final CMCStatus cMCStatus;
    private final ASN1Sequence bodyList;
    private DERUTF8String statusString;
    private CMCStatusInfo.OtherInfo otherInfo;

    public CMCStatusInfoBuilder(CMCStatus cMCStatus, BodyPartID bodyPartID) {
        this.cMCStatus = cMCStatus;
        this.bodyList = new DERSequence(bodyPartID);
    }

    public CMCStatusInfoBuilder(CMCStatus cMCStatus, BodyPartID[] bodyPartIDArray) {
        this.cMCStatus = cMCStatus;
        this.bodyList = new DERSequence(bodyPartIDArray);
    }

    public CMCStatusInfoBuilder setStatusString(String string2) {
        this.statusString = new DERUTF8String(string2);
        return this;
    }

    public CMCStatusInfoBuilder setOtherInfo(CMCFailInfo cMCFailInfo) {
        this.otherInfo = new CMCStatusInfo.OtherInfo(cMCFailInfo);
        return this;
    }

    public CMCStatusInfoBuilder setOtherInfo(PendInfo pendInfo) {
        this.otherInfo = new CMCStatusInfo.OtherInfo(pendInfo);
        return this;
    }

    public CMCStatusInfo build() {
        return new CMCStatusInfo(this.cMCStatus, this.bodyList, this.statusString, this.otherInfo);
    }
}

