/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler.custom_proxymaker;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.python.compiler.Code;
import org.python.compiler.JavaMaker;
import org.python.compiler.ProxyCodeHelpers;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.__builtin__;
import org.python.util.Generic;

public class MiniClampMaker
extends JavaMaker {
    private final Map<String, PyObject> methodsToAdd = Generic.map();
    private final Map<String, PyObject> constructorsToAdd = Generic.map();
    private ProxyCodeHelpers.AnnotationDescr[] classAnnotations = new ProxyCodeHelpers.AnnotationDescr[0];

    private static ProxyCodeHelpers.AnnotationDescr[] extractAnnotation(PyDictionary dict) {
        List<ProxyCodeHelpers.AnnotationDescr> annotationDescrs = Generic.list();
        for (PyObject annotationIter : dict.iteritems().asIterable()) {
            PyObject annotationClass = annotationIter.__getitem__(0);
            PyObject annotationFields = annotationIter.__getitem__(1);
            ProxyCodeHelpers.AnnotationDescr annotationDescr = null;
            if (annotationFields == Py.None) {
                annotationDescr = new ProxyCodeHelpers.AnnotationDescr(Py.tojava(annotationClass, Class.class));
            } else {
                Map<String, Object> fields = Generic.map();
                for (PyObject item : ((PyDictionary)annotationFields).iteritems().asIterable()) {
                    fields.put(Py.tojava(item.__getitem__(0), String.class), Py.tojava(item.__getitem__(1), Object.class));
                }
                annotationDescr = new ProxyCodeHelpers.AnnotationDescr(Py.tojava(annotationClass, Class.class), fields);
            }
            annotationDescrs.add(annotationDescr);
        }
        return annotationDescrs.toArray(new ProxyCodeHelpers.AnnotationDescr[annotationDescrs.size()]);
    }

    public MiniClampMaker(Class<?> superclass, Class<?>[] interfaces, String pythonClass, String pythonModule, String myClass, PyObject methods) {
        super(superclass, interfaces, pythonClass, pythonModule, myClass, methods);
        PyObject javaPackage = methods.__finditem__("__java_package__");
        if (javaPackage != null) {
            String newMyClass = new String((String)javaPackage.__tojava__(String.class));
            this.myClass = newMyClass = newMyClass + "." + pythonClass;
        }
        PyString clampAttr = Py.newString("_clamp");
        for (PyObject pykey : methods.asIterable()) {
            String key = Py.tojava(pykey, String.class);
            PyObject value = methods.__finditem__(key);
            PyObject clampObj = __builtin__.getattr(value, clampAttr, Py.None);
            if (clampObj == Py.None) continue;
            String name = (String)clampObj.__getattr__("name").__tojava__(String.class);
            if (name.equals("__init__")) {
                this.constructorsToAdd.put(key, clampObj);
                continue;
            }
            this.methodsToAdd.put(key, clampObj);
        }
        PyObject pyAnnotations = methods.__finditem__("_clamp_class_annotations");
        if (pyAnnotations != null) {
            this.classAnnotations = MiniClampMaker.extractAnnotation((PyDictionary)pyAnnotations);
        }
    }

    @Override
    protected void visitClassAnnotations() throws Exception {
        for (ProxyCodeHelpers.AnnotationDescr annotation : this.classAnnotations) {
            this.addClassAnnotation(annotation);
        }
    }

    @Override
    protected void visitConstructors() throws Exception {
        Set<Constructor<?>> superConstructors = Generic.set();
        for (Constructor<?> constructor : this.superclass.getDeclaredConstructors()) {
            superConstructors.add(constructor);
        }
        for (Map.Entry entry : this.constructorsToAdd.entrySet()) {
            Constructor superToCall = null;
            String pyName = (String)entry.getKey();
            PyObject clampObj = (PyObject)entry.getValue();
            Class[] thrownClasses = Py.tojava(clampObj.__getattr__("throws"), Class[].class);
            Class[] parameterClasses = Py.tojava(clampObj.__getattr__("argtypes"), Class[].class);
            if (clampObj.__findattr__("super_constructor") != null) {
                superToCall = (Constructor)clampObj.__getattr__("super_constructor").__tojava__(Constructor.class);
            } else {
                try {
                    superToCall = this.superclass.getDeclaredConstructor(parameterClasses);
                }
                catch (NoSuchMethodException err) {
                    superToCall = (Constructor)superConstructors.iterator().next();
                }
            }
            for (Constructor constructor : superConstructors) {
                if (!Arrays.equals(constructor.getParameterTypes(), superToCall.getParameterTypes())) continue;
                superConstructors.remove(constructor);
            }
            ProxyCodeHelpers.AnnotationDescr[] methodAnnotations = MiniClampMaker.extractAnnotation((PyDictionary)clampObj.__getattr__("method_annotations"));
            PyObject[] pyObjectArray = (PyObject[])clampObj.__getattr__("parameter_annotations").__tojava__(PyObject[].class);
            ProxyCodeHelpers.AnnotationDescr[][] parameterAnnotations = new ProxyCodeHelpers.AnnotationDescr[pyObjectArray.length][];
            for (int i = 0; i < pyObjectArray.length; ++i) {
                if (!pyObjectArray[i].isMappingType()) continue;
                parameterAnnotations[i] = MiniClampMaker.extractAnnotation((PyDictionary)pyObjectArray[i]);
            }
            String fullsig = MiniClampMaker.makeSig(Void.TYPE, parameterClasses);
            String[] mappedExceptions = MiniClampMaker.mapExceptions(thrownClasses);
            Code code2 = this.classfile.addMethod("<init>", fullsig, 1, mappedExceptions, methodAnnotations, parameterAnnotations);
            this.callSuper(code2, "<init>", MiniClampMaker.mapClass(this.superclass), superToCall.getParameterTypes(), Void.TYPE, false);
            this.addConstructorMethodCode(pyName, superToCall.getParameterTypes(), thrownClasses, 1, this.superclass, code2);
        }
        for (Constructor constructor : superConstructors) {
            this.addConstructor(constructor.getParameterTypes(), 1);
        }
    }

    @Override
    protected void visitMethods() throws Exception {
        for (Map.Entry<String, PyObject> meth : this.methodsToAdd.entrySet()) {
            PyObject clampObj = meth.getValue();
            String methodName = (String)clampObj.__getattr__("name").__tojava__(String.class);
            Class returnClass = (Class)clampObj.__getattr__("returntype").__tojava__(Class.class);
            Class[] thrownClasses = Py.tojava(clampObj.__getattr__("throws"), Class[].class);
            Class[] parameterClasses = Py.tojava(clampObj.__getattr__("argtypes"), Class[].class);
            ProxyCodeHelpers.AnnotationDescr[] methodAnnotations = MiniClampMaker.extractAnnotation((PyDictionary)clampObj.__getattr__("method_annotations"));
            PyObject[] parameterAnnotationObjs = (PyObject[])clampObj.__getattr__("parameter_annotations").__tojava__(PyObject[].class);
            ProxyCodeHelpers.AnnotationDescr[][] parameterAnnotations = new ProxyCodeHelpers.AnnotationDescr[parameterAnnotationObjs.length][];
            for (int i = 0; i < parameterAnnotationObjs.length; ++i) {
                if (!parameterAnnotationObjs[i].isMappingType()) continue;
                parameterAnnotations[i] = MiniClampMaker.extractAnnotation((PyDictionary)parameterAnnotationObjs[i]);
            }
            this.addMethod(methodName, meth.getKey(), returnClass, parameterClasses, thrownClasses, 1, this.superclass, methodAnnotations, parameterAnnotations);
        }
    }
}

