/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.NoSerializationVerificationNeeded;
import akka.annotation.InternalApi;
import akka.io.Dns;
import akka.io.Dns$Resolved$;
import akka.io.PeriodicCacheCleanup;
import akka.io.SimpleDnsCache;
import akka.io.SimpleDnsCache$;
import akka.io.dns.AAAARecord;
import akka.io.dns.ARecord;
import akka.io.dns.CachePolicy;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Ip$;
import akka.io.dns.ResourceRecord;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u0006\r\u0001UAQa\t\u0001\u0005\u0002\u0011Bqa\n\u0001C\u0002\u0013%\u0001\u0006\u0003\u0004^\u0001\u0001\u0006I!\u000b\u0005\b=\u0002\u0011\r\u0011\"\u0003`\u0011\u0019\u0019\u0007\u0001)A\u0005A\")A\r\u0001C!K\")\u0011\u000f\u0001C\te\"11\u000f\u0001C\u0003%QDa\u0001\u001f\u0001\u0005\u0006AI\bbBA\u0011\u0001\u0011\u0015\u00131\u0005\u0002\u000e\u0003NLhn\u0019#og\u000e\u000b7\r[3\u000b\u00055q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005=\u0001\u0012a\u00013og*\u0011\u0011CE\u0001\u0003S>T\u0011aE\u0001\u0005C.\\\u0017m\u0001\u0001\u0014\t\u00011\"$\b\t\u0003/ai\u0011\u0001E\u0005\u00033A\u00111\u0001\u00128t!\t92$\u0003\u0002\u001d!\t!\u0002+\u001a:j_\u0012L7mQ1dQ\u0016\u001cE.Z1okB\u0004\"AH\u0011\u000e\u0003}Q!\u0001\t\n\u0002\u000b\u0005\u001cGo\u001c:\n\u0005\tz\"!\t(p'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8WKJLg-[2bi&|gNT3fI\u0016$\u0017A\u0002\u001fj]&$h\bF\u0001&!\t1\u0003!D\u0001\r\u0003!\u0019\u0017m\u00195f%\u00164W#A\u0015\u0011\u0007)\u001aT'D\u0001,\u0015\taS&\u0001\u0004bi>l\u0017n\u0019\u0006\u0003]=\n!bY8oGV\u0014(/\u001a8u\u0015\t\u0001\u0014'\u0001\u0003vi&d'\"\u0001\u001a\u0002\t)\fg/Y\u0005\u0003i-\u0012q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\u0005m\u0001\u001b%L\u0004\u00028}9\u0011\u0001(\u0010\b\u0003sqj\u0011A\u000f\u0006\u0003wQ\ta\u0001\u0010:p_Rt\u0014\"A\n\n\u0005E\u0011\u0012BA \u0011\u00039\u0019\u0016.\u001c9mK\u0012s7oQ1dQ\u0016L!!\u0011\"\u0003\u000b\r\u000b7\r[3\u000b\u0005}\u0002\u0002\u0003\u0002#H\u0013Fk\u0011!\u0012\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*\u0012\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005)seBA&M!\tIT)\u0003\u0002N\u000b\u00061\u0001K]3eK\u001aL!a\u0014)\u0003\rM#(/\u001b8h\u0015\tiU\t\u0005\u0002S/:\u00111+\u0016\b\u0003oQK!a\u0004\t\n\u0005Ys\u0011a\u0003#ogB\u0013x\u000e^8d_2L!\u0001W-\u0003\u0017I+\u0017/^3tiRK\b/\u001a\u0006\u0003-:\u0001\"AU.\n\u0005qK&\u0001\u0003*fg>dg/\u001a3\u0002\u0013\r\f7\r[3SK\u001a\u0004\u0013\u0001\u00038b]>\u0014\u0015m]3\u0016\u0003\u0001\u0004\"\u0001R1\n\u0005\t,%\u0001\u0002'p]\u001e\f\u0011B\\1o_\n\u000b7/\u001a\u0011\u0002\r\r\f7\r[3e)\t1w\u000eE\u0002EO&L!\u0001[#\u0003\r=\u0003H/[8o!\tQWN\u0004\u0002\u0018W&\u0011A\u000eE\u0001\u0004\t:\u001c\u0018B\u0001/o\u0015\ta\u0007\u0003C\u0003q\r\u0001\u0007\u0011*\u0001\u0003oC6,\u0017!B2m_\u000e\\G#\u00011\u0002\u0007\u001d,G\u000f\u0006\u0002vmB\u0019Ai\u001a.\t\u000b]D\u0001\u0019A\"\u0002\u0007-,\u00170A\u0002qkR$RA_?\u007f\u0003\u0003\u0001\"\u0001R>\n\u0005q,%\u0001B+oSRDQa^\u0005A\u0002\rCQa`\u0005A\u0002i\u000bqA]3d_J$7\u000fC\u0004\u0002\u0004%\u0001\r!!\u0002\u0002\u0007Q$H\u000e\u0005\u0003\u0002\b\u00055abA*\u0002\n%\u0019\u00111\u0002\b\u0002\u0017\r\u000b7\r[3Q_2L7-_\u0005\u0005\u0003\u001f\t\tBA\u0006DC\u000eDW\rU8mS\u000eL(bAA\u0006\u001d!\u001a\u0011\"!\u0006\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007F\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\tIBA\u0004uC&d'/Z2\u0002\u000f\rdW-\u00198vaR\t!\u0010K\u0002\u000b\u0003+A3\u0001AA\u0015!\u0011\tY#a\f\u000e\u0005\u00055\"bAA\u000e%%!\u0011\u0011GA\u0017\u0005-Ie\u000e^3s]\u0006d\u0017\t]5")
public class AsyncDnsCache
extends Dns
implements PeriodicCacheCleanup,
NoSerializationVerificationNeeded {
    private final AtomicReference<SimpleDnsCache.Cache<Tuple2<String, DnsProtocol.RequestType>, DnsProtocol.Resolved>> cacheRef = new AtomicReference(new SimpleDnsCache.Cache((SortedSet)SortedSet$.MODULE$.apply((Seq)Nil$.MODULE$, SimpleDnsCache$.MODULE$.expiryEntryOrdering()), (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.clock()));
    private final long nanoBase = System.nanoTime();

    private AtomicReference<SimpleDnsCache.Cache<Tuple2<String, DnsProtocol.RequestType>, DnsProtocol.Resolved>> cacheRef() {
        return this.cacheRef;
    }

    private long nanoBase() {
        return this.nanoBase;
    }

    @Override
    public Option<Dns.Resolved> cached(String name) {
        boolean x$12 = false;
        boolean x$22 = DnsProtocol$Ip$.MODULE$.apply$default$1();
        List ipv4 = (List)this.cacheRef().get().get((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)new DnsProtocol.Ip(x$22, x$12))).toList().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.records(), List$.MODULE$.canBuildFrom());
        List ipv6 = (List)this.cacheRef().get().get((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)new DnsProtocol.Ip(false, DnsProtocol$Ip$.MODULE$.apply$default$2()))).toList().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.records(), List$.MODULE$.canBuildFrom());
        List both = (List)this.cacheRef().get().get((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)new DnsProtocol.Ip(DnsProtocol$Ip$.MODULE$.apply$default$1(), DnsProtocol$Ip$.MODULE$.apply$default$2()))).toList().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.records(), List$.MODULE$.canBuildFrom());
        List all = (List)((List)((List)ipv4.$plus$plus((GenTraversableOnce)ipv6, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)both, List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ResourceRecord, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof ARecord) {
                    ARecord aRecord = (ARecord)A1;
                    object = aRecord.ip();
                } else if (A1 instanceof AAAARecord) {
                    AAAARecord aAAARecord = (AAAARecord)A1;
                    object = aAAARecord.ip();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ResourceRecord x1) {
                ResourceRecord resourceRecord = x1;
                boolean bl = resourceRecord instanceof ARecord ? true : resourceRecord instanceof AAAARecord;
                return bl;
            }
        }, List$.MODULE$.canBuildFrom());
        return all.isEmpty() ? None$.MODULE$ : new Some((Object)Dns$Resolved$.MODULE$.apply(name, (Iterable<InetAddress>)all));
    }

    public long clock() {
        long now = System.nanoTime();
        return now - this.nanoBase() < 0L ? 0L : (now - this.nanoBase()) / 1000000L;
    }

    public final Option<DnsProtocol.Resolved> get(Tuple2<String, DnsProtocol.RequestType> key) {
        return this.cacheRef().get().get(key);
    }

    public final void put(Tuple2<String, DnsProtocol.RequestType> key, DnsProtocol.Resolved records, CachePolicy.CachePolicy ttl) {
        SimpleDnsCache.Cache<Tuple2<String, DnsProtocol.RequestType>, DnsProtocol.Resolved> c;
        do {
            c = this.cacheRef().get();
        } while (!this.cacheRef().compareAndSet(c, c.put(key, records, ttl)));
    }

    @Override
    public final void cleanup() {
        SimpleDnsCache.Cache<Tuple2<String, DnsProtocol.RequestType>, DnsProtocol.Resolved> c;
        do {
            c = this.cacheRef().get();
        } while (!this.cacheRef().compareAndSet(c, c.cleanup()));
    }
}

