/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.ConfigurationException;
import akka.actor.ActorPath;
import akka.actor.ActorRef;
import akka.actor.ActorRefProvider;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.Deploy$;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.Props$;
import akka.actor.RootActorPath;
import akka.actor.ScalaActorRef;
import akka.actor.Scheduler;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.cluster.Cluster$;
import akka.cluster.Cluster$ClusterLogger$;
import akka.cluster.ClusterActorRefProvider;
import akka.cluster.ClusterDaemon;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterEvent$InitialStateAsSnapshot$;
import akka.cluster.ClusterJmx;
import akka.cluster.ClusterReadView;
import akka.cluster.ClusterSettings;
import akka.cluster.ClusterUserAction;
import akka.cluster.DowningProvider;
import akka.cluster.DowningProvider$;
import akka.cluster.InternalClusterAction;
import akka.cluster.InternalClusterAction$GetClusterCoreRef$;
import akka.cluster.JoinConfigCompatChecker;
import akka.cluster.JoinConfigCompatChecker$;
import akka.cluster.Member;
import akka.cluster.UniqueAddress;
import akka.dispatch.MonitorableThreadFactory;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.japi.Util$;
import akka.pattern.AskableActorRef$;
import akka.remote.AddressUidExtension;
import akka.remote.AddressUidExtension$;
import akka.remote.DefaultFailureDetectorRegistry;
import akka.remote.FailureDetectorLoader$;
import akka.remote.FailureDetectorRegistry;
import akka.util.Timeout;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00115t!\u0002/^\u0011\u0003\u0011g!\u00023^\u0011\u0003)\u0007BB?\u0002\t\u0003!y\u0005C\u0004\u0005R\u0005!\t\u0005b\u0015\t\u000f\u0011u\u0013\u0001\"\u0011\u0005`!9A1M\u0001\u0005B\u0011\u0015\u0004B\u0003C5\u0003\t\u0007IQA/\u0003\u000e!AA1N\u0001!\u0002\u001b\u0011yA\u0002\u0003e;\u0002\u0019\b\u0002C<\t\u0005\u000b\u0007I\u0011\u0001=\t\u0011qD!\u0011!Q\u0001\neDQ! \u0005\u0005\u0002yD\u0011\"!\u0001\t\u0005\u0004%\t!a\u0001\t\u0011\u0005-\u0001\u0002)A\u0005\u0003\u000bA\u0011\"!\u0004\t\u0005\u0004%I!a\u0004\t\u0011\u0005]\u0001\u0002)A\u0005\u0003#A\u0011\"!\u0007\t\u0005\u0004%\t!a\u0007\t\u0011\u0005\r\u0002\u0002)A\u0005\u0003;Aq!!\n\t\t\u0003\t9\u0003C\u0004\u00020!!\t!!\r\t\u000f\u0005=\u0003\u0002\"\u0001\u0002R!9\u0011\u0011\u000e\u0005\u0005\u0002\u0005-\u0004\"CA>\u0011\t\u0007I\u0011BA?\u0011!\ty\t\u0003Q\u0001\n\u0005}\u0004\"CAI\u0011\t\u0007I\u0011BAJ\u0011!\t\t\u000b\u0003Q\u0001\n\u0005U\u0005\"CAR\u0011\u0001\u0007I\u0011BAS\u0011%\t\u0019\f\u0003a\u0001\n\u0013\t)\f\u0003\u0005\u0002B\"\u0001\u000b\u0015BAT\u0011%\t\u0019\r\u0003b\u0001\n\u0003\t)\r\u0003\u0005\u0002T\"\u0001\u000b\u0011BAd\u0011%\t)\u000e\u0003b\u0001\n\u0003\t)\r\u0003\u0005\u0002X\"\u0001\u000b\u0011BAd\u0011)\tI\u000e\u0003EC\u0002\u0013\u0005\u00111\u001c\u0005\u000b\u0003GD!\u0019!C\u0001;\u0006\u0015\b\u0002CAw\u0011\u0001\u0006I!a:\t\u0013\u0005=\bB1A\u0005\n\u0005E\b\u0002CA}\u0011\u0001\u0006I!a=\t\u0015\u0005m\bB1A\u0005\u0002u\u000b\t\u0010\u0003\u0005\u0002~\"\u0001\u000b\u0011BAz\u0011)\ty\u0010\u0003b\u0001\n\u0003i&\u0011\u0001\u0005\t\u0005\u0013A\u0001\u0015!\u0003\u0003\u0004!9!1\u0002\u0005\u0005\u0002\t5\u0001b\u0002B\u000b\u0011\u0011\u0005!q\u0003\u0005\b\u0005OAA\u0011\u0001B\u0015\u0011\u001d\u0011\t\u0004\u0003C\u0001\u0005gAqA!\r\t\t\u0003\u0011y\u0007C\u0004\u0003\u000e\"!\tAa$\t\u000f\t5\u0005\u0002\"\u0001\u0003\u0014\"9!1\u0015\u0005\u0005\u0002\t\u0015\u0006b\u0002BV\u0011\u0011\u0005!Q\u0016\u0005\b\u0005gCA\u0011\u0002B[\u0011\u001d\u0011I\f\u0003C\u0001\u0005wCqA!/\t\t\u0003\u0011\t\u000eC\u0004\u0003\\\"!\tA!8\t\u000f\t\u0005\b\u0002\"\u0001\u0003d\"9!q\u001d\u0005\u0005\u0002\t%\bb\u0002Bt\u0011\u0011\u0005!Q \u0005\b\u0007\u001fAA\u0011AB\t\u0011\u001d\u0019y\u0001\u0003C\u0001\u0007;Aqa!\t\t\t\u0003\u0019\u0019\u0003\u0003\u0005\u00040!!\t!XB\u0019\u0011\u001d\u0019y\u0004\u0003C\u0005\u0007c9\u0001b!\u0011\t\u0011\u0003i61\t\u0004\t\u0007\u000fB\u0001\u0012A/\u0004J!1Q\u0010\u0011C\u0001\u0007\u0017Bqa!\u0014A\t\u0003\u0011i\u0001C\u0004\u0004P\u0001#\ta!\u0015\t\u000f\r=\u0003\t\"\u0001\u0004X!91q\n!\u0005\u0002\r\u0005\u0004bBB(\u0001\u0012\u000511\u000e\u0005\b\u0007o\u0002E\u0011AB=\u0011\u001d\u00199\b\u0011C\u0001\u0007{Bqaa\u001eA\t\u0003\u0019\u0019\tC\u0004\u0004x\u0001#\taa#\t\u000f\rU\u0005\t\"\u0001\u0004\u0018\"91Q\u0013!\u0005\u0002\rm\u0005bBBK\u0001\u0012\u00051\u0011\u0015\u0005\b\u0007+\u0003E\u0011ABU\u0011\u001d\u0019\u0019\f\u0011C\u0001\u0007kCqaa-A\t\u0003\u0019I\fC\u0004\u00044\u0002#\taa0\t\u000f\rM\u0006\t\"\u0001\u0004H\"911\u0017!\u0005\u0002\rE\u0007bBBZ\u0001\u0012\u000511\u001e\u0005\b\u0007g\u0003E\u0011ABz\u0011\u001d\u0019\u0019\f\u0011C\u0001\u0007{Dq\u0001\"\u0003A\t\u0013!Y\u0001C\u0004\u0005\n\u0001#I\u0001\"\n\t\u000f\u0011%\u0001\t\"\u0003\u0005.!9A\u0011\u0002!\u0005\n\u0011]\u0002b\u0002C\"\u0001\u0012%AQI\u0001\b\u00072,8\u000f^3s\u0015\tqv,A\u0004dYV\u001cH/\u001a:\u000b\u0003\u0001\fA!Y6lC\u000e\u0001\u0001CA2\u0002\u001b\u0005i&aB\"mkN$XM]\n\u0006\u0003\u0019dG\u0011\n\t\u0003O*l\u0011\u0001\u001b\u0006\u0002S\u0006)1oY1mC&\u00111\u000e\u001b\u0002\u0007\u0003:L(+\u001a4\u0011\u00075\u0004(/D\u0001o\u0015\tyw,A\u0003bGR|'/\u0003\u0002r]\nYQ\t\u001f;f]NLwN\\%e!\t\u0019\u0007bE\u0002\tMR\u0004\"!\\;\n\u0005Yt'!C#yi\u0016t7/[8o\u0003\u0019\u0019\u0018p\u001d;f[V\t\u0011\u0010\u0005\u0002nu&\u00111P\u001c\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\\\u0001\bgf\u001cH/Z7!\u0003\u0019a\u0014N\\5u}Q\u0011!o \u0005\u0006o.\u0001\r!_\u0001\tg\u0016$H/\u001b8hgV\u0011\u0011Q\u0001\t\u0004G\u0006\u001d\u0011bAA\u0005;\ny1\t\\;ti\u0016\u00148+\u001a;uS:<7/A\u0005tKR$\u0018N\\4tA\u00059\"n\\5o\u0007>tg-[4D_6\u0004\u0018\r^\"iK\u000e\\WM]\u000b\u0003\u0003#\u00012aYA\n\u0013\r\t)\"\u0018\u0002\u0018\u0015>LgnQ8oM&<7i\\7qCR\u001c\u0005.Z2lKJ\f\u0001D[8j]\u000e{gNZ5h\u0007>l\u0007/\u0019;DQ\u0016\u001c7.\u001a:!\u0003E\u0019X\r\u001c4V]&\fX/Z!eIJ,7o]\u000b\u0003\u0003;\u00012aYA\u0010\u0013\r\t\t#\u0018\u0002\u000e+:L\u0017/^3BI\u0012\u0014Xm]:\u0002%M,GNZ+oSF,X-\u00113ee\u0016\u001c8\u000fI\u0001\fg\u0016dg-\u00113ee\u0016\u001c8/\u0006\u0002\u0002*A\u0019Q.a\u000b\n\u0007\u00055bNA\u0004BI\u0012\u0014Xm]:\u0002\u001dM,GN\u001a#bi\u0006\u001cUM\u001c;feV\u0011\u00111\u0007\t\u0005\u0003k\tIE\u0004\u0003\u00028\u0005\u0015c\u0002BA\u001d\u0003\u0007rA!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007f\t\u0017A\u0002\u001fs_>$h(C\u0001a\u0013\tqv,C\u0002\u0002Hu\u000bqb\u00117vgR,'oU3ui&twm]\u0005\u0005\u0003\u0017\niE\u0001\u0006ECR\f7)\u001a8uKJT1!a\u0012^\u0003%\u0019X\r\u001c4S_2,7/\u0006\u0002\u0002TA1\u0011QKA/\u0003GrA!a\u0016\u0002ZA\u0019\u00111\b5\n\u0007\u0005m\u0003.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\n\tGA\u0002TKRT1!a\u0017i!\u0011\t)&!\u001a\n\t\u0005\u001d\u0014\u0011\r\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019\u001d,GoU3mMJ{G.Z:\u0016\u0005\u00055\u0004CBA8\u0003s\n\u0019'\u0004\u0002\u0002r)!\u00111OA;\u0003\u0011)H/\u001b7\u000b\u0005\u0005]\u0014\u0001\u00026bm\u0006LA!a\u0018\u0002r\u0005iq,[:UKJl\u0017N\\1uK\u0012,\"!a \u0011\t\u0005\u0005\u00151R\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u00061\u0011\r^8nS\u000eTA!!#\u0002r\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u00055\u00151\u0011\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u001d}K7\u000fV3s[&t\u0017\r^3eA\u0005\u0019An\\4\u0016\u0005\u0005U\u0005\u0003BAL\u0003;k!!!'\u000b\u0007\u0005mu,A\u0003fm\u0016tG/\u0003\u0003\u0002 \u0006e%A\u0004'pO\u001eLgnZ!eCB$XM]\u0001\u0005Y><\u0007%\u0001\u0006dYV\u001cH/\u001a:K[b,\"!a*\u0011\u000b\u001d\fI+!,\n\u0007\u0005-\u0006N\u0001\u0004PaRLwN\u001c\t\u0004G\u0006=\u0016bAAY;\nQ1\t\\;ti\u0016\u0014(*\u001c=\u0002\u001d\rdWo\u001d;fe*k\u0007p\u0018\u0013fcR!\u0011qWA_!\r9\u0017\u0011X\u0005\u0004\u0003wC'\u0001B+oSRD\u0011\"a0\u001c\u0003\u0003\u0005\r!a*\u0002\u0007a$\u0013'A\u0006dYV\u001cH/\u001a:K[b\u0004\u0013a\u00044bS2,(/\u001a#fi\u0016\u001cGo\u001c:\u0016\u0005\u0005\u001d\u0007CBAe\u0003\u001f\fI#\u0004\u0002\u0002L*\u0019\u0011QZ0\u0002\rI,Wn\u001c;f\u0013\u0011\t\t.a3\u0003/\u0019\u000b\u0017\u000e\\;sK\u0012+G/Z2u_J\u0014VmZ5tiJL\u0018\u0001\u00054bS2,(/\u001a#fi\u0016\u001cGo\u001c:!\u0003Y\u0019'o\\:t\t\u000e4\u0015-\u001b7ve\u0016$U\r^3di>\u0014\u0018aF2s_N\u001cHi\u0019$bS2,(/\u001a#fi\u0016\u001cGo\u001c:!\u0003=!wn\u001e8j]\u001e\u0004&o\u001c<jI\u0016\u0014XCAAo!\r\u0019\u0017q\\\u0005\u0004\u0003Cl&a\u0004#po:Lgn\u001a)s_ZLG-\u001a:\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XCAAt!\ri\u0017\u0011^\u0005\u0004\u0003Wt'!C*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u000fG2,8\u000f^3s\t\u0006,Wn\u001c8t+\t\t\u0019\u0010E\u0002n\u0003kL1!a>o\u0005!\t5\r^8s%\u00164\u0017aD2mkN$XM\u001d#bK6|gn\u001d\u0011\u0002\u0017\rdWo\u001d;fe\u000e{'/Z\u0001\rG2,8\u000f^3s\u0007>\u0014X\rI\u0001\te\u0016\fGMV5foV\u0011!1\u0001\t\u0004G\n\u0015\u0011b\u0001B\u0004;\ny1\t\\;ti\u0016\u0014(+Z1e-&,w/A\u0005sK\u0006$g+[3xA\u0005a\u0011n\u001d+fe6Lg.\u0019;fIV\u0011!q\u0002\t\u0004O\nE\u0011b\u0001B\nQ\n9!i\\8mK\u0006t\u0017!B:uCR,WC\u0001B\r!\u0011\u0011YB!\t\u000f\u0007\r\u0014i\"C\u0002\u0003 u\u000bAb\u00117vgR,'/\u0012<f]RLAAa\t\u0003&\t\u00192)\u001e:sK:$8\t\\;ti\u0016\u00148\u000b^1uK*\u0019!qD/\u0002\u0015M,GNZ'f[\n,'/\u0006\u0002\u0003,A\u00191M!\f\n\u0007\t=RL\u0001\u0004NK6\u0014WM]\u0001\ngV\u00147o\u0019:jE\u0016$b!a.\u00036\te\u0002b\u0002B\u001c[\u0001\u0007\u00111_\u0001\u000bgV\u00147o\u0019:jE\u0016\u0014\bb\u0002B\u001e[\u0001\u0007!QH\u0001\u0003i>\u0004Ra\u001aB \u0005\u0007J1A!\u0011i\u0005)a$/\u001a9fCR,GM\u0010\u0019\u0005\u0005\u000b\u0012y\u0005\u0005\u0004\u0002V\t\u001d#1J\u0005\u0005\u0005\u0013\n\tGA\u0003DY\u0006\u001c8\u000f\u0005\u0003\u0003N\t=C\u0002\u0001\u0003\r\u0005#\u0012I$!A\u0001\u0002\u000b\u0005!1\u000b\u0002\u0004?\u0012\n\u0014\u0003\u0002B+\u00057\u00022a\u001aB,\u0013\r\u0011I\u0006\u001b\u0002\b\u001d>$\b.\u001b8h!\r9'QL\u0005\u0004\u0005?B'aA!os\"\u001aQFa\u0019\u0011\t\t\u0015$1N\u0007\u0003\u0005OR1A!\u001bi\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005[\u00129GA\u0004wCJ\f'oZ:\u0015\u0011\u0005]&\u0011\u000fB:\u0005{BqAa\u000e/\u0001\u0004\t\u0019\u0010C\u0004\u0003v9\u0002\rAa\u001e\u0002!%t\u0017\u000e^5bYN#\u0018\r^3N_\u0012,\u0007\u0003\u0002B\u000e\u0005sJAAa\u001f\u0003&\ta2+\u001e2tGJL\u0007\u000f^5p]&s\u0017\u000e^5bYN#\u0018\r^3N_\u0012,\u0007b\u0002B\u001e]\u0001\u0007!q\u0010\t\u0006O\n}\"\u0011\u0011\u0019\u0005\u0005\u0007\u00139\t\u0005\u0004\u0002V\t\u001d#Q\u0011\t\u0005\u0005\u001b\u00129\t\u0002\u0007\u0003\n\nu\u0014\u0011!A\u0001\u0006\u0003\u0011\u0019FA\u0002`IIB3A\fB2\u0003-)hn];cg\u000e\u0014\u0018NY3\u0015\t\u0005]&\u0011\u0013\u0005\b\u0005oy\u0003\u0019AAz)\u0019\t9L!&\u0003\u0018\"9!q\u0007\u0019A\u0002\u0005M\bb\u0002B\u001ea\u0001\u0007!\u0011\u0014\u0019\u0005\u00057\u0013y\n\u0005\u0004\u0002V\t\u001d#Q\u0014\t\u0005\u0005\u001b\u0012y\n\u0002\u0007\u0003\"\n]\u0015\u0011!A\u0001\u0006\u0003\u0011\u0019FA\u0002`IM\nqc]3oI\u000e+(O]3oi\u000ecWo\u001d;feN#\u0018\r^3\u0015\t\u0005]&q\u0015\u0005\b\u0005S\u000b\u0004\u0019AAz\u0003!\u0011XmY3jm\u0016\u0014\u0018\u0001\u00026pS:$B!a.\u00030\"9!\u0011\u0017\u001aA\u0002\u0005%\u0012aB1eIJ,7o]\u0001\nM&dG\u000eT8dC2$B!!\u000b\u00038\"9!\u0011W\u001aA\u0002\u0005%\u0012!\u00046pS:\u001cV-\u001a3O_\u0012,7\u000f\u0006\u0003\u00028\nu\u0006b\u0002B`i\u0001\u0007!\u0011Y\u0001\ng\u0016,GMT8eKN\u0004bAa1\u0003N\u0006%RB\u0001Bc\u0015\u0011\u00119M!3\u0002\u0013%lW.\u001e;bE2,'b\u0001BfQ\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t='Q\u0019\u0002\u0004'\u0016\fH\u0003BA\\\u0005'DqAa06\u0001\u0004\u0011)\u000e\u0005\u0004\u0002p\t]\u0017\u0011F\u0005\u0005\u00053\f\tH\u0001\u0003MSN$\u0018!\u00027fCZ,G\u0003BA\\\u0005?DqA!-7\u0001\u0004\tI#\u0001\u0003e_^tG\u0003BA\\\u0005KDqA!-8\u0001\u0004\tI#\u0001\nsK\u001eL7\u000f^3s\u001f:lU-\u001c2feV\u0003X\u0003\u0002Bv\u0005s$B!a.\u0003n\"A!q\u001e\u001d\u0005\u0002\u0004\u0011\t0\u0001\u0003d_\u0012,\u0007#B4\u0003t\n]\u0018b\u0001B{Q\nAAHY=oC6,g\b\u0005\u0003\u0003N\teHa\u0002B~q\t\u0007!1\u000b\u0002\u0002)R!\u0011q\u0017B\u0000\u0011\u001d\u0019\t!\u000fa\u0001\u0007\u0007\t\u0001bY1mY\n\f7m\u001b\t\u0005\u0007\u000b\u0019Y!\u0004\u0002\u0004\b)!1\u0011BA;\u0003\u0011a\u0017M\\4\n\t\r51q\u0001\u0002\t%Vtg.\u00192mK\u00069\"/Z4jgR,'o\u00148NK6\u0014WM\u001d*f[>4X\rZ\u000b\u0005\u0007'\u0019Y\u0002\u0006\u0003\u00028\u000eU\u0001\u0002\u0003Bxu\u0011\u0005\raa\u0006\u0011\u000b\u001d\u0014\u0019p!\u0007\u0011\t\t531\u0004\u0003\b\u0005wT$\u0019\u0001B*)\u0011\t9la\b\t\u000f\r\u00051\b1\u0001\u0004\u0004\u0005a!/Z7pi\u0016\u0004\u0016\r\u001e5PMR!1QEB\u0016!\ri7qE\u0005\u0004\u0007Sq'!C!di>\u0014\b+\u0019;i\u0011\u001d\u0019i\u0003\u0010a\u0001\u0003g\f\u0001\"Y2u_J\u0014VMZ\u0001\tg\",H\u000fZ8x]R\u0011\u0011q\u0017\u0015\u0004{\rU\u0002\u0003BB\u001c\u0007wi!a!\u000f\u000b\u0007\t%t,\u0003\u0003\u0004>\re\"aC%oi\u0016\u0014h.\u00197Ba&\fab\u00197pg\u0016\u001c6\r[3ek2,'/A\u0007DYV\u001cH/\u001a:M_\u001e<WM\u001d\t\u0004\u0007\u000b\u0002U\"\u0001\u0005\u0003\u001b\rcWo\u001d;fe2{wmZ3s'\t\u0001e\r\u0006\u0002\u0004D\u0005q\u0011n\u001d#fEV<WI\\1cY\u0016$\u0017\u0001\u00037pO\u0012+'-^4\u0015\t\u0005]61\u000b\u0005\b\u0007+\u001a\u0005\u0019AA2\u0003\u001diWm]:bO\u0016$b!a.\u0004Z\ru\u0003bBB.\t\u0002\u0007\u00111M\u0001\ti\u0016l\u0007\u000f\\1uK\"91q\f#A\u0002\tm\u0013\u0001B1sOF\"\u0002\"a.\u0004d\r\u00154q\r\u0005\b\u00077*\u0005\u0019AA2\u0011\u001d\u0019y&\u0012a\u0001\u00057Bqa!\u001bF\u0001\u0004\u0011Y&\u0001\u0003be\u001e\u0014DCCA\\\u0007[\u001ayg!\u001d\u0004t!911\f$A\u0002\u0005\r\u0004bBB0\r\u0002\u0007!1\f\u0005\b\u0007S2\u0005\u0019\u0001B.\u0011\u001d\u0019)H\u0012a\u0001\u00057\nA!\u0019:hg\u00059An\\4J]\u001a|G\u0003BA\\\u0007wBqa!\u0016H\u0001\u0004\t\u0019\u0007\u0006\u0004\u00028\u000e}4\u0011\u0011\u0005\b\u00077B\u0005\u0019AA2\u0011\u001d\u0019y\u0006\u0013a\u0001\u00057\"\u0002\"a.\u0004\u0006\u000e\u001d5\u0011\u0012\u0005\b\u00077J\u0005\u0019AA2\u0011\u001d\u0019y&\u0013a\u0001\u00057Bqa!\u001bJ\u0001\u0004\u0011Y\u0006\u0006\u0006\u00028\u000e55qRBI\u0007'Cqaa\u0017K\u0001\u0004\t\u0019\u0007C\u0004\u0004`)\u0003\rAa\u0017\t\u000f\r%$\n1\u0001\u0003\\!91Q\u000f&A\u0002\tm\u0013A\u00037pO^\u000b'O\\5oOR!\u0011qWBM\u0011\u001d\u0019)f\u0013a\u0001\u0003G\"b!a.\u0004\u001e\u000e}\u0005bBB.\u0019\u0002\u0007\u00111\r\u0005\b\u0007?b\u0005\u0019\u0001B.)!\t9la)\u0004&\u000e\u001d\u0006bBB.\u001b\u0002\u0007\u00111\r\u0005\b\u0007?j\u0005\u0019\u0001B.\u0011\u001d\u0019I'\u0014a\u0001\u00057\"\"\"a.\u0004,\u000e56qVBY\u0011\u001d\u0019YF\u0014a\u0001\u0003GBqaa\u0018O\u0001\u0004\u0011Y\u0006C\u0004\u0004j9\u0003\rAa\u0017\t\u000f\rUd\n1\u0001\u0003\\\u0005AAn\\4FeJ|'\u000f\u0006\u0003\u00028\u000e]\u0006bBB+\u001f\u0002\u0007\u00111\r\u000b\u0007\u0003o\u001bYl!0\t\u000f\rm\u0003\u000b1\u0001\u0002d!91q\f)A\u0002\tmC\u0003CA\\\u0007\u0003\u001c\u0019m!2\t\u000f\rm\u0013\u000b1\u0001\u0002d!91qL)A\u0002\tm\u0003bBB5#\u0002\u0007!1\f\u000b\u000b\u0003o\u001bIma3\u0004N\u000e=\u0007bBB.%\u0002\u0007\u00111\r\u0005\b\u0007?\u0012\u0006\u0019\u0001B.\u0011\u001d\u0019IG\u0015a\u0001\u00057Bqa!\u001eS\u0001\u0004\u0011Y\u0006\u0006\u0004\u00028\u000eM7\u0011\u001e\u0005\b\u0007+\u001c\u0006\u0019ABl\u0003\u0015\u0019\u0017-^:f!\u0011\u0019Ina9\u000f\t\rm7q\u001c\b\u0005\u0003w\u0019i.C\u0001j\u0013\r\u0019\t\u000f[\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0019)oa:\u0003\u0013QC'o\\<bE2,'bABqQ\"91QK*A\u0002\u0005\rD\u0003CA\\\u0007[\u001cyo!=\t\u000f\rUG\u000b1\u0001\u0004X\"911\f+A\u0002\u0005\r\u0004bBB0)\u0002\u0007!1\f\u000b\u000b\u0003o\u001b)pa>\u0004z\u000em\bbBBk+\u0002\u00071q\u001b\u0005\b\u00077*\u0006\u0019AA2\u0011\u001d\u0019y&\u0016a\u0001\u00057Bqa!\u001bV\u0001\u0004\u0011Y\u0006\u0006\u0007\u00028\u000e}H\u0011\u0001C\u0002\t\u000b!9\u0001C\u0004\u0004VZ\u0003\raa6\t\u000f\rmc\u000b1\u0001\u0002d!91q\f,A\u0002\tm\u0003bBB5-\u0002\u0007!1\f\u0005\b\u0007k2\u0006\u0019\u0001B.\u0003)awnZ!u\u0019\u00164X\r\u001c\u000b\u0007\u0003o#i\u0001b\t\t\u000f\u0011=q\u000b1\u0001\u0005\u0012\u0005AAn\\4MKZ,G\u000e\u0005\u0003\u0005\u0014\u0011ua\u0002\u0002C\u000b\t3qA!!\u000f\u0005\u0018%\u0019\u00111T0\n\t\u0011m\u0011\u0011T\u0001\b\u0019><w-\u001b8h\u0013\u0011!y\u0002\"\t\u0003\u00111{w\rT3wK2TA\u0001b\u0007\u0002\u001a\"91QK,A\u0002\u0005\rD\u0003CA\\\tO!I\u0003b\u000b\t\u000f\u0011=\u0001\f1\u0001\u0005\u0012!911\f-A\u0002\u0005\r\u0004bBB01\u0002\u0007!1\f\u000b\u000b\u0003o#y\u0003\"\r\u00054\u0011U\u0002b\u0002C\b3\u0002\u0007A\u0011\u0003\u0005\b\u00077J\u0006\u0019AA2\u0011\u001d\u0019y&\u0017a\u0001\u00057Bqa!\u001bZ\u0001\u0004\u0011Y\u0006\u0006\u0007\u00028\u0012eB1\bC\u001f\t\u007f!\t\u0005C\u0004\u0005\u0010i\u0003\r\u0001\"\u0005\t\u000f\rm#\f1\u0001\u0002d!91q\f.A\u0002\tm\u0003bBB55\u0002\u0007!1\f\u0005\b\u0007kR\u0006\u0019\u0001B.\u00039I7\u000fT3wK2,e.\u00192mK\u0012$BAa\u0004\u0005H!9AqB.A\u0002\u0011E\u0001cA7\u0005L%\u0019AQ\n8\u0003'\u0015CH/\u001a8tS>t\u0017\n\u001a)s_ZLG-\u001a:\u0015\u0003\t\f1aZ3u)\r\u0011HQ\u000b\u0005\u0007o\u000e\u0001\r\u0001b\u0016\u0011\u00075$I&C\u0002\u0005\\9\u00141\"Q2u_J\u001c\u0016p\u001d;f[\u00061An\\8lkB$\"\u0001\"\u0019\u000f\u0005\r\u0004\u0011aD2sK\u0006$X-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0007I$9\u0007C\u0003x\u000b\u0001\u0007\u00110A\rjg\u0006\u001b8/\u001a:u\u0013:4\u0018M]5b]R\u001cXI\\1cY\u0016$\u0017AG5t\u0003N\u001cXM\u001d;J]Z\f'/[1oiN,e.\u00192mK\u0012\u0004\u0003")
public class Cluster
implements Extension {
    private DowningProvider downingProvider;
    private volatile Cluster$ClusterLogger$ ClusterLogger$module;
    private final ExtendedActorSystem system;
    private final ClusterSettings settings;
    private final JoinConfigCompatChecker joinConfigCompatChecker;
    private final UniqueAddress selfUniqueAddress;
    private final AtomicBoolean _isTerminated;
    private final LoggingAdapter akka$cluster$Cluster$$log;
    private Option<ClusterJmx> clusterJmx;
    private final FailureDetectorRegistry<Address> failureDetector;
    private final FailureDetectorRegistry<Address> crossDcFailureDetector;
    private final Scheduler scheduler;
    private final ActorRef clusterDaemons;
    private final ActorRef clusterCore;
    private final ClusterReadView readView;
    private volatile boolean bitmap$0;

    public static Cluster createExtension(ExtendedActorSystem extendedActorSystem) {
        return Cluster$.MODULE$.createExtension(extendedActorSystem);
    }

    public static Cluster$ lookup() {
        return Cluster$.MODULE$.lookup();
    }

    public static Cluster get(ActorSystem actorSystem) {
        return Cluster$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return Cluster$.MODULE$.apply(actorSystem);
    }

    public Cluster$ClusterLogger$ ClusterLogger() {
        if (this.ClusterLogger$module == null) {
            this.ClusterLogger$lzycompute$1();
        }
        return this.ClusterLogger$module;
    }

    public void subscribe(ActorRef subscriber, Class<?> ... to) {
        this.subscribe(subscriber, (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])to));
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Class<?> ... to) {
        this.subscribe(subscriber, initialStateMode, (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])to));
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ClusterSettings settings() {
        return this.settings;
    }

    private JoinConfigCompatChecker joinConfigCompatChecker() {
        return this.joinConfigCompatChecker;
    }

    public UniqueAddress selfUniqueAddress() {
        return this.selfUniqueAddress;
    }

    public Address selfAddress() {
        return this.selfUniqueAddress().address();
    }

    public String selfDataCenter() {
        return this.settings().SelfDataCenter();
    }

    public scala.collection.immutable.Set<String> selfRoles() {
        return this.settings().Roles();
    }

    public Set<String> getSelfRoles() {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.selfRoles()).asJava();
    }

    private AtomicBoolean _isTerminated() {
        return this._isTerminated;
    }

    public LoggingAdapter akka$cluster$Cluster$$log() {
        return this.akka$cluster$Cluster$$log;
    }

    private Option<ClusterJmx> clusterJmx() {
        return this.clusterJmx;
    }

    private void clusterJmx_$eq(Option<ClusterJmx> x$1) {
        this.clusterJmx = x$1;
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public FailureDetectorRegistry<Address> crossDcFailureDetector() {
        return this.crossDcFailureDetector;
    }

    private DowningProvider downingProvider$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (!this.bitmap$0) {
                this.downingProvider = DowningProvider$.MODULE$.load(this.settings().DowningProviderClassName(), (ActorSystem)this.system());
                this.bitmap$0 = true;
            }
        }
        return this.downingProvider;
    }

    public DowningProvider downingProvider() {
        return !this.bitmap$0 ? this.downingProvider$lzycompute() : this.downingProvider;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    private ActorRef clusterDaemons() {
        return this.clusterDaemons;
    }

    public ActorRef clusterCore() {
        return this.clusterCore;
    }

    public ClusterReadView readView() {
        return this.readView;
    }

    public boolean isTerminated() {
        return this._isTerminated().get();
    }

    public ClusterEvent.CurrentClusterState state() {
        return this.readView().state();
    }

    public Member selfMember() {
        return this.readView().self();
    }

    public void subscribe(ActorRef subscriber, Seq<Class<?>> to) {
        this.subscribe(subscriber, (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent$InitialStateAsSnapshot$.MODULE$, to);
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Seq<Class<?>> to) {
        Predef$.MODULE$.require(to.length() > 0, (Function0 & Serializable & scala.Serializable)() -> "at least one `ClusterDomainEvent` class is required");
        Predef$.MODULE$.require(to.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Cluster.$anonfun$subscribe$2(x$1))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("subscribe to `akka.cluster.ClusterEvent.ClusterDomainEvent` or subclasses, was [").append(((TraversableOnce)to.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), scala.collection.Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("]").toString());
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Subscribe x$12 = new InternalClusterAction.Subscribe(subscriber, initialStateMode, to.toSet());
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$12);
        qual$1.$bang((Object)x$12, x$2);
    }

    public void unsubscribe(ActorRef subscriber) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Unsubscribe x$1 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)None$.MODULE$);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void unsubscribe(ActorRef subscriber, Class<?> to) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Unsubscribe x$1 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)new Some(to));
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void sendCurrentClusterState(ActorRef receiver) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.SendCurrentClusterState x$1 = new InternalClusterAction.SendCurrentClusterState(receiver);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void join(Address address) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.JoinTo x$1 = new ClusterUserAction.JoinTo(this.fillLocal(address));
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Address fillLocal(Address address) {
        Address address2;
        if (address.hasLocalScope()) {
            String string = address.system();
            String string2 = this.selfAddress().system();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                address2 = this.selfAddress();
                return address2;
            }
        }
        address2 = address;
        return address2;
    }

    public void joinSeedNodes(scala.collection.immutable.Seq<Address> seedNodes) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.JoinSeedNodes x$1 = new InternalClusterAction.JoinSeedNodes((IndexedSeq<Address>)((IndexedSeq)seedNodes.toVector().map((Function1 & Serializable & scala.Serializable)address -> this.fillLocal((Address)address), Vector$.MODULE$.canBuildFrom())));
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void joinSeedNodes(List<Address> seedNodes) {
        this.joinSeedNodes((scala.collection.immutable.Seq<Address>)Util$.MODULE$.immutableSeq(seedNodes));
    }

    public void leave(Address address) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.Leave x$1 = new ClusterUserAction.Leave(this.fillLocal(address));
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public void down(Address address) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.Down x$1 = new ClusterUserAction.Down(this.fillLocal(address));
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public <T> void registerOnMemberUp(Function0<T> code) {
        this.registerOnMemberUp(new Runnable(null, code){
            private final Function0 code$1;

            public void run() {
                this.code$1.apply();
            }
            {
                this.code$1 = code$1;
            }
        });
    }

    public void registerOnMemberUp(Runnable callback) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterDaemons());
        InternalClusterAction.AddOnMemberUpListener x$1 = new InternalClusterAction.AddOnMemberUpListener(callback);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    public <T> void registerOnMemberRemoved(Function0<T> code) {
        this.registerOnMemberRemoved(new Runnable(null, code){
            private final Function0 code$2;

            public void run() {
                this.code$2.apply();
            }
            {
                this.code$2 = code$2;
            }
        });
    }

    public void registerOnMemberRemoved(Runnable callback) {
        if (this._isTerminated().get()) {
            callback.run();
        } else {
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterDaemons());
            InternalClusterAction.AddOnMemberRemovedListener x$1 = new InternalClusterAction.AddOnMemberRemovedListener(callback);
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
        }
    }

    public ActorPath remotePathOf(ActorRef actorRef) {
        ActorPath actorPath;
        ActorPath path = actorRef.path();
        if (path.address().host().isDefined()) {
            actorPath = path;
        } else {
            RootActorPath qual$1 = path.root();
            Address x$1 = this.selfAddress();
            String x$2 = qual$1.copy$default$2();
            actorPath = qual$1.copy(x$1, x$2).$div((Iterable)path.elements()).withUid(path.uid());
        }
        return actorPath;
    }

    @InternalApi
    public void shutdown() {
        block1: {
            if (!this._isTerminated().compareAndSet(false, true)) break block1;
            this.ClusterLogger().logInfo("Shutting down...");
            this.system().stop(this.clusterDaemons());
            if (this.readView() != null) {
                this.readView().close();
            }
            this.closeScheduler();
            this.clusterJmx().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.unregisterMBean();
                return BoxedUnit.UNIT;
            });
            this.ClusterLogger().logInfo("Successfully shut down");
        }
    }

    private void closeScheduler() {
        Scheduler scheduler = this.scheduler();
        if (scheduler instanceof Closeable) {
            Scheduler scheduler2 = scheduler;
            ((Closeable)scheduler2).close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final void ClusterLogger$lzycompute$1() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (this.ClusterLogger$module == null) {
                this.ClusterLogger$module = new Cluster$ClusterLogger$(this);
            }
        }
    }

    private final ActorRef liftedTree1$1(Timeout timeout$1) {
        ActorRef actorRef;
        try {
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.clusterDaemons());
            InternalClusterAction$GetClusterCoreRef$ x$1 = InternalClusterAction$GetClusterCoreRef$.MODULE$;
            Timeout x$2 = timeout$1;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            actorRef = (ActorRef)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3).mapTo(ClassTag$.MODULE$.apply(ActorRef.class)), (Duration)timeout$1.duration());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.akka$cluster$Cluster$$log().error(e, "Failed to startup Cluster. You can try to increase 'akka.actor.creation-timeout'.");
            this.shutdown();
            ActorRef actorRef2 = this.system().deadLetters();
            actorRef = actorRef2;
        }
        return actorRef;
    }

    public static final /* synthetic */ boolean $anonfun$subscribe$2(Class x$1) {
        return ClusterEvent.ClusterDomainEvent.class.isAssignableFrom(x$1);
    }

    public Cluster(ExtendedActorSystem system) {
        Scheduler scheduler;
        this.system = system;
        this.settings = new ClusterSettings(system.settings().config(), system.name());
        this.joinConfigCompatChecker = JoinConfigCompatChecker$.MODULE$.load(system, this.settings());
        ActorRefProvider actorRefProvider = system.provider();
        if (!(actorRefProvider instanceof ClusterActorRefProvider)) {
            throw new ConfigurationException(new StringBuilder(107).append("ActorSystem [").append(system).append("] needs to have 'akka.actor.provider' set to 'cluster' in the configuration, currently uses [").append(actorRefProvider.getClass().getName()).append("]").toString());
        }
        ClusterActorRefProvider clusterActorRefProvider = (ClusterActorRefProvider)actorRefProvider;
        UniqueAddress uniqueAddress = new UniqueAddress(clusterActorRefProvider.transport().defaultAddress(), ((AddressUidExtension)AddressUidExtension$.MODULE$.apply((ActorSystem)system)).longAddressUid());
        this.selfUniqueAddress = uniqueAddress;
        this._isTerminated = new AtomicBoolean(false);
        this.akka$cluster$Cluster$$log = Logging$.MODULE$.apply((ActorSystem)system, (Object)this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.clusterJmx = None$.MODULE$;
        this.ClusterLogger().logInfo("Starting up, Akka version [{}] ...", system.settings().ConfigVersion());
        Function0 & Serializable & scala.Serializable createFailureDetector = (Function0 & Serializable & scala.Serializable)() -> FailureDetectorLoader$.MODULE$.load(this.settings().FailureDetectorImplementationClass(), this.settings().FailureDetectorConfig(), (ActorSystem)this.system());
        this.failureDetector = new DefaultFailureDetectorRegistry((Function0)createFailureDetector);
        Function0 & Serializable & scala.Serializable createFailureDetector2 = (Function0 & Serializable & scala.Serializable)() -> FailureDetectorLoader$.MODULE$.load(this.settings().MultiDataCenter().CrossDcFailureDetectorSettings().ImplementationClass(), this.settings().MultiDataCenter().CrossDcFailureDetectorSettings().config(), (ActorSystem)this.system());
        this.crossDcFailureDetector = new DefaultFailureDetectorRegistry((Function0)createFailureDetector2);
        package.DurationInt durationInt = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1));
        if (system.scheduler().maxFrequency() < durationInt.second().$div((Duration)this.settings().SchedulerTickDuration())) {
            ThreadFactory threadFactory;
            this.ClusterLogger().logInfo("Using a dedicated scheduler for cluster. Default scheduler can be used if configured with 'akka.scheduler.tick-duration' [{} ms] <=  'akka.cluster.scheduler.tick-duration' [{} ms].", BoxesRunTime.boxToInteger((int)((int)((double)1000 / system.scheduler().maxFrequency()))), BoxesRunTime.boxToLong((long)this.settings().SchedulerTickDuration().toMillis()));
            Config cfg = ConfigFactory.parseString((String)new StringBuilder(31).append("akka.scheduler.tick-duration=").append(this.settings().SchedulerTickDuration().toMillis()).append("ms").toString()).withFallback((ConfigMergeable)system.settings().config());
            ThreadFactory threadFactory2 = system.threadFactory();
            if (threadFactory2 instanceof MonitorableThreadFactory) {
                MonitorableThreadFactory monitorableThreadFactory = (MonitorableThreadFactory)threadFactory2;
                threadFactory = monitorableThreadFactory.withName(new StringBuilder(18).append(monitorableThreadFactory.name()).append("-cluster-scheduler").toString());
            } else {
                threadFactory = threadFactory2;
            }
            ThreadFactory threadFactory3 = threadFactory;
            scheduler = (Scheduler)system.dynamicAccess().createInstanceFor(system.settings().SchedulerClass(), (scala.collection.immutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Config.class), (Object)cfg), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(LoggingAdapter.class), (Object)this.akka$cluster$Cluster$$log()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ThreadFactory.class), (Object)threadFactory3)})), ClassTag$.MODULE$.apply(Scheduler.class)).get();
        } else {
            Scheduler systemScheduler = system.scheduler();
            scheduler = new Scheduler(null, systemScheduler){
                private final Scheduler systemScheduler$1;

                public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.schedule$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final ActorRef schedule$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
                    return Scheduler.schedule$default$6$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message);
                }

                public final Cancellable schedule(java.time.Duration initialDelay, java.time.Duration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.schedule$((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Function0<BoxedUnit> f, ExecutionContext executor) {
                    return Scheduler.schedule$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, f, (ExecutionContext)executor);
                }

                public Cancellable schedule(java.time.Duration initialDelay, java.time.Duration interval, Runnable runnable, ExecutionContext executor) {
                    return Scheduler.schedule$((Scheduler)this, (java.time.Duration)initialDelay, (java.time.Duration)interval, (Runnable)runnable, (ExecutionContext)executor);
                }

                public final Cancellable scheduleOnce(FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final ActorRef scheduleOnce$default$5(FiniteDuration delay, ActorRef receiver, Object message) {
                    return Scheduler.scheduleOnce$default$5$((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message);
                }

                public final Cancellable scheduleOnce(java.time.Duration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (java.time.Duration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final Cancellable scheduleOnce(FiniteDuration delay, Function0<BoxedUnit> f, ExecutionContext executor) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (FiniteDuration)delay, f, (ExecutionContext)executor);
                }

                public Cancellable scheduleOnce(java.time.Duration delay, Runnable runnable, ExecutionContext executor) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (java.time.Duration)delay, (Runnable)runnable, (ExecutionContext)executor);
                }

                public void close() {
                }

                public double maxFrequency() {
                    return this.systemScheduler$1.maxFrequency();
                }

                public Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable, ExecutionContext executor) {
                    return this.systemScheduler$1.schedule(initialDelay, interval, runnable, executor);
                }

                public Cancellable scheduleOnce(FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
                    return this.systemScheduler$1.scheduleOnce(delay, runnable, executor);
                }
                {
                    this.systemScheduler$1 = systemScheduler$1;
                    Scheduler.$init$((Scheduler)this);
                }
            };
        }
        this.scheduler = scheduler;
        this.clusterDaemons = system.systemActorOf(Props$.MODULE$.apply(ClusterDaemon.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.joinConfigCompatChecker()})).withDispatcher(this.settings().UseDispatcher()).withDeploy(Deploy$.MODULE$.local()), "cluster");
        Timeout timeout = system.settings().CreationTimeout();
        this.clusterCore = this.liftedTree1$1(timeout);
        this.readView = new ClusterReadView(this);
        system.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.shutdown());
        if (this.settings().JmxEnabled()) {
            ClusterJmx jmx = new ClusterJmx(this, this.akka$cluster$Cluster$$log());
            jmx.createMBean();
            this.clusterJmx_$eq((Option<ClusterJmx>)new Some((Object)jmx));
        }
        this.ClusterLogger().logInfo("Started up successfully");
    }
}

