/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.annotation.InternalApi;
import akka.cluster.Gossip;
import akka.cluster.Member;
import akka.cluster.MembershipState;
import akka.cluster.UniqueAddress;
import java.util.concurrent.ThreadLocalRandom;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericCompanion;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001u4QAD\b\u0001#MA\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\b\u0005\t?\u0001\u0011\t\u0011)A\u00059!)\u0001\u0005\u0001C\u0001C!)a\u0005\u0001C\u0003O!)1\u0007\u0001C\u0003i!)!\t\u0001C\u0001\u0007\")!\n\u0001C\t\u0017\")Q\n\u0001C\t\u001d\")\u0001\u000b\u0001C\t#\")A\u000b\u0001C\t+\")!\f\u0001C\t7\")Q\f\u0001C\t=\")q\u000e\u0001C\ta\n!ri\\:tSB$\u0016M]4fiN+G.Z2u_JT!\u0001E\t\u0002\u000f\rdWo\u001d;fe*\t!#\u0001\u0003bW.\f7C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fM\u0006!#/\u001a3vG\u0016<un]:ja\u0012KgMZ3sK:$h+[3x!J|'-\u00192jY&$\u0018p\u0001\u0001\u0011\u0005Ui\u0012B\u0001\u0010\u0017\u0005\u0019!u.\u001e2mK\u0006A2M]8tg\u0012\u001bwi\\:tSB\u0004&o\u001c2bE&d\u0017\u000e^=\u0002\rqJg.\u001b;?)\r\u0011C%\n\t\u0003G\u0001i\u0011a\u0004\u0005\u00065\r\u0001\r\u0001\b\u0005\u0006?\r\u0001\r\u0001H\u0001\rO>\u001c8/\u001b9UCJ<W\r\u001e\u000b\u0003Q9\u00022!F\u0015,\u0013\tQcC\u0001\u0004PaRLwN\u001c\t\u0003G1J!!L\b\u0003\u001bUs\u0017.];f\u0003\u0012$'/Z:t\u0011\u0015yC\u00011\u00011\u0003\u0015\u0019H/\u0019;f!\t\u0019\u0013'\u0003\u00023\u001f\tyQ*Z7cKJ\u001c\b.\u001b9Ti\u0006$X-A\u0007h_N\u001c\u0018\u000e\u001d+be\u001e,Go\u001d\u000b\u0003k\u0005\u00032A\u000e ,\u001d\t9DH\u0004\u00029w5\t\u0011H\u0003\u0002;7\u00051AH]8pizJ\u0011aF\u0005\u0003{Y\tq\u0001]1dW\u0006<W-\u0003\u0002@\u0001\n1a+Z2u_JT!!\u0010\f\t\u000b=*\u0001\u0019\u0001\u0019\u00021I\fg\u000eZ8n\u001d>$Wm\u001d$pe\u001a+H\u000e\\$pgNL\u0007\u000fF\u00026\t\u0016CQa\f\u0004A\u0002ABQA\u0012\u0004A\u0002\u001d\u000b\u0011A\u001c\t\u0003+!K!!\u0013\f\u0003\u0007%sG/\u0001\u000bm_\u000e\fG\u000eR2H_N\u001c\u0018\u000e\u001d+be\u001e,Go\u001d\u000b\u0003k1CQaL\u0004A\u0002A\nA#\\;mi&$5mR8tg&\u0004H+\u0019:hKR\u001cHCA\u001bP\u0011\u0015y\u0003\u00021\u00011\u0003\u0019\nGM[;ti\u0016$wi\\:tSB$\u0015N\u001a4fe\u0016tGOV5foB\u0013xNY1cS2LG/\u001f\u000b\u00039ICQaU\u0005A\u0002\u001d\u000b1b\u00197vgR,'oU5{K\u0006\u00112/\u001a7fGR$5\rT8dC2tu\u000eZ3t)\t1\u0016\f\u0005\u0002\u0016/&\u0011\u0001L\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015y#\u00021\u00011\u0003q\u0001(/\u001a4fe:{G-Z:XSRDG)\u001b4gKJ,g\u000e\u001e,jK^$\"A\u0016/\t\u000b=Z\u0001\u0019\u0001\u0019\u0002!\u0011\u001c7/\u00138SC:$w.\\(sI\u0016\u0014HCA0n!\r1\u0004MY\u0005\u0003C\u0002\u0013A\u0001T5tiB\u00111M\u001b\b\u0003I\"t!!Z4\u000f\u0005a2\u0017\"\u0001\n\n\u0005A\t\u0012BA5\u0010\u0003=\u0019E.^:uKJ\u001cV\r\u001e;j]\u001e\u001c\u0018BA6m\u0005)!\u0015\r^1DK:$XM\u001d\u0006\u0003S>AQA\u001c\u0007A\u0002}\u000b1\u0001Z2t\u0003A\u0019X\r\\3diJ\u000bg\u000eZ8n\u001d>$W\r\u0006\u0002)c\")!/\u0004a\u0001g\u0006)an\u001c3fgB\u0019a\u0007^\u0016\n\u0005U\u0004%AC%oI\u0016DX\rZ*fc\"\u0012\u0001a\u001e\t\u0003qnl\u0011!\u001f\u0006\u0003uF\t!\"\u00198o_R\fG/[8o\u0013\ta\u0018PA\u0006J]R,'O\\1m\u0003BL\u0007")
@InternalApi
public class GossipTargetSelector {
    private final double reduceGossipDifferentViewProbability;
    private final double crossDcGossipProbability;

    public final Option<UniqueAddress> gossipTarget(MembershipState state) {
        return this.selectRandomNode((IndexedSeq<UniqueAddress>)this.gossipTargets(state));
    }

    public final Vector<UniqueAddress> gossipTargets(MembershipState state) {
        return state.latestGossip().isMultiDc() ? this.multiDcGossipTargets(state) : this.localDcGossipTargets(state);
    }

    public Vector<UniqueAddress> randomNodesForFullGossip(MembershipState state, int n) {
        Vector vector;
        if (state.latestGossip().isMultiDc() && ((SetLike)state.ageSortedTopOldestMembersPerDc().apply((Object)state.selfDc())).contains((Object)state.selfMember())) {
            Vector vector2;
            Vector randomLocalNodes = (Vector)Random$.MODULE$.shuffle((TraversableOnce)state.members().toVector().collect((PartialFunction)new Serializable(null, state){
                public static final long serialVersionUID = 0L;
                private final MembershipState state$1;

                public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    String string = A1.dataCenter();
                    String string2 = this.state$1.selfDc();
                    Object object = !(string != null ? !string.equals(string2) : string2 != null) && this.state$1.validNodeForGossip(A1.uniqueAddress()) ? A1.uniqueAddress() : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Member x1) {
                    Member member = x1;
                    String string = member.dataCenter();
                    String string2 = this.state$1.selfDc();
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null) && this.state$1.validNodeForGossip(member.uniqueAddress());
                    return bl;
                }
                {
                    this.state$1 = state$1;
                }
            }, Vector$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom());
            List otherDcs = (List)Random$.MODULE$.shuffle((TraversableOnce)state.ageSortedTopOldestMembersPerDc().keySet().$minus((Object)state.selfDc()).toList(), List$.MODULE$.canBuildFrom());
            Option option = this.selectOtherDcNode$1(otherDcs, state);
            if (option instanceof Some) {
                Some some = (Some)option;
                UniqueAddress node = (UniqueAddress)some.value();
                vector2 = (Vector)randomLocalNodes.take(n - 1).$colon$plus((Object)node, Vector$.MODULE$.canBuildFrom());
            } else if (None$.MODULE$.equals(option)) {
                vector2 = randomLocalNodes.take(n);
            } else {
                throw new MatchError((Object)option);
            }
            vector = vector2;
        } else {
            Vector selectedNodes = (Vector)state.members().toVector().collect((PartialFunction)new Serializable(null, state){
                public static final long serialVersionUID = 0L;
                private final MembershipState state$1;

                public final <A1 extends Member, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    String string = A1.dataCenter();
                    String string2 = this.state$1.selfDc();
                    Object object = !(string != null ? !string.equals(string2) : string2 != null) && this.state$1.validNodeForGossip(A1.uniqueAddress()) ? A1.uniqueAddress() : function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Member x2) {
                    Member member = x2;
                    String string = member.dataCenter();
                    String string2 = this.state$1.selfDc();
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null) && this.state$1.validNodeForGossip(member.uniqueAddress());
                    return bl;
                }
                {
                    this.state$1 = state$1;
                }
            }, Vector$.MODULE$.canBuildFrom());
            vector = selectedNodes.size() <= n ? selectedNodes : ((Vector)Random$.MODULE$.shuffle((TraversableOnce)selectedNodes, Vector$.MODULE$.canBuildFrom())).take(n);
        }
        return vector;
    }

    /*
     * WARNING - void declaration
     */
    public Vector<UniqueAddress> localDcGossipTargets(MembershipState state) {
        void var3_3;
        Gossip latestGossip = state.latestGossip();
        Vector firstSelection = this.preferNodesWithDifferentView(state) ? (Vector)latestGossip.members().iterator().collect((PartialFunction)new Serializable(null, state, latestGossip){
            public static final long serialVersionUID = 0L;
            private final MembershipState state$2;
            private final Gossip latestGossip$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                String string = A1.dataCenter();
                String string2 = this.state$2.selfDc();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    if (!this.latestGossip$1.seenByNode(A1.uniqueAddress()) && this.state$2.validNodeForGossip(A1.uniqueAddress())) {
                        object = A1.uniqueAddress();
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Member x1) {
                Member member = x1;
                String string = member.dataCenter();
                String string2 = this.state$2.selfDc();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                if (this.latestGossip$1.seenByNode(member.uniqueAddress())) return false;
                if (!this.state$2.validNodeForGossip(member.uniqueAddress())) return false;
                return true;
            }
            {
                this.state$2 = state$2;
                this.latestGossip$1 = latestGossip$1;
            }
        }).to(akka.util.ccompat.package$.MODULE$.genericCompanionToCBF((GenericCompanion)scala.package$.MODULE$.Vector())) : scala.package$.MODULE$.Vector().empty();
        return firstSelection.isEmpty() ? (Vector)latestGossip.members().toVector().collect((PartialFunction)new Serializable(null, state){
            public static final long serialVersionUID = 0L;
            private final MembershipState state$2;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                String string = A1.dataCenter();
                String string2 = this.state$2.selfDc();
                Object object = !(string != null ? !string.equals(string2) : string2 != null) && this.state$2.validNodeForGossip(A1.uniqueAddress()) ? A1.uniqueAddress() : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Member x2) {
                Member member = x2;
                String string = member.dataCenter();
                String string2 = this.state$2.selfDc();
                boolean bl = !(string != null ? !string.equals(string2) : string2 != null) && this.state$2.validNodeForGossip(member.uniqueAddress());
                return bl;
            }
            {
                this.state$2 = state$2;
            }
        }, Vector$.MODULE$.canBuildFrom()) : var3_3;
    }

    public Vector<UniqueAddress> multiDcGossipTargets(MembershipState state) {
        List<String> otherDcsInRandomOrder;
        Vector<UniqueAddress> nodes2;
        Map<String, SortedSet<Member>> nodesPerDc;
        return this.selectDcLocalNodes(state) ? this.localDcGossipTargets(state) : (!((SetLike)(nodesPerDc = state.ageSortedTopOldestMembersPerDc()).apply((Object)state.selfDc())).contains((Object)state.selfMember()) ? this.localDcGossipTargets(state) : ((nodes2 = this.findFirstDcWithValidNodes$1(otherDcsInRandomOrder = this.dcsInRandomOrder((List<String>)nodesPerDc.$minus((Object)state.selfDc()).keys().toList()), nodesPerDc, state)).nonEmpty() ? nodes2 : this.localDcGossipTargets(state)));
    }

    public double adjustedGossipDifferentViewProbability(int clusterSize) {
        double d;
        double low = this.reduceGossipDifferentViewProbability;
        double high = low * (double)3;
        if ((double)clusterSize <= low) {
            d = this.reduceGossipDifferentViewProbability;
        } else {
            double minP = this.reduceGossipDifferentViewProbability / (double)10;
            if ((double)clusterSize >= high) {
                d = minP;
            } else {
                double k = (minP - this.reduceGossipDifferentViewProbability) / (high - low);
                d = this.reduceGossipDifferentViewProbability + ((double)clusterSize - low) * k;
            }
        }
        return d;
    }

    public boolean selectDcLocalNodes(MembershipState state) {
        int localMembers = state.dcMembers().size();
        double probability = localMembers > 4 ? this.crossDcGossipProbability : package$.MODULE$.max((double)(5 - localMembers) * 0.25, this.crossDcGossipProbability);
        return ThreadLocalRandom.current().nextDouble() > probability;
    }

    public boolean preferNodesWithDifferentView(MembershipState state) {
        return ThreadLocalRandom.current().nextDouble() < this.adjustedGossipDifferentViewProbability(state.latestGossip().members().size());
    }

    public List<String> dcsInRandomOrder(List<String> dcs) {
        return (List)Random$.MODULE$.shuffle(dcs, List$.MODULE$.canBuildFrom());
    }

    public Option<UniqueAddress> selectRandomNode(IndexedSeq<UniqueAddress> nodes2) {
        return nodes2.isEmpty() ? None$.MODULE$ : new Some(nodes2.apply(ThreadLocalRandom.current().nextInt(nodes2.size())));
    }

    private final Option selectOtherDcNode$1(List randomizedDcs, MembershipState state$1) {
        None$ none$;
        block2: {
            List list;
            block3: {
                Option option;
                block4: {
                    while (true) {
                        if (Nil$.MODULE$.equals(list = randomizedDcs)) {
                            none$ = None$.MODULE$;
                            break block2;
                        }
                        if (!(list instanceof .colon.colon)) break block3;
                        .colon.colon colon2 = (.colon.colon)list;
                        String dc = (String)colon2.head();
                        List tail = colon2.tl$access$1();
                        option = ((TraversableOnce)state$1.ageSortedTopOldestMembersPerDc().apply((Object)dc)).collectFirst((PartialFunction)new Serializable(null, state$1){
                            public static final long serialVersionUID = 0L;
                            private final MembershipState state$1;

                            public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                Object object = this.state$1.validNodeForGossip(A1.uniqueAddress()) ? A1.uniqueAddress() : function1.apply(x1);
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Member x1) {
                                Member member = x1;
                                boolean bl = this.state$1.validNodeForGossip(member.uniqueAddress());
                                return bl;
                            }
                            {
                                this.state$1 = state$1;
                            }
                        });
                        if (option instanceof Some) break block4;
                        if (!None$.MODULE$.equals(option)) break;
                        randomizedDcs = tail;
                    }
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                UniqueAddress addr = (UniqueAddress)some.value();
                Some some2 = new Some((Object)addr);
                none$ = some2;
                break block2;
            }
            throw new MatchError((Object)list);
        }
        return none$;
    }

    private final Vector findFirstDcWithValidNodes$1(List left, Map nodesPerDc$1, MembershipState state$3) {
        Vector vector;
        block4: {
            List list;
            while ((list = left) instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                String dc = (String)colon2.head();
                List tail = colon2.tl$access$1();
                SortedSet validNodes = (SortedSet)((TraversableLike)nodesPerDc$1.apply((Object)dc)).collect((PartialFunction)new Serializable(null, state$3){
                    public static final long serialVersionUID = 0L;
                    private final MembershipState state$3;

                    public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        Object object = this.state$3.validNodeForGossip(A1.uniqueAddress()) ? A1.uniqueAddress() : function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Member x1) {
                        Member member = x1;
                        boolean bl = this.state$3.validNodeForGossip(member.uniqueAddress());
                        return bl;
                    }
                    {
                        this.state$3 = state$3;
                    }
                }, SortedSet$.MODULE$.newCanBuildFrom(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
                if (!validNodes.nonEmpty()) {
                    left = tail;
                    continue;
                }
                vector = validNodes.toVector();
                break block4;
            }
            if (Nil$.MODULE$.equals(list)) {
                vector = scala.package$.MODULE$.Vector().empty();
            } else {
                throw new MatchError((Object)list);
            }
        }
        return vector;
    }

    public GossipTargetSelector(double reduceGossipDifferentViewProbability, double crossDcGossipProbability) {
        this.reduceGossipDifferentViewProbability = reduceGossipDifferentViewProbability;
        this.crossDcGossipProbability = crossDcGossipProbability;
    }
}

