/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import nl.javadude.scannit.predicates.Predicate;
import nl.javadude.scannit.predicates.Predicates;
import nl.javadude.scannit.scanner.AbstractScanner;

public class Configuration {
    Set<AbstractScanner> scanners = new HashSet<AbstractScanner>();
    Set<String> prefixes = new HashSet<String>();

    private Configuration() {
    }

    public static Configuration config() {
        return new Configuration();
    }

    public Configuration with(AbstractScanner ... scanners) {
        for (AbstractScanner scanner : scanners) {
            this.scanners.add(scanner);
        }
        return this;
    }

    public Configuration scan(String prefix) {
        this.prefixes.add(prefix);
        return this;
    }

    void wireScanners() {
        ArrayList<Predicate<CharSequence>> predicates = new ArrayList<Predicate<CharSequence>>();
        for (String prefix : this.prefixes) {
            predicates.add(this.toFilter(prefix));
        }
        Predicate<CharSequence> or = Predicates.or(predicates);
        for (AbstractScanner scanner : this.scanners) {
            scanner.addFilter(or);
        }
    }

    private Predicate<CharSequence> toFilter(String prefix) {
        return Predicates.containsPattern(prefix.replace(".", "\\.") + ".*");
    }
}

