/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.migration;

import com.xebialabs.deployit.migration.ArtifactsMigration;
import com.xebialabs.deployit.repository.sql.artifacts.DbArtifactDataRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.db.DbDataStore;
import org.slf4j.Marker;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001e3Aa\u0002\u0005\u0001#!AA\u0005\u0001B\u0001B\u0003%Q\u0005\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u000b5\u0003A\u0011\u0001(\t\u000bQ\u0003A\u0011I+\u0003\u0011\u0011\u000bG/\u00192bg\u0016T!!\u0003\u0006\u0002\u00135LwM]1uS>t'BA\u0006\r\u0003!!W\r\u001d7ps&$(BA\u0007\u000f\u0003%AXMY5bY\u0006\u00147OC\u0001\u0010\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001!\u0003\u0007\u000f\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\tI\"$D\u0001\t\u0013\tY\u0002B\u0001\nBeRLg-Y2ug6KwM]1uS>t\u0007CA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\t\u0013\u0001C4sSjTH.\u001a3\n\u0005\rr\"a\u0002'pO\u001eLgnZ\u0001\u0015I\n\f%\u000f^5gC\u000e$(+\u001a9pg&$xN]=\u0011\u0005\u0019jS\"A\u0014\u000b\u0005!J\u0013!C1si&4\u0017m\u0019;t\u0015\tQ3&A\u0002tc2T!\u0001\f\u0006\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002/O\tABIY!si&4\u0017m\u0019;ECR\f'+\u001a9pg&$xN]=\u0002\u0017\u0011\u0014G)\u0019;b'R|'/\u001a\t\u0003cyj\u0011A\r\u0006\u0003gQ\n!\u0001\u001a2\u000b\u0005U2\u0014\u0001\u00023bi\u0006T!a\u000e\u001d\u0002\t\r|'/\u001a\u0006\u0003si\n!B[1dWJ\f'MY5u\u0015\tYD(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002{\u0005\u0019qN]4\n\u0005}\u0012$a\u0003#c\t\u0006$\u0018m\u0015;pe\u0016\f!\u0003\u001e:b]N\f7\r^5p]6\u000bg.Y4feB\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\fiJ\fgn]1di&|gN\u0003\u0002Gy\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148.\u0003\u0002I\u0007\nQ\u0002\u000b\\1uM>\u0014X\u000e\u0016:b]N\f7\r^5p]6\u000bg.Y4fe\u0006I!-\u0019;dQNK'0\u001a\t\u0003'-K!\u0001\u0014\u000b\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0006\u001fB\u000b&k\u0015\t\u00033\u0001AQ\u0001J\u0003A\u0002\u0015BQaL\u0003A\u0002ABQ\u0001Q\u0003A\u0002\u0005CQ!S\u0003A\u0002)\u000bq!\\5he\u0006$X\rF\u0001W!\t\u0019r+\u0003\u0002Y)\t!QK\\5u\u0001")
public class Database
implements ArtifactsMigration,
Logging {
    private final DbArtifactDataRepository dbArtifactRepository;
    private final DbDataStore dbDataStore;
    private final PlatformTransactionManager transactionManager;
    private final int batchSize;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        Database database = this;
        synchronized (database) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public void migrate() {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Migrating artifacts from database. Batch size: ").append($this.batchSize).toString());
        Iterator identifiers = this.dbDataStore.getAllIdentifiers();
        IntRef batchCount = IntRef.create((int)0);
        while (identifiers.hasNext()) {
            IntRef count = IntRef.create((int)0);
            ++batchCount.elem;
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Processing batch ").append(batchCount$1.elem).append(".").toString());
            TransactionStatus transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
            try {
                try {
                    while (identifiers.hasNext() && count.elem < this.batchSize) {
                        Object object;
                        DataIdentifier id = (DataIdentifier)identifiers.next();
                        String idStr = id.toString();
                        if (this.dbArtifactRepository.exists(idStr)) {
                            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Found artifact already migrated: '").append(idStr).append("'.").toString());
                            object = BoxedUnit.UNIT;
                        } else {
                            object = BoxesRunTime.boxToInteger((int)this.dbArtifactRepository.insert(idStr, this.dbDataStore.getRecord(id).getStream()));
                        }
                        ++count.elem;
                    }
                }
                catch (Throwable t) {
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> "Error while migrating database artifacts.", (Function0 & Serializable & scala.Serializable)() -> t);
                    transactionStatus.setRollbackOnly();
                    throw t;
                }
            }
            finally {
                if (transactionStatus.isRollbackOnly()) {
                    this.transactionManager.rollback(transactionStatus);
                } else {
                    this.transactionManager.commit(transactionStatus);
                }
            }
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Finished processing batch ").append(batchCount$1.elem).append(". Processed ").append(count$1.elem).append(" artifacts.").toString());
        }
    }

    public Database(DbArtifactDataRepository dbArtifactRepository, DbDataStore dbDataStore, PlatformTransactionManager transactionManager, int batchSize) {
        this.dbArtifactRepository = dbArtifactRepository;
        this.dbDataStore = dbDataStore;
        this.transactionManager = transactionManager;
        this.batchSize = batchSize;
        Logging.$init$((Logging)this);
    }
}

