/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jcr.jackrabbit;

import com.xebialabs.xlplatform.jackrabbit.config.JackrabbitSettings;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import java.io.File;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.springframework.beans.factory.FactoryBean;

public class JackrabbitRepositoryConfigurationFactoryBean
implements FactoryBean<RepositoryConfig> {
    private RepositoryConfig repositoryConfig;

    public JackrabbitRepositoryConfigurationFactoryBean(XlRepositoryConfig xlConfig, boolean autoInitialize) throws RepositoryException {
        this.repositoryConfig = JackrabbitSettings.parse(xlConfig.repositoryConfig());
        File homeDirFile = new File(this.repositoryConfig.getHomeDir());
        if (!homeDirFile.exists() && !autoInitialize) {
            throw new RepositoryException("Jackrabbit home dir " + homeDirFile + " does not exist. Please run the XL Deploy server with -setup -reinitialize to reinitialize the XL Deploy repository.");
        }
        this.overrideRepositoryAdminId(this.repositoryConfig);
    }

    private void overrideRepositoryAdminId(RepositoryConfig repositoryConfig) {
        LoginModuleConfig loginModuleConfig = repositoryConfig.getSecurityConfig().getLoginModuleConfig();
        Properties parameters = loginModuleConfig.getParameters();
        if (!"jcr_admin".equals(parameters.getProperty("adminId"))) {
            parameters.setProperty("adminId", "jcr_admin");
        }
    }

    public RepositoryConfig getObject() throws Exception {
        return this.repositoryConfig;
    }

    public Class<?> getObjectType() {
        return RepositoryConfig.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

