/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jcr.jackrabbit;

import com.xebialabs.deployit.JcrCredentials;
import com.xebialabs.deployit.RepoCredentials;
import com.xebialabs.deployit.XlpJcrRepositoryConfig;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.xlplatform.repository.XlJcrRepositoryInitializer;
import com.xebialabs.xlplatform.repository.XlRepositoryConfig;
import java.security.Principal;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JackrabbitRepositoryInitializer
extends XlJcrRepositoryInitializer {
    private static final Logger logger = LoggerFactory.getLogger(JackrabbitRepositoryInitializer.class);

    public JackrabbitRepositoryInitializer(XlRepositoryConfig xlRepositoryConfig) {
        super(xlRepositoryConfig);
    }

    public void init(Repository repository) {
        super.init(repository);
        SimpleCredentials creds = this.getSimpleCredentials((RepoCredentials)XlpJcrRepositoryConfig.jcrAdminCredentials());
        new JcrTemplate(repository, (Credentials)creds).execute(session -> {
            this.setAccessControlOnRootNode(session);
            logger.debug("Initialized JCR repository");
            return null;
        });
    }

    private SimpleCredentials getSimpleCredentials(RepoCredentials credentials) {
        if (null == credentials) {
            throw new IllegalArgumentException("Credentials must be provided");
        }
        if (!(credentials instanceof JcrCredentials)) {
            throw new IllegalArgumentException("Credentials must be of type JcrCredentials");
        }
        Credentials jcrCreds = ((JcrCredentials)credentials).creds();
        if (!(jcrCreds instanceof SimpleCredentials)) {
            throw new IllegalArgumentException("Credentials must be set and be of type SimpleCredentials for JackRabbit");
        }
        return (SimpleCredentials)jcrCreds;
    }

    private void setAccessControlOnRootNode(Session session) throws RepositoryException {
        AccessControlManager acm = session.getAccessControlManager();
        AccessControlPolicyIterator applicablePolicies = acm.getApplicablePolicies("/");
        while (applicablePolicies.hasNext()) {
            AccessControlPolicy each = applicablePolicies.nextAccessControlPolicy();
            if (!(each instanceof JackrabbitAccessControlList)) continue;
            JackrabbitAccessControlList acl = (JackrabbitAccessControlList)each;
            Privilege readPrivilege = acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read");
            EveryonePrincipal everyone = EveryonePrincipal.getInstance();
            for (AccessControlEntry entry : acl.getAccessControlEntries()) {
                if (!entry.getPrincipal().equals(everyone)) continue;
                acl.removeAccessControlEntry(entry);
            }
            acl.addEntry((Principal)everyone, new Privilege[]{readPrivilege}, true);
            logger.debug("Setting {} on root", (Object)acl);
            acm.setPolicy("/", (AccessControlPolicy)acl);
        }
    }
}

