/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.repository.PathHelper;
import com.xebialabs.deployit.security.JcrPermissions;
import com.xebialabs.deployit.security.JcrRoleService;
import com.xebialabs.deployit.security.PermissionChecker;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.Permission;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;

public class JcrPermissionChecker
implements PermissionChecker {
    private JcrTemplate jcrTemplate;
    private JcrRoleService roleService;
    private static final Logger logger = LoggerFactory.getLogger(JcrPermissionChecker.class);

    @Autowired
    public JcrPermissionChecker(JcrTemplate jcrTemplate, JcrRoleService roleService) {
        this.jcrTemplate = jcrTemplate;
        this.roleService = roleService;
    }

    public boolean checkPermission(List<Permission> permissions, String onConfigurationItem, List<Role> allRoles) {
        return this.checkPermission(permissions, onConfigurationItem, allRoles, Permissions.getAuthentication());
    }

    public boolean checkPermission(List<Permission> permissions, String onConfigurationItem, List<Role> allRoles, Authentication auth) {
        return (Boolean)this.jcrTemplate.execute(session -> {
            if (Strings.nullToEmpty((String)onConfigurationItem).isEmpty()) {
                return this.checkGlobalPermission(session, permissions, allRoles, auth);
            }
            return this.checkCiPermission(session, permissions, onConfigurationItem, allRoles, auth);
        });
    }

    private boolean checkGlobalPermission(Session session, List<Permission> permissions, List<Role> allRoles, Authentication authentication) throws RepositoryException {
        Node node = session.getNode("/$configuration/security");
        Optional<Boolean> permissionOption = this.checkPermission(node, permissions, allRoles, authentication);
        if (permissionOption.isPresent()) {
            return (Boolean)permissionOption.get();
        }
        return false;
    }

    private boolean checkCiPermission(Session session, List<Permission> permissions, String onConfigurationItem, List<Role> allRoles, Authentication auth) throws RepositoryException {
        List<String> nodes = this.nodesToInspect(onConfigurationItem);
        for (String nodeId : nodes) {
            Optional<Boolean> ciPermissionOption;
            if (!session.nodeExists(nodeId) || !(ciPermissionOption = this.checkCiPermission(session.getNode(nodeId), permissions, allRoles, auth)).isPresent()) continue;
            return (Boolean)ciPermissionOption.get();
        }
        return false;
    }

    private Optional<Boolean> checkCiPermission(Node node, List<Permission> permissions, List<Role> allRoles, Authentication auth) throws RepositoryException {
        if (!JcrPermissions.isSecurable(node)) {
            return Optional.absent();
        }
        return this.checkPermission(node, permissions, allRoles, auth);
    }

    private Optional<Boolean> checkPermission(Node node, List<Permission> allPermissions, List<Role> allRoles) throws RepositoryException {
        return this.checkPermission(node, allPermissions, allRoles, Permissions.getAuthentication());
    }

    private Optional<Boolean> checkPermission(Node node, List<Permission> allPermissions, List<Role> allRoles, Authentication auth) throws RepositoryException {
        logger.debug("Trying to read permissions from [{}]", (Object)node.getPath());
        Map<String, String> permissions = JcrPermissions.readPermissionMap(node);
        if (permissions.isEmpty()) {
            logger.debug("[{}] has no permissions set, checking up the tree.", (Object)node.getPath());
            return Optional.absent();
        }
        logger.debug("[{}] has permissions enabled, which are: [{}]", (Object)node.getPath(), permissions);
        for (Permission permission : allPermissions) {
            if (!permissions.containsKey(permission.getPermissionName())) continue;
            List<String> permittedRoles = JcrPermissions.splitIds(permissions.get(permission.getPermissionName()));
            List<String> allGlobalRoleIds = JcrPermissions.rolesToIds(allRoles);
            List<String> allLocalRoleIds = JcrPermissions.rolesToIds(this.roleService.getRolesFor(auth, allRoles, node.getPath()));
            if (!permittedRoles.stream().anyMatch(allGlobalRoleIds::contains)) {
                if (!permittedRoles.stream().anyMatch(allLocalRoleIds::contains)) continue;
            }
            return Optional.of((Object)true);
        }
        return Optional.of((Object)false);
    }

    private List<String> nodesToInspect(String onConfigurationItem) {
        return Lists.newArrayList((Iterable)Lists.transform(JcrPermissions.getFullTreeAsSeparateNodesInChildToRootOrder(onConfigurationItem), PathHelper::getAbsolutePathFromId));
    }
}

