/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jackson;

import com.fasterxml.jackson.jaxrs.cfg.ObjectWriterModifier;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResteasyObjectWriterInjector {
    private static Map<ClassLoader, ObjectWriterModifier> tcclMap = new WeakHashMap<ClassLoader, ObjectWriterModifier>();
    private static final AtomicBoolean hasBeenSet = new AtomicBoolean(false);

    private ResteasyObjectWriterInjector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(ClassLoader cl, ObjectWriterModifier mod) {
        if (cl == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        hasBeenSet.set(true);
        Map<ClassLoader, ObjectWriterModifier> map = tcclMap;
        synchronized (map) {
            ObjectWriterModifier previous = tcclMap.put(cl, mod);
            if (previous != null && previous != mod) {
                tcclMap.put(cl, mod);
                throw new IllegalArgumentException("A different ObjectWriterModifier is already set for the specified classloader");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectWriterModifier get(ClassLoader cl) {
        if (hasBeenSet.get()) {
            Map<ClassLoader, ObjectWriterModifier> map = tcclMap;
            synchronized (map) {
                return tcclMap.get(cl);
            }
        }
        return null;
    }
}

