/*
 * Decompiled with CFR 0.152.
 */
package com.romix.akka.serialization.kryo;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.serialization.Serializer;
import akka.util.ByteString;
import com.esotericsoftware.kryo.ClassResolver;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.ReferenceResolver;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.StreamFactory;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.util.DefaultClassResolver;
import com.esotericsoftware.kryo.util.DefaultStreamFactory;
import com.esotericsoftware.kryo.util.ListReferenceResolver;
import com.esotericsoftware.kryo.util.MapReferenceResolver;
import com.esotericsoftware.minlog.Log;
import com.romix.akka.serialization.kryo.ActorRefSerializer;
import com.romix.akka.serialization.kryo.KryoBasedSerializer;
import com.romix.akka.serialization.kryo.KryoCryptographer;
import com.romix.akka.serialization.kryo.KryoSerialization;
import com.romix.akka.serialization.kryo.KryoTransformer;
import com.romix.akka.serialization.kryo.LZ4KryoCompressor;
import com.romix.akka.serialization.kryo.NoKryoTransformer;
import com.romix.akka.serialization.kryo.QueueBuilder;
import com.romix.akka.serialization.kryo.SerializerPool;
import com.romix.akka.serialization.kryo.Transformation;
import com.romix.akka.serialization.kryo.ZipKryoCompressor;
import com.romix.scala.serialization.kryo.AkkaByteStringSerializer;
import com.romix.scala.serialization.kryo.EnumerationSerializer;
import com.romix.scala.serialization.kryo.KryoClassResolver;
import com.romix.scala.serialization.kryo.ScalaCollectionSerializer;
import com.romix.scala.serialization.kryo.ScalaImmutableMapSerializer;
import com.romix.scala.serialization.kryo.ScalaImmutableSetSerializer;
import com.romix.scala.serialization.kryo.ScalaImmutableSortedSetSerializer;
import com.romix.scala.serialization.kryo.ScalaKryo;
import com.romix.scala.serialization.kryo.ScalaMutableMapSerializer;
import com.romix.scala.serialization.kryo.ScalaMutableSetSerializer;
import com.romix.scala.serialization.kryo.ScalaMutableSortedSetSerializer;
import com.romix.scala.serialization.kryo.ScalaSortedMapSerializer;
import com.romix.scala.serialization.kryo.ScalaUnitSerializer;
import com.romix.scala.serialization.kryo.SubclassResolver;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.generic.MapFactory;
import scala.collection.generic.SetFactory;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.BitSet;
import scala.collection.mutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t%f\u0001B\u0001\u0003\u00015\u0011ab\u0013:z_N+'/[1mSj,'O\u0003\u0002\u0004\t\u0005!1N]=p\u0015\t)a!A\u0007tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0003\u000f!\tA!Y6lC*\u0011\u0011BC\u0001\u0006e>l\u0017\u000e\u001f\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)\u0002$D\u0001\u0017\u0015\t)qCC\u0001\b\u0013\tIbC\u0001\u0006TKJL\u0017\r\\5{KJD\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0007gf\u001cH/Z7\u0016\u0003u\u0001\"AH\u0011\u000e\u0003}Q!\u0001I\f\u0002\u000b\u0005\u001cGo\u001c:\n\u0005\tz\"aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0007\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\u000fML8\u000f^3nA!)a\u0005\u0001C\u0001O\u00051A(\u001b8jiz\"\"\u0001\u000b\u0016\u0011\u0005%\u0002Q\"\u0001\u0002\t\u000bm)\u0003\u0019A\u000f\t\u000f1\u0002!\u0019!C\u0001[\u0005\u0019An\\4\u0016\u00039\u0002\"a\f\u001a\u000e\u0003AR!!M\f\u0002\u000b\u00154XM\u001c;\n\u0005M\u0002$A\u0004'pO\u001eLgnZ!eCB$XM\u001d\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u0018\u0002\t1|w\r\t\u0005\bo\u0001\u0011\r\u0011\"\u00019\u0003!\u0019X\r\u001e;j]\u001e\u001cX#A\u001d\u0011\u0005iReBA\u001eI\u001d\tatI\u0004\u0002>\r:\u0011a(\u0012\b\u0003\u007f\u0011s!\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0005\u0003\u0013\n\t\u0011c\u0013:z_N+'/[1mSj\fG/[8o\u0013\tYEJ\u0001\u0005TKR$\u0018N\\4t\u0015\tI%\u0001\u0003\u0004O\u0001\u0001\u0006I!O\u0001\ng\u0016$H/\u001b8hg\u0002Bq\u0001\u0015\u0001C\u0002\u0013\u0005\u0011+\u0001\u0005nCB\u0004\u0018N\\4t+\u0005\u0011\u0006\u0003B*X5js!\u0001V+\u0011\u0005\u0001\u0003\u0012B\u0001,\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0004\u001b\u0006\u0004(B\u0001,\u0011!\t\u00196,\u0003\u0002]3\n11\u000b\u001e:j]\u001eDaA\u0018\u0001!\u0002\u0013\u0011\u0016!C7baBLgnZ:!\u0011\u001d\u0001\u0007A1A\u0005\u0002\u0005\f!b\u00197bgNt\u0017-\\3t+\u0005\u0011\u0007cA2i56\tAM\u0003\u0002fM\u0006!Q\u000f^5m\u0015\u00059\u0017\u0001\u00026bm\u0006L!!\u001b3\u0003\t1K7\u000f\u001e\u0005\u0007W\u0002\u0001\u000b\u0011\u00022\u0002\u0017\rd\u0017m]:oC6,7\u000f\t\u0005\b[\u0002\u0011\r\u0011\"\u0001o\u0003)\u0011WO\u001a4feNK'0Z\u000b\u0002_B\u0011q\u0002]\u0005\u0003cB\u00111!\u00138u\u0011\u0019\u0019\b\u0001)A\u0005_\u0006Y!-\u001e4gKJ\u001c\u0016N_3!\u0011\u001d)\bA1A\u0005\u00029\fQ\"\\1y\u0005V4g-\u001a:TSj,\u0007BB<\u0001A\u0003%q.\u0001\bnCb\u0014UO\u001a4feNK'0\u001a\u0011\t\u000fe\u0004!\u0019!C\u0001u\u0006Q\u0011\u000eZ*ue\u0006$XmZ=\u0016\u0003iCa\u0001 \u0001!\u0002\u0013Q\u0016aC5e'R\u0014\u0018\r^3hs\u0002BqA \u0001C\u0002\u0013\u0005!0\u0001\btKJL\u0017\r\\5{KJ$\u0016\u0010]3\t\u000f\u0005\u0005\u0001\u0001)A\u00055\u0006y1/\u001a:jC2L'0\u001a:UsB,\u0007\u0005C\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0001\u0002\b\u0005Y\u0012.\u001c9mS\u000eLGOU3hSN$(/\u0019;j_:dunZ4j]\u001e,\"!!\u0003\u0011\u0007=\tY!C\u0002\u0002\u000eA\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0011BA\u0005\u0003qIW\u000e\u001d7jG&$(+Z4jgR\u0014\u0018\r^5p]2{wmZ5oO\u0002B\u0011\"!\u0006\u0001\u0005\u0004%\t!a\u0002\u0002\u0019U\u001cX-T1oS\u001a,7\u000f^:\t\u0011\u0005e\u0001\u0001)A\u0005\u0003\u0013\tQ\"^:f\u001b\u0006t\u0017NZ3tiN\u0004\u0003\"CA\u000f\u0001\t\u0007I\u0011AA\u0004\u0003%)8/Z+og\u00064W\r\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\u0005\u0003))8/Z+og\u00064W\r\t\u0005\t\u0003K\u0001!\u0019!C\u0001u\u0006i2-^:u_6\u001cVM]5bY&TXM]%oSR\u001cE.Y:t\u001d\u0006lW\rC\u0004\u0002*\u0001\u0001\u000b\u0011\u0002.\u0002=\r,8\u000f^8n'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018J\\5u\u00072\f7o\u001d(b[\u0016\u0004\u0003\"CA\u0017\u0001\t\u0007I\u0011AA\u0018\u0003e\u0019Wo\u001d;p[N+'/[1mSj,'/\u00138ji\u000ec\u0017m]:\u0016\u0005\u0005E\u0002\u0007BA\u001a\u0003\u0013\u0002RaDA\u001b\u0003sI1!a\u000e\u0011\u0005\u0011\u0019v.\\3\u0011\r\u0005m\u0012\u0011IA#\u001b\t\tiDC\u0002\u0002@\u0019\fA\u0001\\1oO&!\u00111IA\u001f\u0005\u0015\u0019E.Y:t!\u0011\t9%!\u0013\r\u0001\u0011a\u00111JA'\u0003\u0003\u0005\tQ!\u0001\u0002R\t\u0019q\fJ\u001a\t\u0011\u0005=\u0003\u0001)A\u0005\u0003c\t!dY;ti>l7+\u001a:jC2L'0\u001a:J]&$8\t\\1tg\u0002\n2!a\u0015\u000f!\ry\u0011QK\u0005\u0004\u0003/\u0002\"a\u0002(pi\"Lgn\u001a\u0005\n\u00037\u0002!\u0019!C\u0001\u0003;\n!cY;ti>l\u0017N_3s\u0013:\u001cH/\u00198dKV\u0011\u0011q\f\t\u0007\u0003C\n)'!\u001b\u000e\u0005\u0005\r$BA3\u0011\u0013\u0011\t9'a\u0019\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u0010\u0003Wr\u0011bAA7!\t1q\n\u001d;j_:D\u0001\"!\u001d\u0001A\u0003%\u0011qL\u0001\u0014GV\u001cHo\\7ju\u0016\u0014\u0018J\\:uC:\u001cW\r\t\u0005\n\u0003k\u0002!\u0019!C\u0001\u0003o\n\u0001cY;ti>l\u0017N_3s\u001b\u0016$\bn\u001c3\u0016\u0005\u0005e\u0004CBA1\u0003K\nY\bE\u0003\u0010\u0003W\ni\b\u0005\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\u0011\t\u0019)!\u0010\u0002\u000fI,g\r\\3di&!\u0011qQAA\u0005\u0019iU\r\u001e5pI\"A\u00111\u0012\u0001!\u0002\u0013\tI(A\tdkN$x.\\5{KJlU\r\u001e5pI\u0002B\u0001\"a$\u0001\u0005\u0004%\tA_\u0001\u0016GV\u001cHo\\7B\u000bN[U-_\"mCN\u001ch*Y7f\u0011\u001d\t\u0019\n\u0001Q\u0001\ni\u000bacY;ti>l\u0017)R*LKf\u001cE.Y:t\u001d\u0006lW\r\t\u0005\n\u0003/\u0003!\u0019!C\u0001\u00033\u000b\u0011cY;ti>l\u0017)R*LKf\u001cE.Y:t+\t\tY\n\r\u0003\u0002\u001e\u0006\r\u0006#B\b\u00026\u0005}\u0005CBA\u001e\u0003\u0003\n\t\u000b\u0005\u0003\u0002H\u0005\rF\u0001DA&\u0003K\u000b\t\u0011!A\u0003\u0002\u0005E\u0003\u0002CAT\u0001\u0001\u0006I!a'\u0002%\r,8\u000f^8n\u0003\u0016\u001b6*Z=DY\u0006\u001c8\u000f\t\u0005\n\u0003W\u0003!\u0019!C\u0001\u0003;\nAcY;ti>l\u0017)R*LKfLen\u001d;b]\u000e,\u0007\u0002CAX\u0001\u0001\u0006I!a\u0018\u0002+\r,8\u000f^8n\u0003\u0016\u001b6*Z=J]N$\u0018M\\2fA!I\u00111\u0017\u0001C\u0002\u0013\u0005\u0011qO\u0001\rC\u0016\u001c8*Z=NKRDw\u000e\u001a\u0005\t\u0003o\u0003\u0001\u0015!\u0003\u0002z\u0005i\u0011-Z:LKflU\r\u001e5pI\u0002B\u0001\"a/\u0001\u0005\u0004%\tA_\u0001\u0007C\u0016\u001c8*Z=\t\u000f\u0005}\u0006\u0001)A\u00055\u00069\u0011-Z:LKf\u0004\u0003\"CAb\u0001\t\u0007I\u0011AAc\u0003%!(/\u00198tM>\u0014X.\u0006\u0002\u0002HB1q\"!3[\u0003\u001bL1!a3\u0011\u0005%1UO\\2uS>t\u0017\u0007E\u0002*\u0003\u001fL1!!5\u0003\u00059!&/\u00198tM>\u0014X.\u0019;j_:D\u0001\"!6\u0001A\u0003%\u0011qY\u0001\u000biJ\fgn\u001d4pe6\u0004\u0003\"CAm\u0001\t\u0007I\u0011AAn\u0003Y\u0001xn\u001d;TKJ$&/\u00198tM>\u0014X.\u0019;j_:\u001cXCAAo!\u0019\ty.!;\u0002N6\u0011\u0011\u0011\u001d\u0006\u0005\u0003G\f)/A\u0005j[6,H/\u00192mK*\u0019\u0011q\u001d\t\u0002\u0015\r|G\u000e\\3di&|g.C\u0002j\u0003CD\u0001\"!<\u0001A\u0003%\u0011Q\\\u0001\u0018a>\u001cHoU3s)J\fgn\u001d4pe6\fG/[8og\u0002B\u0011\"!=\u0001\u0005\u0004%\t!a=\u0002\u001f-\u0014\u0018p\u001c+sC:\u001chm\u001c:nKJ,\"!!>\u0011\u0007%\n90C\u0002\u0002z\n\u0011qb\u0013:z_R\u0013\u0018M\\:g_JlWM\u001d\u0005\t\u0003{\u0004\u0001\u0015!\u0003\u0002v\u0006\u00012N]=p)J\fgn\u001d4pe6,'\u000f\t\u0005\n\u0005\u0003\u0001!\u0019!C\u0001\u0005\u0007\tA\"];fk\u0016\u0014U/\u001b7eKJ,\"A!\u0002\u0011\u0007%\u00129!C\u0002\u0003\n\t\u0011A\"U;fk\u0016\u0014U/\u001b7eKJD\u0001B!\u0004\u0001A\u0003%!QA\u0001\u000ecV,W/\u001a\"vS2$WM\u001d\u0011\t\u0013\tE\u0001A1A\u0005\u0002\tM\u0011AC:fe&\fG.\u001b>feV\u0011!Q\u0003\t\u0004S\t]\u0011b\u0001B\r\u0005\t\u00192J]=p\u0005\u0006\u001cX\rZ*fe&\fG.\u001b>fe\"A!Q\u0004\u0001!\u0002\u0013\u0011)\"A\u0006tKJL\u0017\r\\5{KJ\u0004\u0003\"\u0003B\u0011\u0001\t\u0007I\u0011AA\u0004\u0003E\u0011Xm]8mm\u0016\u001cVOY2mCN\u001cXm\u001d\u0005\t\u0005K\u0001\u0001\u0015!\u0003\u0002\n\u0005\u0011\"/Z:pYZ,7+\u001e2dY\u0006\u001c8/Z:!\u0011\u001d\u0011I\u0003\u0001C\u0001\u0003\u000f\tq\"\u001b8dYV$W-T1oS\u001a,7\u000f\u001e\u0005\u0007\u0005[\u0001A\u0011\u00018\u0002\u0015%$WM\u001c;jM&,'\u000fC\u0004\u00032\u0001!\tAa\r\u0002\u0011Q|')\u001b8bef$BA!\u000e\u0003BA)qBa\u000e\u0003<%\u0019!\u0011\b\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0007=\u0011i$C\u0002\u0003@A\u0011AAQ=uK\"9!1\tB\u0018\u0001\u0004q\u0011aA8cU\"9!q\t\u0001\u0005\u0002\t%\u0013A\u00034s_6\u0014\u0015N\\1ssR)aBa\u0013\u0003P!A!Q\nB#\u0001\u0004\u0011)$A\u0003csR,7\u000f\u0003\u0005\u0003R\t\u0015\u0003\u0019\u0001B*\u0003\u0015\u0019G.\u0019>{!\u0015y\u00111\u000eB+a\u0011\u00119F!\u0018\u0011\u000bM\u0013IFa\u0017\n\u0007\u0005\r\u0013\f\u0005\u0003\u0002H\tuC\u0001\u0004B0\u0005\u001f\n\t\u0011!A\u0003\u0002\t\u0005$aA0%cE!\u00111\u000bB2!\ry!QM\u0005\u0004\u0005O\u0002\"aA!os\"I!1\u000e\u0001C\u0002\u0013\u0005!QN\u0001\u000fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bk\\8m+\t\u0011y\u0007E\u0002*\u0005cJ1Aa\u001d\u0003\u00059\u0019VM]5bY&TXM\u001d)p_2D\u0001Ba\u001e\u0001A\u0003%!qN\u0001\u0010g\u0016\u0014\u0018.\u00197ju\u0016\u0014\bk\\8mA!9!1\u0010\u0001\u0005\n\tu\u0014!D4fiN+'/[1mSj,'/F\u0001\u0015\u0011\u001d\u0011\t\t\u0001C\u0005\u0005\u0007\u000b\u0011C]3mK\u0006\u001cXmU3sS\u0006d\u0017N_3s)\u0011\u0011)Ia#\u0011\u0007=\u00119)C\u0002\u0003\nB\u0011A!\u00168ji\"9!Q\u0012B@\u0001\u0004!\u0012aA:fe\"9!\u0011\u0013\u0001\u0005\n\tM\u0015aB4fi.\u0013\u0018p\u001c\u000b\u0007\u0005+\u0013\u0019Ka*\u0011\t\t]%qT\u0007\u0003\u00053S1a\u0001BN\u0015\r\u0011iJC\u0001\u0011KN|G/\u001a:jGN|g\r^<be\u0016LAA!)\u0003\u001a\n!1J]=p\u0011\u001d\u0011)Ka$A\u0002i\u000b\u0001b\u001d;sCR,w-\u001f\u0005\u0007}\n=\u0005\u0019\u0001.")
public class KryoSerializer
implements Serializer {
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final KryoSerialization.Settings settings;
    private final Map<String, String> mappings;
    private final java.util.List<String> classnames;
    private final int bufferSize;
    private final int maxBufferSize;
    private final String idStrategy;
    private final String serializerType;
    private final boolean implicitRegistrationLogging;
    private final boolean useManifests;
    private final boolean useUnsafe;
    private final String customSerializerInitClassName;
    private final Some<Class<Object>> customSerializerInitClass;
    private final Try<Option<Object>> customizerInstance;
    private final Try<Option<Method>> customizerMethod;
    private final String customAESKeyClassName;
    private final Some<Class<Object>> customAESKeyClass;
    private final Try<Option<Object>> customAESKeyInstance;
    private final Try<Option<Method>> aesKeyMethod;
    private final String aesKey;
    private final Function1<String, Transformation> transform;
    private final List<Transformation> postSerTransformations;
    private final KryoTransformer kryoTransformer;
    private final QueueBuilder queueBuilder;
    private final KryoBasedSerializer serializer;
    private final boolean resolveSubclasses;
    private final SerializerPool serializerPool;

    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes);
    }

    public final Object fromBinary(byte[] bytes, Class<?> clazz) {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes, clazz);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    public KryoSerialization.Settings settings() {
        return this.settings;
    }

    public Map<String, String> mappings() {
        return this.mappings;
    }

    public java.util.List<String> classnames() {
        return this.classnames;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public int maxBufferSize() {
        return this.maxBufferSize;
    }

    public String idStrategy() {
        return this.idStrategy;
    }

    public String serializerType() {
        return this.serializerType;
    }

    public boolean implicitRegistrationLogging() {
        return this.implicitRegistrationLogging;
    }

    public boolean useManifests() {
        return this.useManifests;
    }

    public boolean useUnsafe() {
        return this.useUnsafe;
    }

    public String customSerializerInitClassName() {
        return this.customSerializerInitClassName;
    }

    public Some<Class<Object>> customSerializerInitClass() {
        return this.customSerializerInitClass;
    }

    public Try<Option<Object>> customizerInstance() {
        return this.customizerInstance;
    }

    public Try<Option<Method>> customizerMethod() {
        return this.customizerMethod;
    }

    public String customAESKeyClassName() {
        return this.customAESKeyClassName;
    }

    public Some<Class<Object>> customAESKeyClass() {
        return this.customAESKeyClass;
    }

    public Try<Option<Object>> customAESKeyInstance() {
        return this.customAESKeyInstance;
    }

    public Try<Option<Method>> aesKeyMethod() {
        return this.aesKeyMethod;
    }

    public String aesKey() {
        return this.aesKey;
    }

    public Function1<String, Transformation> transform() {
        return this.transform;
    }

    public List<Transformation> postSerTransformations() {
        return this.postSerTransformations;
    }

    public KryoTransformer kryoTransformer() {
        return this.kryoTransformer;
    }

    public QueueBuilder queueBuilder() {
        return this.queueBuilder;
    }

    public KryoBasedSerializer serializer() {
        return this.serializer;
    }

    public boolean resolveSubclasses() {
        return this.resolveSubclasses;
    }

    public boolean includeManifest() {
        return this.useManifests();
    }

    public int identifier() {
        return 123454323;
    }

    public byte[] toBinary(Object obj) {
        byte[] byArray;
        Serializer ser = this.getSerializer();
        try {
            byArray = this.kryoTransformer().toBinary(ser.toBinary(obj));
        }
        finally {
            this.releaseSerializer(ser);
        }
        return byArray;
    }

    public Object fromBinary(byte[] bytes, Option<Class<?>> clazz) {
        Object object;
        Serializer ser = this.getSerializer();
        try {
            object = ser.fromBinary(this.kryoTransformer().fromBinary(bytes), clazz);
        }
        finally {
            this.releaseSerializer(ser);
        }
        return object;
    }

    public SerializerPool serializerPool() {
        return this.serializerPool;
    }

    private Serializer getSerializer() {
        return this.serializerPool().fetch();
    }

    private void releaseSerializer(Serializer ser) {
        this.serializerPool().release(ser);
    }

    private Kryo getKryo(String strategy, String serializerType) {
        MapReferenceResolver referenceResolver = this.settings().KryoReferenceMap() ? new MapReferenceResolver() : new ListReferenceResolver();
        String string = this.settings().IdStrategy();
        String string2 = "incremental";
        DefaultClassResolver classResolver = string != null && string.equals(string2) ? new KryoClassResolver(this.implicitRegistrationLogging()) : (this.resolveSubclasses() ? new SubclassResolver() : new DefaultClassResolver());
        ScalaKryo kryo = new ScalaKryo((ClassResolver)classResolver, (ReferenceResolver)referenceResolver, (StreamFactory)new DefaultStreamFactory());
        kryo.setClassLoader(this.system().dynamicAccess().classLoader());
        Kryo.DefaultInstantiatorStrategy instStrategy = (Kryo.DefaultInstantiatorStrategy)kryo.getInstantiatorStrategy();
        instStrategy.setFallbackInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
        kryo.setInstantiatorStrategy((InstantiatorStrategy)instStrategy);
        kryo.addDefaultSerializer(Enumeration.Value.class, EnumerationSerializer.class);
        Try try_ = this.system().dynamicAccess().getClassFor("scala.Enumeration$Val", ClassTag$.MODULE$.AnyRef());
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                this.log().error("Class could not be loaded and/or registered: {} ", (Object)"scala.Enumeration$Val");
                throw e;
            }
            throw new MatchError((Object)try_);
        }
        Class clazz = (Class)((Success)try_).value();
        kryo.register(clazz);
        kryo.register(Enumeration.Value.class);
        kryo.addDefaultSerializer(BoxedUnit.class, ScalaUnitSerializer.class);
        kryo.addDefaultSerializer(scala.collection.mutable.Map.class, ScalaMutableMapSerializer.class);
        kryo.addDefaultSerializer(SortedMap.class, ScalaSortedMapSerializer.class);
        kryo.addDefaultSerializer(Map.class, ScalaImmutableMapSerializer.class);
        kryo.addDefaultSerializer(scala.collection.immutable.BitSet.class, FieldSerializer.class);
        kryo.addDefaultSerializer(SortedSet.class, ScalaImmutableSortedSetSerializer.class);
        kryo.addDefaultSerializer(scala.collection.immutable.Set.class, ScalaImmutableSetSerializer.class);
        kryo.addDefaultSerializer(BitSet.class, FieldSerializer.class);
        kryo.addDefaultSerializer(scala.collection.mutable.SortedSet.class, ScalaMutableSortedSetSerializer.class);
        kryo.addDefaultSerializer(Set.class, ScalaMutableSetSerializer.class);
        kryo.addDefaultSerializer(MapFactory.class, ScalaImmutableMapSerializer.class);
        kryo.addDefaultSerializer(SetFactory.class, ScalaImmutableSetSerializer.class);
        kryo.addDefaultSerializer(ByteString.class, AkkaByteStringSerializer.class);
        kryo.addDefaultSerializer(Traversable.class, ScalaCollectionSerializer.class);
        kryo.addDefaultSerializer(ActorRef.class, new ActorRefSerializer(this.system()));
        if (this.settings().KryoTrace()) {
            Log.TRACE();
        }
        String string3 = strategy;
        String string4 = "explicit";
        kryo.setRegistrationRequired(string3 != null && string3.equals(string4));
        String string5 = strategy;
        String string6 = "default";
        if (string5 == null || !string5.equals(string6)) {
            this.mappings().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)KryoSerializer.$anonfun$getKryo$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                if (x$9 == null) throw new MatchError(x$9);
                String fqcn = (String)x$9._1();
                String idNum = (String)x$9._2();
                if (fqcn == null) throw new MatchError(x$9);
                if (idNum == null) throw new MatchError(x$9);
                int id = new StringOps(Predef$.MODULE$.augmentString(idNum)).toInt();
                Try try_ = this.system().dynamicAccess().getClassFor(fqcn, ClassTag$.MODULE$.AnyRef());
                if (try_ instanceof Success) {
                    Class clazz = (Class)((Success)try_).value();
                    return kryo.register(clazz, id);
                }
                if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                Throwable e = ((Failure)try_).exception();
                this.log().error("Class could not be loaded and/or registered: {} ", (Object)fqcn);
                throw e;
            });
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.classnames()).asScala()).foreach((Function1 & Serializable & scala.Serializable)classname -> {
                Registration registration;
                Try try_ = this.system().dynamicAccess().getClassFor(classname, ClassTag$.MODULE$.AnyRef());
                if (try_ instanceof Success) {
                    Class clazz = (Class)((Success)try_).value();
                    registration = kryo.register(clazz);
                } else if (try_ instanceof Failure) {
                    this.log().warning("Class could not be loaded and/or registered: {} ", classname);
                    registration = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)try_);
                }
                return registration;
            });
        }
        if ("graph".equals(serializerType)) {
            kryo.setReferences(true);
        } else {
            kryo.setReferences(false);
        }
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((Method)((Option)this.customizerMethod().get()).get()).invoke(((Option)this.customizerInstance().get()).get(), new Object[]{kryo}));
        if (classResolver instanceof SubclassResolver) {
            ((SubclassResolver)classResolver).enable();
        }
        return kryo;
    }

    private final KryoBasedSerializer liftedTree1$1() {
        try {
            return new KryoBasedSerializer(this.getKryo(this.idStrategy(), this.serializerType()), this.bufferSize(), this.maxBufferSize(), this.useManifests(), this.useUnsafe());
        }
        catch (Exception e) {
            this.log().error("exception caught during akka-kryo-serialization startup: {}", (Object)e);
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getKryo$1(Tuple2 check$ifrefutable$1) {
        if (check$ifrefutable$1 == null) return false;
        String fqcn = (String)check$ifrefutable$1._1();
        String idNum = (String)check$ifrefutable$1._2();
        if (fqcn == null) return false;
        if (idNum == null) return false;
        return true;
    }

    public KryoSerializer(ExtendedActorSystem system) {
        QueueBuilder queueBuilder;
        Some some;
        Some some2;
        this.system = system;
        Serializer.$init$((Serializer)this);
        this.log = Logging$.MODULE$.apply((ActorSystem)system, (Object)this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.settings = new KryoSerialization.Settings(system.settings().config());
        this.mappings = this.settings().ClassNameMappings();
        this.log().debug("Got mappings: {}", this.mappings());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.classnames = this.settings().ClassNames();
        this.log().debug("Got classnames for incremental strategy: {}", this.classnames());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.bufferSize = this.settings().BufferSize();
        this.log().debug("Got buffer-size: {}", (Object)BoxesRunTime.boxToInteger((int)this.bufferSize()));
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.maxBufferSize = this.settings().MaxBufferSize();
        this.log().debug("Got max-buffer-size: {}", (Object)BoxesRunTime.boxToInteger((int)this.maxBufferSize()));
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.idStrategy = this.settings().IdStrategy();
        this.log().debug("Got id strategy: {}", (Object)this.idStrategy());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.serializerType = this.settings().SerializerType();
        this.log().debug("Got serializer type: {}", (Object)this.serializerType());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.implicitRegistrationLogging = this.settings().ImplicitRegistrationLogging();
        this.log().debug("Got implicit registration logging: {}", (Object)BoxesRunTime.boxToBoolean((boolean)this.implicitRegistrationLogging()));
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.useManifests = this.settings().UseManifests();
        this.log().debug("Got use manifests: {}", (Object)BoxesRunTime.boxToBoolean((boolean)this.useManifests()));
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.useUnsafe = this.settings().UseUnsafe();
        this.log().debug("Got use unsafe: {}", (Object)BoxesRunTime.boxToBoolean((boolean)this.useUnsafe()));
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.customSerializerInitClassName = this.settings().KryoCustomSerializerInit();
        this.log().debug("Got custom serializer init class: {}", (Object)this.customSerializerInitClassName());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        if (this.customSerializerInitClassName() == null) {
            some2 = null;
        } else {
            Try try_ = system.dynamicAccess().getClassFor(this.customSerializerInitClassName(), ClassTag$.MODULE$.AnyRef());
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Throwable e = ((Failure)try_).exception();
                    this.log().error("Class could not be loaded and/or registered: {} ", (Object)this.customSerializerInitClassName());
                    throw e;
                }
                throw new MatchError((Object)try_);
            }
            Class clazz = (Class)((Success)try_).value();
            Some some3 = new Some((Object)clazz);
            some2 = some3;
        }
        this.customSerializerInitClass = some2;
        this.log().debug("Got serializer init class: {}", this.customSerializerInitClass());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.customizerInstance = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.customSerializerInitClass().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.newInstance()));
        this.log().debug("Got customizer instance: {}", this.customizerInstance());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.customizerMethod = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.customSerializerInitClass().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getMethod("customize", Kryo.class)));
        this.log().debug("Got customizer method: {}", this.customizerMethod());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.customAESKeyClassName = this.settings().AESKeyClass();
        this.log().debug("Got custom aes key class: {}", (Object)this.customAESKeyClassName());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        if (this.customAESKeyClassName() == null) {
            some = null;
        } else {
            Try try_ = system.dynamicAccess().getClassFor(this.customAESKeyClassName(), ClassTag$.MODULE$.AnyRef());
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Throwable e = ((Failure)try_).exception();
                    this.log().error("Class could not be loaded {} ", (Object)this.customAESKeyClassName());
                    throw e;
                }
                throw new MatchError((Object)try_);
            }
            Class clazz = (Class)((Success)try_).value();
            Some some4 = new Some((Object)clazz);
            some = some4;
        }
        this.customAESKeyClass = some;
        this.log().debug("Got custom key class: {}", this.customAESKeyClass());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.customAESKeyInstance = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.customAESKeyClass().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.newInstance()));
        this.log().debug("Got custom aes key instance: {}", this.customAESKeyInstance());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.aesKeyMethod = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.customAESKeyClass().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getMethod("kryoAESKey", new Class[0])));
        this.log().debug("Got custom aes key method: {}", this.customAESKeyInstance());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.aesKey = (String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (String)((Method)((Option)this.aesKeyMethod().get()).get()).invoke(((Option)this.customAESKeyInstance().get()).get(), new Object[0])).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.settings().AESKey());
        this.transform = (Function1 & Serializable & scala.Serializable)typ -> {
            Transformation transformation;
            if ("lz4".equals(typ)) {
                transformation = new LZ4KryoCompressor();
            } else if ("deflate".equals(typ)) {
                transformation = new ZipKryoCompressor();
            } else if ("aes".equals(typ)) {
                transformation = new KryoCryptographer(this.aesKey(), this.settings().AESMode(), this.settings().AESIVLength());
            } else if ("off".equals(typ)) {
                transformation = new NoKryoTransformer();
            } else {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not recognise the transformer: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typ})));
            }
            return transformation;
        };
        this.postSerTransformations = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.settings().PostSerTransformations().split(","))).toList().map(this.transform(), List$.MODULE$.canBuildFrom());
        this.kryoTransformer = new KryoTransformer(this.postSerTransformations());
        this.log().debug("Got transformations: {}", (Object)this.settings().PostSerTransformations());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        if (this.settings().CustomQueueBuilder() == null) {
            queueBuilder = null;
        } else {
            Try try_ = system.dynamicAccess().getClassFor(this.settings().CustomQueueBuilder(), ClassTag$.MODULE$.AnyRef());
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Throwable e = ((Failure)try_).exception();
                    this.log().error("Class could not be loaded: {} ", (Object)this.settings().CustomQueueBuilder());
                    throw e;
                }
                throw new MatchError((Object)try_);
            }
            QueueBuilder queueBuilder2 = (QueueBuilder)((Class)((Success)try_).value()).newInstance();
            queueBuilder = queueBuilder2;
        }
        this.queueBuilder = queueBuilder;
        this.log().debug("Got queue builder: {}", (Object)this.queueBuilder());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.serializer = this.liftedTree1$1();
        this.log().debug("Got serializer: {}", (Object)this.serializer());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.resolveSubclasses = this.settings().ResolveSubclasses();
        this.log().debug("Got resolveSubclasses: {}", (Object)BoxesRunTime.boxToBoolean((boolean)this.resolveSubclasses()));
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.serializerPool = new SerializerPool(this.queueBuilder(), (Function0<Serializer>)(Function0 & Serializable & scala.Serializable)() -> new KryoBasedSerializer(this.getKryo(this.idStrategy(), this.serializerType()), this.bufferSize(), this.maxBufferSize(), this.useManifests(), this.useUnsafe()));
    }
}

