/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.SatelliteService;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.Paging$;
import com.xebialabs.deployit.engine.api.dto.SatelliteInfo;
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator;
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator$;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.satellite.ExtensionsDelta$;
import com.xebialabs.deployit.plugin.satellite.InstalledExtensionsDelta;
import com.xebialabs.deployit.plugin.satellite.SatelliteInfoChecker;
import com.xebialabs.deployit.plugin.satellite.SatelliteInfoChecker$;
import com.xebialabs.deployit.plugin.satellite.extension.ExtensionsLocator;
import com.xebialabs.deployit.plugin.satellite.extension.FileSystemExtensionsLocator$;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SatelliteRepository;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import com.xebialabs.satellite.protocol.Paths$;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.settings.CommonSettings;
import com.xebialabs.xlplatform.settings.CommonSettings$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@Service
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\b\u0011\u0001uA\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!)a\b\u0001C\u0001\u007f!91\u000b\u0001b\u0001\n\u0003!\u0006BB0\u0001A\u0003%Q\u000bC\u0003m\u0001\u0011\u0005Q\u000eC\u0005\u0002\u0006\u0001\u0011\r\u0011b\u0001\u0002\b!9\u0011\u0011\u0002\u0001!\u0002\u0013Q\b\"CA\u0006\u0001\t\u0007I1AA\u0007\u0011!\t9\u0002\u0001Q\u0001\n\u0005=\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003\u0007\u0002A\u0011BA#\u0011\u001d\t9\u0006\u0001C!\u00033Bq!a#\u0001\t\u0003\niI\u0001\u000bTCR,G\u000e\\5uKN+'O^5dK&k\u0007\u000f\u001c\u0006\u0003#I\t1!\u00199j\u0015\t\u0019B#\u0001\u0003sKN$(BA\u000b\u0017\u0003\u0011\u0019wN]3\u000b\u0005]A\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005eQ\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0012aA2p[\u000e\u00011\u0003\u0002\u0001\u001fI-\u0002\"a\b\u0012\u000e\u0003\u0001R!!\t\n\u0002\u000fM,7-\u001e:fI&\u00111\u0005\t\u0002\u0018\u0003\n\u001cHO]1diN+7-\u001e:fIJ+7o\\;sG\u0016\u0004\"!J\u0015\u000e\u0003\u0019R!!E\u0014\u000b\u0005!2\u0012AB3oO&tW-\u0003\u0002+M\t\u00012+\u0019;fY2LG/Z*feZL7-\u001a\t\u0003YEj\u0011!\f\u0006\u0003]=\nQa\u001d7gi)T\u0011\u0001M\u0001\tOJL'P\u001f7fI&\u0011!'\f\u0002\b\u0019><w-\u001b8h\u0003M\u0019\u0018\r^3mY&$XMU3q_NLGo\u001c:z!\t)\u0004(D\u00017\u0015\t9d#\u0001\u0006sKB|7/\u001b;pefL!!\u000f\u001c\u0003'M\u000bG/\u001a7mSR,'+\u001a9pg&$xN]=\u0002#I,\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW\r\u0005\u00026y%\u0011QH\u000e\u0002\u0012%\u0016\u0004xn]5u_JL8+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\bF\u0002A\u0005\u000e\u0003\"!\u0011\u0001\u000e\u0003AAQaM\u0002A\u0002QBQAO\u0002A\u0002mB#aA#\u0011\u0005\u0019\u000bV\"A$\u000b\u0005!K\u0015AC1o]>$\u0018\r^5p]*\u0011!jS\u0001\bM\u0006\u001cGo\u001c:z\u0015\taU*A\u0003cK\u0006t7O\u0003\u0002O\u001f\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001Q\u0003\ry'oZ\u0005\u0003%\u001e\u0013\u0011\"Q;u_^L'/\u001a3\u0002\u0011I,7\u000f]8og\u0016,\u0012!\u0016\t\u0003-vk\u0011a\u0016\u0006\u00031f\u000b1a\u001d9j\u0015\tQ6,\u0001\u0005sKN$X-Y:z\u0015\tav*A\u0003kE>\u001c8/\u0003\u0002_/\na\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\u0006I!/Z:q_:\u001cX\r\t\u0015\u0003\u000b\u0005\u0004\"A\u00196\u000e\u0003\rT!!\u00063\u000b\u0005\u00154\u0017A\u0001:t\u0015\t9\u0007.\u0001\u0002xg*\t\u0011.A\u0003kCZ\f\u00070\u0003\u0002lG\n91i\u001c8uKb$\u0018A\u00053fM\u0006,H\u000e\u001e)j]\u001e$\u0016.\\3pkR$\"A\u001c=\u0011\u0005=4X\"\u00019\u000b\u0005E\u0014\u0018\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005M$\u0018AC2p]\u000e,(O]3oi*\tQ/A\u0003tG\u0006d\u0017-\u0003\u0002xa\nqa)\u001b8ji\u0016$UO]1uS>t\u0007\"B=\u0007\u0001\u0004Q\u0018a\u0004;bg.\f5\r^8s'f\u001cH/Z7\u0011\u0007m\f\t!D\u0001}\u0015\tih0A\u0003bGR|'OC\u0001\u0000\u0003\u0011\t7n[1\n\u0007\u0005\rAPA\u0006BGR|'oU=ti\u0016l\u0017aC1di>\u00148+_:uK6,\u0012A_\u0001\rC\u000e$xN]*zgR,W\u000eI\u0001\u000bI&\u001c\b/\u0019;dQ\u0016\u0014XCAA\b!\u0011\t\t\"a\u0005\u000e\u0003IL1!!\u0006s\u0005a)\u00050Z2vi&|gnQ8oi\u0016DH/\u0012=fGV$xN]\u0001\fI&\u001c\b/\u0019;dQ\u0016\u0014\b%A\u0004hKRLeNZ8\u0015\t\u0005u\u0011\u0011\u0006\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019\u00111\u0005\u0014\u0002\u0007\u0011$x.\u0003\u0003\u0002(\u0005\u0005\"!D*bi\u0016dG.\u001b;f\u0013:4w\u000eC\u0004\u0002,-\u0001\r!!\f\u0002\t\rL\u0017\n\u001a\t\u0005\u0003_\tiD\u0004\u0003\u00022\u0005e\u0002cAA\u001ai6\u0011\u0011Q\u0007\u0006\u0004\u0003oa\u0012A\u0002\u001fs_>$h(C\u0002\u0002<Q\fa\u0001\u0015:fI\u00164\u0017\u0002BA \u0003\u0003\u0012aa\u0015;sS:<'bAA\u001ei\u0006\u0001\u0012M]3QYV<\u0017N\\:Ts:\u001cW\r\u001a\u000b\u0005\u0003\u000f\n)\u0006\u0005\u0004\u0002J\u0005-\u0013qJ\u0007\u0002i&\u0019\u0011Q\n;\u0003\r=\u0003H/[8o!\u0011\tI%!\u0015\n\u0007\u0005MCOA\u0004C_>dW-\u00198\t\u000f\u0005-B\u00021\u0001\u0002.\u0005IA.[:u\u0011>\u001cHo\u001d\u000b\u000b\u00037\n\t(a\u001d\u0002x\u0005\u0005\u0005CBA/\u0003O\nY'\u0004\u0002\u0002`)!\u0011\u0011MA2\u0003\u0011)H/\u001b7\u000b\u0005\u0005\u0015\u0014\u0001\u00026bm\u0006LA!!\u001b\u0002`\t!A*[:u!\u0011\ty\"!\u001c\n\t\u0005=\u0014\u0011\u0005\u0002\u0014\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0017\n\u001a\u0005\b\u0003Wi\u0001\u0019AA\u0017\u0011\u001d\t)(\u0004a\u0001\u0003[\tAA\\1nK\"9\u0011\u0011P\u0007A\u0002\u0005m\u0014A\u00029bO&tw\r\u0005\u0003\u0002 \u0005u\u0014\u0002BA@\u0003C\u0011a\u0001U1hS:<\u0007bBAB\u001b\u0001\u0007\u0011QQ\u0001\u0006_J$WM\u001d\t\u0005\u0003?\t9)\u0003\u0003\u0002\n\u0006\u0005\"\u0001C(sI\u0016\u0014\u0018N\\4\u0002\u0015\r|WO\u001c;I_N$8\u000f\u0006\u0004\u0002\u0010\u0006m\u0015Q\u0014\t\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*!\u0011QSA2\u0003\u0011a\u0017M\\4\n\t\u0005e\u00151\u0013\u0002\b\u0013:$XmZ3s\u0011\u001d\tYC\u0004a\u0001\u0003[Aq!!\u001e\u000f\u0001\u0004\ti\u0003K\u0002\u0001\u0003C\u0003B!a)\u0002*6\u0011\u0011Q\u0015\u0006\u0004\u0003Ok\u0015AC:uKJ,w\u000e^=qK&!\u00111VAS\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class SatelliteServiceImpl
extends AbstractSecuredResource
implements SatelliteService,
Logging {
    private final SatelliteRepository satelliteRepository;
    private final RepositoryService repositoryService;
    @Context
    private final HttpResponse response;
    private final ActorSystem actorSystem;
    private final ExecutionContextExecutor dispatcher;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SatelliteServiceImpl satelliteServiceImpl = this;
        synchronized (satelliteServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public HttpResponse response() {
        return this.response;
    }

    public FiniteDuration defaultPingTimeout(ActorSystem taskActorSystem) {
        return ((CommonSettings)CommonSettings$.MODULE$.apply(taskActorSystem)).satellite().infoTimeout().duration();
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public ExecutionContextExecutor dispatcher() {
        return this.dispatcher;
    }

    public SatelliteInfo getInfo(String ciId) {
        Timeout timeout = new Timeout(this.defaultPingTimeout(this.actorSystem()));
        ConfigurationItem ci = this.repositoryService.read(ciId);
        if (!ci.getType().instanceOf(Type.valueOf((String)"xl.Satellite"))) {
            return null;
        }
        Satellite satellite = (Satellite)ci;
        ActorLocator actorLocator = ActorLocator$.MODULE$.apply(satellite);
        ActorRef checker = TaskActorSystem$.MODULE$.actorSystem().actorOf(SatelliteInfoChecker$.MODULE$.props(satellite.getAddress()));
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(checker);
        SatelliteInfoChecker.Get x$1 = new SatelliteInfoChecker.Get(actorLocator.locate(Paths$.MODULE$.info(), this.actorSystem()));
        Timeout x$2 = timeout;
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        Future future = AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3).recover((PartialFunction)new scala.Serializable(this, satellite){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SatelliteServiceImpl $outer;
            private final Satellite satellite$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Operation failed on satellite ").append($this.satellite$1.getAddress()).append(" (").append(A1.getMessage()).append(")").toString());
                SatelliteInfo satelliteInfo = new SatelliteInfo();
                return (B1)satelliteInfo;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.satellite$1 = satellite$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.deployit.core.rest.api.SatelliteServiceImpl$$anonfun$1 java.lang.Throwable )}, serializedLambda);
            }
        }, (ExecutionContext)this.dispatcher());
        SatelliteInfo satelliteInfo = (SatelliteInfo)Await$.MODULE$.result((Awaitable)future, package.DoubleMult$.MODULE$.$times$extension(package$.MODULE$.DoubleMult(1.5), (Duration)this.defaultPingTimeout(this.actorSystem())));
        Option<Object> option = this.arePluginsSynced(ci.getId());
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            boolean pluginSync = BoxesRunTime.unboxToBoolean((Object)some.value());
            if (Predef$.MODULE$.Boolean2boolean(satelliteInfo.isAvailable())) {
                satelliteInfo.setPluginsSynced(Predef$.MODULE$.boolean2Boolean(pluginSync));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        satelliteInfo.setSatelliteId(ciId);
        return satelliteInfo;
    }

    private Option<Object> arePluginsSynced(String ciId) {
        Option option;
        Timeout timeout = new Timeout(this.defaultPingTimeout(this.actorSystem()));
        ConfigurationItem ci = this.repositoryService.read(ciId);
        if (!ci.getType().instanceOf(Type.valueOf((String)"xl.Satellite"))) {
            return None$.MODULE$;
        }
        Satellite satellite = (Satellite)ci;
        ActorLocator actorLocator = ActorLocator$.MODULE$.apply(satellite);
        try {
            InstalledExtensionsDelta deltas = ExtensionsDelta$.MODULE$.calculateExtensionsDelta((ExtensionsLocator)FileSystemExtensionsLocator$.MODULE$, actorLocator, this.actorSystem());
            option = new Some((Object)BoxesRunTime.boxToBoolean((boolean)deltas.empty()));
        }
        catch (Exception exception) {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public List<ConfigurationItemId> listHosts(String ciId, String name, Paging paging, Ordering order) {
        this.checkPermission(PlatformPermissions.READ, ciId);
        Integer totalCount = this.countHosts(ciId, name);
        this.response().getOutputHeaders().putSingle((Object)Paging$.MODULE$.X_TOTAL_COUNT_HEADER(), (Object)totalCount);
        return this.satelliteRepository.listHosts(ciId, name, paging, order);
    }

    public Integer countHosts(String ciId, String name) {
        this.checkPermission(PlatformPermissions.READ, ciId);
        return Predef$.MODULE$.int2Integer(this.satelliteRepository.countHosts(ciId, name));
    }

    @Autowired
    public SatelliteServiceImpl(SatelliteRepository satelliteRepository, RepositoryService repositoryService) {
        this.satelliteRepository = satelliteRepository;
        this.repositoryService = repositoryService;
        Logging.$init$((Logging)this);
        this.response = null;
        this.actorSystem = TaskActorSystem$.MODULE$.actorSystem();
        this.dispatcher = this.actorSystem().dispatcher();
    }
}

