/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.IntUnaryOperator;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.IntIntConsumer;

public class Int2IntHashMap
implements Map<Integer, Integer>,
Serializable {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final int missingValue;
    private int resizeThreshold;
    private int size = 0;
    private final boolean shouldAvoidAllocation;
    private int[] entries;
    private KeySet keySet;
    private ValueCollection values;
    private EntrySet entrySet;

    public Int2IntHashMap(int missingValue) {
        this(8, 0.55f, missingValue);
    }

    public Int2IntHashMap(int initialCapacity, float loadFactor, int missingValue) {
        this(initialCapacity, loadFactor, missingValue, true);
    }

    public Int2IntHashMap(int initialCapacity, float loadFactor, int missingValue, boolean shouldAvoidAllocation) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.missingValue = missingValue;
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity)));
    }

    public int missingValue() {
        return this.missingValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.entries.length >> 2;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public int get(int key) {
        int[] entries = this.entries;
        int missingValue = this.missingValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        int value = missingValue;
        while (entries[index + 1] != missingValue) {
            if (entries[index] == key) {
                value = entries[index + 1];
                break;
            }
            index = Int2IntHashMap.next(index, mask);
        }
        return value;
    }

    @Override
    public int put(int key, int value) {
        if (value == this.missingValue) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        int[] entries = this.entries;
        int missingValue = this.missingValue;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        int oldValue = missingValue;
        while (entries[index + 1] != missingValue) {
            if (entries[index] == key) {
                oldValue = entries[index + 1];
                break;
            }
            index = Int2IntHashMap.next(index, mask);
        }
        if (oldValue == missingValue) {
            ++this.size;
            entries[index] = key;
        }
        entries[index + 1] = value;
        this.increaseCapacity();
        return oldValue;
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.entries.length;
            this.rehash(newCapacity);
        }
    }

    private void rehash(int newCapacity) {
        int[] oldEntries = this.entries;
        int missingValue = this.missingValue;
        int length = this.entries.length;
        this.capacity(newCapacity);
        int[] newEntries = this.entries;
        int mask = this.entries.length - 1;
        for (int keyIndex = 0; keyIndex < length; keyIndex += 2) {
            int value = oldEntries[keyIndex + 1];
            if (value == missingValue) continue;
            int key = oldEntries[keyIndex];
            int index = Hashing.evenHash(key, mask);
            while (newEntries[index + 1] != missingValue) {
                index = Int2IntHashMap.next(index, mask);
            }
            newEntries[index] = key;
            newEntries[index + 1] = value;
        }
    }

    public void intForEach(IntIntConsumer consumer) {
        int[] entries = this.entries;
        int missingValue = this.missingValue;
        int length = entries.length;
        for (int keyIndex = 0; keyIndex < length; keyIndex += 2) {
            if (entries[keyIndex + 1] == missingValue) continue;
            consumer.accept(entries[keyIndex], entries[keyIndex + 1]);
        }
    }

    public boolean containsKey(int key) {
        return this.get(key) != this.missingValue;
    }

    public boolean containsValue(int value) {
        boolean found = false;
        if (value != this.missingValue) {
            int[] entries = this.entries;
            int length = entries.length;
            for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
                if (value != entries[valueIndex]) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.entries, this.missingValue);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    public int computeIfAbsent(int key, IntUnaryOperator mappingFunction) {
        int value = this.get(key);
        if (value == this.missingValue && (value = mappingFunction.applyAsInt(key)) != this.missingValue) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    public Integer get(Object key) {
        return this.valOrNull(this.get((Integer)key));
    }

    @Override
    public Integer put(Integer key, Integer value) {
        return this.valOrNull(this.put((int)key, (int)value));
    }

    @Override
    public void forEach(BiConsumer<? super Integer, ? super Integer> action) {
        this.intForEach(action::accept);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Integer)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Integer)value);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Integer> map) {
        for (Map.Entry<? extends Integer, ? extends Integer> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.values) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Integer remove(Object key) {
        return this.valOrNull(this.remove((Integer)key));
    }

    public int remove(int key) {
        int[] entries = this.entries;
        int missingValue = this.missingValue;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        int oldValue = missingValue;
        while (entries[keyIndex + 1] != missingValue) {
            if (entries[keyIndex] == key) {
                oldValue = entries[keyIndex + 1];
                entries[keyIndex + 1] = missingValue;
                --this.size;
                this.compactChain(keyIndex);
                break;
            }
            keyIndex = Int2IntHashMap.next(keyIndex, mask);
        }
        return oldValue;
    }

    private void compactChain(int deleteKeyIndex) {
        int[] entries = this.entries;
        int missingValue = this.missingValue;
        int mask = entries.length - 1;
        int keyIndex = deleteKeyIndex;
        while (entries[(keyIndex = Int2IntHashMap.next(keyIndex, mask)) + 1] != missingValue) {
            int hash = Hashing.evenHash(entries[keyIndex], mask);
            if ((keyIndex >= hash || hash > deleteKeyIndex && deleteKeyIndex > keyIndex) && (hash > deleteKeyIndex || deleteKeyIndex > keyIndex)) continue;
            entries[deleteKeyIndex] = entries[keyIndex];
            entries[deleteKeyIndex + 1] = entries[keyIndex + 1];
            entries[keyIndex + 1] = missingValue;
            deleteKeyIndex = keyIndex;
        }
    }

    public int minValue() {
        int missingValue = this.missingValue;
        int min = this.size == 0 ? missingValue : Integer.MAX_VALUE;
        int[] entries = this.entries;
        int length = entries.length;
        for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
            int value = entries[valueIndex];
            if (value == missingValue) continue;
            min = Math.min(min, value);
        }
        return min;
    }

    public int maxValue() {
        int missingValue = this.missingValue;
        int max = this.size == 0 ? missingValue : Integer.MIN_VALUE;
        int[] entries = this.entries;
        int length = entries.length;
        for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
            int value = entries[valueIndex];
            if (value == missingValue) continue;
            max = Math.max(max, value);
        }
        return max;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder sb = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            sb.append(entryIterator.getIntKey()).append('=').append(entryIterator.getIntValue());
            if (!entryIterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public int replace(int key, int value) {
        int curValue = this.get(key);
        if (curValue != this.missingValue) {
            curValue = this.put(key, value);
        }
        return curValue;
    }

    @Override
    public boolean replace(int key, int oldValue, int newValue) {
        int curValue = this.get(key);
        if (curValue != oldValue || curValue == this.missingValue) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        return this.size == that.size() && this.entrySet().equals(that.entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    private static int next(int index, int mask) {
        return index + 2 & mask;
    }

    private void capacity(int newCapacity) {
        int entriesLength = newCapacity * 2;
        if (entriesLength < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = new int[entriesLength];
        Arrays.fill(this.entries, this.missingValue);
    }

    private Integer valOrNull(int value) {
        return value == this.missingValue ? null : Integer.valueOf(value);
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Integer, Integer>>
    implements Serializable {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Int2IntHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Int2IntHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Int2IntHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Int2IntHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry entry = (Map.Entry)o;
            Integer value = Int2IntHashMap.this.get(entry.getKey());
            return value != null && value.equals(entry.getValue());
        }
    }

    public final class ValueCollection
    extends AbstractCollection<Integer> {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Int2IntHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Int2IntHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Integer)o);
        }

        public boolean contains(int key) {
            return Int2IntHashMap.this.containsValue(key);
        }
    }

    public final class KeySet
    extends AbstractSet<Integer>
    implements Serializable {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Int2IntHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Int2IntHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Int2IntHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Int2IntHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Integer)o);
        }

        public boolean contains(int key) {
            return Int2IntHashMap.this.containsKey(key);
        }
    }

    public final class EntryIterator
    extends AbstractIterator
    implements Iterator<Map.Entry<Integer, Integer>>,
    Map.Entry<Integer, Integer> {
        @Override
        public Integer getKey() {
            return this.getIntKey();
        }

        public int getIntKey() {
            return Int2IntHashMap.this.entries[this.keyPosition()];
        }

        @Override
        public Integer getValue() {
            return this.getIntValue();
        }

        public int getIntValue() {
            return Int2IntHashMap.this.entries[this.keyPosition() + 1];
        }

        @Override
        public Integer setValue(Integer value) {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            if (Int2IntHashMap.this.missingValue == value) {
                throw new IllegalArgumentException();
            }
            int keyPosition = this.keyPosition();
            int prevValue = Int2IntHashMap.this.entries[keyPosition + 1];
            ((Int2IntHashMap)Int2IntHashMap.this).entries[keyPosition + 1] = value;
            return prevValue;
        }

        @Override
        public Map.Entry<Integer, Integer> next() {
            this.findNext();
            if (Int2IntHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<Integer, Integer> allocateDuplicateEntry() {
            final int k = this.getIntKey();
            final int v = this.getIntValue();
            return new Map.Entry<Integer, Integer>(){

                @Override
                public Integer getKey() {
                    return k;
                }

                @Override
                public Integer getValue() {
                    return v;
                }

                @Override
                public Integer setValue(Integer value) {
                    return Int2IntHashMap.this.put(k, (int)value);
                }

                @Override
                public int hashCode() {
                    return Integer.hashCode(EntryIterator.this.getIntKey()) ^ Integer.hashCode(EntryIterator.this.getIntValue());
                }

                @Override
                public boolean equals(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    return e.getKey() != null && e.getValue() != null && e.getKey().equals(k) && e.getValue().equals(v);
                }

                public String toString() {
                    return k + "=" + v;
                }
            };
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.getIntKey()) ^ Integer.hashCode(this.getIntValue());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue());
        }
    }

    public final class ValueIterator
    extends AbstractIterator
    implements Iterator<Integer> {
        @Override
        public Integer next() {
            return this.nextValue();
        }

        public int nextValue() {
            this.findNext();
            return Int2IntHashMap.this.entries[this.keyPosition() + 1];
        }
    }

    public final class KeyIterator
    extends AbstractIterator
    implements Iterator<Integer> {
        @Override
        public Integer next() {
            return this.nextValue();
        }

        public int nextValue() {
            this.findNext();
            return Int2IntHashMap.this.entries[this.keyPosition()];
        }
    }

    abstract class AbstractIterator
    implements Serializable {
        protected boolean isPositionValid = false;
        private int remaining;
        private int positionCounter;
        private int stopCounter;

        AbstractIterator() {
        }

        final void reset() {
            int capacity;
            this.isPositionValid = false;
            this.remaining = Int2IntHashMap.this.size;
            int missingValue = Int2IntHashMap.this.missingValue;
            int[] entries = Int2IntHashMap.this.entries;
            int keyIndex = capacity = entries.length;
            if (entries[capacity - 1] != missingValue) {
                for (keyIndex = 0; keyIndex < capacity && entries[keyIndex + 1] != missingValue; keyIndex += 2) {
                }
            }
            this.stopCounter = keyIndex;
            this.positionCounter = keyIndex + capacity;
        }

        protected final int keyPosition() {
            return this.positionCounter & Int2IntHashMap.this.entries.length - 1;
        }

        public int remaining() {
            return this.remaining;
        }

        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int[] entries = Int2IntHashMap.this.entries;
            int missingValue = Int2IntHashMap.this.missingValue;
            int mask = entries.length - 1;
            for (int keyIndex = this.positionCounter - 2; keyIndex >= this.stopCounter; keyIndex -= 2) {
                int index = keyIndex & mask;
                if (entries[index + 1] == missingValue) continue;
                this.isPositionValid = true;
                this.positionCounter = keyIndex;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.keyPosition();
            ((Int2IntHashMap)Int2IntHashMap.this).entries[position + 1] = Int2IntHashMap.this.missingValue;
            --Int2IntHashMap.this.size;
            Int2IntHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }
    }
}

