/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.FilterUtils;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;

public final class QueueConfig {
    private final long id;
    private final SimpleString address;
    private final SimpleString name;
    private final Filter filter;
    private final PageSubscription pageSubscription;
    private final SimpleString user;
    private final boolean durable;
    private final boolean temporary;
    private final boolean autoCreated;
    private final RoutingType routingType;
    private final int maxConsumers;
    private final boolean exclusive;
    private final boolean lastValue;
    private final boolean purgeOnNoConsumers;
    private final int consumersBeforeDispatch;
    private final long delayBeforeDispatch;
    private final boolean groupRebalance;
    private final int groupBuckets;
    private final SimpleString groupFirstKey;
    private final boolean configurationManaged;
    private final SimpleString lastValueKey;
    private final boolean nonDestructive;
    private final boolean autoDelete;
    private final long autoDeleteDelay;
    private final long autoDeleteMessageCount;

    public static Builder builderWith(long id, SimpleString name) {
        return new Builder(id, name);
    }

    public static Builder builderWith(long id, SimpleString name, SimpleString address) {
        return new Builder(id, name, address);
    }

    private QueueConfig(long id, SimpleString address, SimpleString name, Filter filter, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, RoutingType routingType, int maxConsumers, boolean exclusive, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean purgeOnNoConsumers, boolean groupRebalance, int groupBuckets, SimpleString groupFirstKey, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean configurationManaged) {
        this.id = id;
        this.address = address;
        this.name = name;
        this.filter = filter;
        this.pageSubscription = pageSubscription;
        this.user = user;
        this.durable = durable;
        this.temporary = temporary;
        this.autoCreated = autoCreated;
        this.routingType = routingType;
        this.purgeOnNoConsumers = purgeOnNoConsumers;
        this.exclusive = exclusive;
        this.lastValue = lastValue;
        this.lastValueKey = lastValueKey;
        this.nonDestructive = nonDestructive;
        this.maxConsumers = maxConsumers;
        this.consumersBeforeDispatch = consumersBeforeDispatch;
        this.delayBeforeDispatch = delayBeforeDispatch;
        this.groupRebalance = groupRebalance;
        this.groupBuckets = groupBuckets;
        this.groupFirstKey = groupFirstKey;
        this.autoDelete = autoDelete;
        this.autoDeleteDelay = autoDeleteDelay;
        this.autoDeleteMessageCount = autoDeleteMessageCount;
        this.configurationManaged = configurationManaged;
    }

    public long id() {
        return this.id;
    }

    public SimpleString address() {
        return this.address;
    }

    public SimpleString name() {
        return this.name;
    }

    public Filter filter() {
        return this.filter;
    }

    public PageSubscription pageSubscription() {
        return this.pageSubscription;
    }

    public SimpleString user() {
        return this.user;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public boolean isPurgeOnNoConsumers() {
        return this.purgeOnNoConsumers;
    }

    public int maxConsumers() {
        return this.maxConsumers;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isLastValue() {
        return this.lastValue;
    }

    public SimpleString lastValueKey() {
        return this.lastValueKey;
    }

    public boolean isNonDestructive() {
        return this.nonDestructive;
    }

    public RoutingType deliveryMode() {
        return this.routingType;
    }

    public int consumersBeforeDispatch() {
        return this.consumersBeforeDispatch;
    }

    public long delayBeforeDispatch() {
        return this.delayBeforeDispatch;
    }

    public boolean isGroupRebalance() {
        return this.groupRebalance;
    }

    public int getGroupBuckets() {
        return this.groupBuckets;
    }

    public SimpleString getGroupFirstKey() {
        return this.groupFirstKey;
    }

    public boolean isConfigurationManaged() {
        return this.configurationManaged;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public long getAutoDeleteDelay() {
        return this.autoDeleteDelay;
    }

    public long getAutoDeleteMessageCount() {
        return this.autoDeleteMessageCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueConfig that = (QueueConfig)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.durable != that.durable) {
            return false;
        }
        if (this.temporary != that.temporary) {
            return false;
        }
        if (this.autoCreated != that.autoCreated) {
            return false;
        }
        if (this.address != null ? !this.address.equals((Object)that.address) : that.address != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals((Object)that.name) : that.name != null) {
            return false;
        }
        if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
            return false;
        }
        if (this.pageSubscription != null ? !this.pageSubscription.equals(that.pageSubscription) : that.pageSubscription != null) {
            return false;
        }
        if (this.routingType != that.routingType) {
            return false;
        }
        if (this.maxConsumers != that.maxConsumers) {
            return false;
        }
        if (this.exclusive != that.exclusive) {
            return false;
        }
        if (this.lastValue != that.lastValue) {
            return false;
        }
        if (this.lastValueKey != null ? !this.lastValueKey.equals((Object)that.lastValueKey) : that.lastValueKey != null) {
            return false;
        }
        if (this.nonDestructive != that.nonDestructive) {
            return false;
        }
        if (this.purgeOnNoConsumers != that.purgeOnNoConsumers) {
            return false;
        }
        if (this.consumersBeforeDispatch != that.consumersBeforeDispatch) {
            return false;
        }
        if (this.delayBeforeDispatch != that.delayBeforeDispatch) {
            return false;
        }
        if (this.purgeOnNoConsumers != that.purgeOnNoConsumers) {
            return false;
        }
        if (this.groupRebalance != that.groupRebalance) {
            return false;
        }
        if (this.groupBuckets != that.groupBuckets) {
            return false;
        }
        if (this.groupFirstKey != null ? !this.groupFirstKey.equals((Object)that.groupFirstKey) : that.groupFirstKey != null) {
            return false;
        }
        if (this.autoDelete != that.autoDelete) {
            return false;
        }
        if (this.autoDeleteDelay != that.autoDeleteDelay) {
            return false;
        }
        if (this.autoDeleteMessageCount != that.autoDeleteMessageCount) {
            return false;
        }
        if (this.configurationManaged != that.configurationManaged) {
            return false;
        }
        return this.user != null ? this.user.equals((Object)that.user) : that.user == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        result = 31 * result + (this.pageSubscription != null ? this.pageSubscription.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.durable ? 1 : 0);
        result = 31 * result + (this.temporary ? 1 : 0);
        result = 31 * result + (this.autoCreated ? 1 : 0);
        result = 31 * result + this.routingType.getType();
        result = 31 * result + this.maxConsumers;
        result = 31 * result + (this.exclusive ? 1 : 0);
        result = 31 * result + (this.lastValue ? 1 : 0);
        result = 31 * result + (this.lastValueKey != null ? this.lastValueKey.hashCode() : 0);
        result = 31 * result + (this.nonDestructive ? 1 : 0);
        result = 31 * result + this.consumersBeforeDispatch;
        result = 31 * result + Long.hashCode(this.delayBeforeDispatch);
        result = 31 * result + (this.purgeOnNoConsumers ? 1 : 0);
        result = 31 * result + (this.groupRebalance ? 1 : 0);
        result = 31 * result + this.groupBuckets;
        result = 31 * result + (this.groupFirstKey != null ? this.groupFirstKey.hashCode() : 0);
        result = 31 * result + (this.autoDelete ? 1 : 0);
        result = 31 * result + Long.hashCode(this.autoDeleteDelay);
        result = 31 * result + Long.hashCode(this.autoDeleteMessageCount);
        result = 31 * result + (this.configurationManaged ? 1 : 0);
        return result;
    }

    public String toString() {
        return "QueueConfig{id=" + this.id + ", address=" + this.address + ", name=" + this.name + ", filter=" + this.filter + ", pageSubscription=" + this.pageSubscription + ", user=" + this.user + ", durable=" + this.durable + ", temporary=" + this.temporary + ", autoCreated=" + this.autoCreated + ", routingType=" + this.routingType + ", maxConsumers=" + this.maxConsumers + ", exclusive=" + this.exclusive + ", lastValue=" + this.lastValue + ", lastValueKey=" + this.lastValueKey + ", nonDestructive=" + this.nonDestructive + ", consumersBeforeDispatch=" + this.consumersBeforeDispatch + ", delayBeforeDispatch=" + this.delayBeforeDispatch + ", purgeOnNoConsumers=" + this.purgeOnNoConsumers + ", groupRebalance=" + this.groupRebalance + ", groupBuckets=" + this.groupBuckets + ", groupFirstKey=" + this.groupFirstKey + ", autoDelete=" + this.autoDelete + ", autoDeleteDelay=" + this.autoDeleteDelay + ", autoDeleteMessageCount=" + this.autoDeleteMessageCount + ", configurationManaged=" + this.configurationManaged + '}';
    }

    public static final class Builder {
        private final long id;
        private final SimpleString address;
        private final SimpleString name;
        private Filter filter;
        private PagingManager pagingManager;
        private SimpleString user;
        private boolean durable;
        private boolean temporary;
        private boolean autoCreated;
        private RoutingType routingType;
        private int maxConsumers;
        private boolean exclusive;
        private boolean lastValue;
        private SimpleString lastValueKey;
        private boolean nonDestructive;
        private boolean purgeOnNoConsumers;
        private int consumersBeforeDispatch;
        private long delayBeforeDispatch;
        private boolean groupRebalance;
        private int groupBuckets;
        private SimpleString groupFirstKey;
        private boolean autoDelete;
        private long autoDeleteDelay;
        private long autoDeleteMessageCount;
        private boolean configurationManaged;

        private Builder(long id, SimpleString name) {
            this(id, name, name);
        }

        private Builder(long id, SimpleString name, SimpleString address) {
            this.id = id;
            this.name = name;
            this.address = address;
            this.filter = null;
            this.pagingManager = null;
            this.user = null;
            this.durable = true;
            this.temporary = false;
            this.autoCreated = true;
            this.routingType = ActiveMQDefaultConfiguration.getDefaultRoutingType();
            this.maxConsumers = ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers();
            this.exclusive = ActiveMQDefaultConfiguration.getDefaultExclusive();
            this.lastValue = ActiveMQDefaultConfiguration.getDefaultLastValue();
            this.lastValueKey = ActiveMQDefaultConfiguration.getDefaultLastValueKey();
            this.nonDestructive = ActiveMQDefaultConfiguration.getDefaultNonDestructive();
            this.purgeOnNoConsumers = ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers();
            this.consumersBeforeDispatch = ActiveMQDefaultConfiguration.getDefaultConsumersBeforeDispatch();
            this.delayBeforeDispatch = ActiveMQDefaultConfiguration.getDefaultDelayBeforeDispatch();
            this.groupRebalance = ActiveMQDefaultConfiguration.getDefaultGroupRebalance();
            this.groupBuckets = ActiveMQDefaultConfiguration.getDefaultGroupBuckets();
            this.groupFirstKey = ActiveMQDefaultConfiguration.getDefaultGroupFirstKey();
            this.autoDelete = ActiveMQDefaultConfiguration.getDefaultQueueAutoDelete((boolean)this.autoCreated);
            this.autoDeleteDelay = ActiveMQDefaultConfiguration.getDefaultQueueAutoDeleteDelay();
            this.autoDeleteMessageCount = ActiveMQDefaultConfiguration.getDefaultQueueAutoDeleteMessageCount();
            this.configurationManaged = false;
            this.validateState();
        }

        private static boolean isEmptyOrNull(SimpleString value) {
            return value == null || value.length() == 0;
        }

        private void validateState() {
            if (Builder.isEmptyOrNull(this.name)) {
                throw new IllegalStateException("name can't be null or empty!");
            }
            if (Builder.isEmptyOrNull(this.address)) {
                throw new IllegalStateException("address can't be null or empty!");
            }
        }

        public Builder configurationManaged(boolean configurationManaged) {
            this.configurationManaged = configurationManaged;
            return this;
        }

        public Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public Builder pagingManager(PagingManager pagingManager) {
            this.pagingManager = pagingManager;
            return this;
        }

        public Builder user(SimpleString user) {
            this.user = user;
            return this;
        }

        public Builder durable(boolean durable) {
            this.durable = durable;
            return this;
        }

        public Builder temporary(boolean temporary) {
            this.temporary = temporary;
            return this;
        }

        public Builder autoCreated(boolean autoCreated) {
            this.autoCreated = autoCreated;
            return this;
        }

        public Builder maxConsumers(int maxConsumers) {
            this.maxConsumers = maxConsumers;
            return this;
        }

        public Builder exclusive(boolean exclusive) {
            this.exclusive = exclusive;
            return this;
        }

        public Builder lastValue(boolean lastValue) {
            this.lastValue = lastValue;
            return this;
        }

        public Builder lastValueKey(SimpleString lastValueKey) {
            this.lastValueKey = lastValueKey;
            return this;
        }

        public Builder nonDestructive(boolean nonDestructive) {
            this.nonDestructive = nonDestructive;
            return this;
        }

        public Builder consumersBeforeDispatch(int consumersBeforeDispatch) {
            this.consumersBeforeDispatch = consumersBeforeDispatch;
            return this;
        }

        public Builder delayBeforeDispatch(long delayBeforeDispatch) {
            this.delayBeforeDispatch = delayBeforeDispatch;
            return this;
        }

        public Builder purgeOnNoConsumers(boolean purgeOnNoConsumers) {
            this.purgeOnNoConsumers = purgeOnNoConsumers;
            return this;
        }

        public Builder autoDelete(boolean autoDelete) {
            this.autoDelete = autoDelete;
            return this;
        }

        public Builder autoDeleteDelay(long autoDeleteDelay) {
            this.autoDeleteDelay = autoDeleteDelay;
            return this;
        }

        public Builder autoDeleteMessageCount(long autoDeleteMessageCount) {
            this.autoDeleteMessageCount = autoDeleteMessageCount;
            return this;
        }

        public Builder groupRebalance(boolean groupRebalance) {
            this.groupRebalance = groupRebalance;
            return this;
        }

        public Builder groupBuckets(int groupBuckets) {
            this.groupBuckets = groupBuckets;
            return this;
        }

        public Builder groupFirstKey(SimpleString groupFirstKey) {
            this.groupFirstKey = groupFirstKey;
            return this;
        }

        public Builder routingType(RoutingType routingType) {
            this.routingType = routingType;
            return this;
        }

        public QueueConfig build() {
            PageSubscription pageSubscription;
            if (this.pagingManager != null && !FilterUtils.isTopicIdentification(this.filter)) {
                try {
                    PagingStore pageStore = this.pagingManager.getPageStore(this.address);
                    if (pageStore != null) {
                        pageSubscription = pageStore.getCursorProvider().createSubscription(this.id, this.filter, this.durable);
                    }
                    pageSubscription = null;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            } else {
                pageSubscription = null;
            }
            return new QueueConfig(this.id, this.address, this.name, this.filter, pageSubscription, this.user, this.durable, this.temporary, this.autoCreated, this.routingType, this.maxConsumers, this.exclusive, this.lastValue, this.lastValueKey, this.nonDestructive, this.consumersBeforeDispatch, this.delayBeforeDispatch, this.purgeOnNoConsumers, this.groupRebalance, this.groupBuckets, this.groupFirstKey, this.autoDelete, this.autoDeleteDelay, this.autoDeleteMessageCount, this.configurationManaged);
        }
    }
}

