/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.AeronClient;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.IpcPublication;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.Subscribable;
import io.aeron.driver.SubscriptionParams;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import java.util.IdentityHashMap;
import java.util.Map;
import org.agrona.concurrent.status.ReadablePosition;

public abstract class SubscriptionLink
implements DriverManagedResource {
    protected final long registrationId;
    protected final int streamId;
    protected final int sessionId;
    protected final boolean hasSessionId;
    protected final boolean isSparse;
    protected final String channel;
    protected final AeronClient aeronClient;
    protected final Map<Subscribable, ReadablePosition> positionBySubscribableMap = new IdentityHashMap<Subscribable, ReadablePosition>();
    protected boolean reachedEndOfLife = false;

    protected SubscriptionLink(long registrationId, int streamId, String channel, AeronClient aeronClient, SubscriptionParams params) {
        this.registrationId = registrationId;
        this.streamId = streamId;
        this.channel = channel;
        this.aeronClient = aeronClient;
        this.hasSessionId = params.hasSessionId;
        this.sessionId = params.sessionId;
        this.isSparse = params.isSparse;
    }

    public long registrationId() {
        return this.registrationId;
    }

    public int streamId() {
        return this.streamId;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public String channel() {
        return this.channel;
    }

    public ReceiveChannelEndpoint channelEndpoint() {
        return null;
    }

    public boolean isReliable() {
        return true;
    }

    public boolean isSparse() {
        return this.isSparse;
    }

    public boolean hasSessionId() {
        return this.hasSessionId;
    }

    public boolean matches(NetworkPublication publication) {
        return false;
    }

    public boolean matches(PublicationImage image) {
        return false;
    }

    public boolean matches(IpcPublication publication) {
        return false;
    }

    public boolean matches(ReceiveChannelEndpoint channelEndpoint, int streamId, SubscriptionParams params) {
        return false;
    }

    public boolean matches(ReceiveChannelEndpoint channelEndpoint, int streamId, int sessionId) {
        return false;
    }

    public boolean isLinked(Subscribable subscribable) {
        return this.positionBySubscribableMap.containsKey(subscribable);
    }

    public void link(Subscribable subscribable, ReadablePosition position) {
        this.positionBySubscribableMap.put(subscribable, position);
    }

    public void unlink(Subscribable subscribable) {
        this.positionBySubscribableMap.remove(subscribable);
    }

    @Override
    public void close() {
        this.positionBySubscribableMap.forEach(Subscribable::removeSubscriber);
    }

    @Override
    public void onTimeEvent(long timeNs, long timeMs, DriverConductor conductor) {
        if (this.aeronClient.hasTimedOut()) {
            this.reachedEndOfLife = true;
            conductor.cleanupSubscriptionLink(this);
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    public boolean isWildcardOrSessionIdMatch(int sessionId) {
        return !this.hasSessionId || this.sessionId == sessionId;
    }
}

