/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.telnet;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import com.xebialabs.overthere.cifs.ConnectionValidator;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.ProcessConnection;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetSocketAddress;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.WindowSizeOptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetConnection
implements ProcessConnection {
    private static final String DETECTABLE_WINDOWS_PROMPT = "TELNET4OVERTHERE ";
    private static final String ERRORLEVEL_PREAMBLE = "ERRORLEVEL-PREAMBLE";
    private static final String ERRORLEVEL_POSTAMBLE = "ERRORLEVEL-POSTAMBLE";
    private String address;
    private int port;
    private String password;
    private AddressPortMapper mapper;
    private int connectionTimeoutMillis;
    private int socketTimeoutMillis;
    private OperatingSystemFamily os;
    private OverthereFile workingDirectory;
    private String username;
    private String protocol;
    private CifsConnectionType connectionType = CifsConnectionType.TELNET;
    private static Logger logger = LoggerFactory.getLogger(TelnetConnection.class);

    public TelnetConnection(ConnectionOptions options, AddressPortMapper mapper, OverthereFile workingDirectory) {
        String unmappedAddress = (String)options.get("address");
        int unmappedPort = options.get("port", this.connectionType.getDefaultPort(options));
        InetSocketAddress addressPort = mapper.map(InetSocketAddress.createUnresolved(unmappedAddress, unmappedPort));
        this.os = options.getEnum("os", OperatingSystemFamily.class);
        this.connectionTimeoutMillis = options.getInteger("connectionTimeoutMillis", 120000);
        this.socketTimeoutMillis = options.getInteger("socketTimeoutMillis", 0);
        this.address = addressPort.getHostName();
        this.port = addressPort.getPort();
        this.username = (String)options.get("username");
        this.password = (String)options.get(ConnectionOptions.PASSWORD);
        this.mapper = mapper;
        this.workingDirectory = workingDirectory;
        this.protocol = (String)options.get("protocol");
        ConnectionValidator.checkIsWindowsHost(this.os, this.protocol, this.connectionType);
        ConnectionValidator.checkNotNewStyleWindowsDomain(this.username, this.protocol, this.connectionType);
    }

    @Override
    public OverthereProcess startProcess(final CmdLine cmd) {
        OverthereUtils.checkNotNull(cmd, "Cannot execute null command line", new Object[0]);
        OverthereUtils.checkArgument(cmd.getArguments().size() > 0, "Cannot execute empty command line", new Object[0]);
        final String obfuscatedCmd = cmd.toCommandLine(this.os, true);
        logger.info("Starting command [{}] on [{}]", (Object)obfuscatedCmd, (Object)this);
        try {
            final TelnetClient tc = new TelnetClient();
            tc.setSocketFactory(this.mapper.socketFactory());
            tc.setConnectTimeout(this.connectionTimeoutMillis);
            tc.addOptionHandler((TelnetOptionHandler)new WindowSizeOptionHandler(299, 25, true, false, true, false));
            logger.info("Connecting to telnet://{}@{}", (Object)this.username, (Object)this.address);
            tc.connect(this.address, this.port);
            tc.setSoTimeout(this.socketTimeoutMillis);
            final InputStream stdout = tc.getInputStream();
            final OutputStream stdin = tc.getOutputStream();
            final PipedInputStream callersStdout = new PipedInputStream();
            final PipedOutputStream toCallersStdout = new PipedOutputStream(callersStdout);
            final ByteArrayOutputStream outputBuf = new ByteArrayOutputStream();
            final int[] exitValue = new int[]{-1};
            final Thread outputReaderThread = new Thread("Telnet output reader"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    try {
                        TelnetConnection.receive(stdout, outputBuf, toCallersStdout, "ogin:");
                        TelnetConnection.send(stdin, TelnetConnection.this.username);
                        TelnetConnection.receive(stdout, outputBuf, toCallersStdout, "assword:");
                        TelnetConnection.send(stdin, TelnetConnection.this.password);
                        TelnetConnection.receive(stdout, outputBuf, toCallersStdout, ">", "ogon failure");
                        TelnetConnection.send(stdin, "PROMPT TELNET4OVERTHERE ");
                        TelnetConnection.receive(stdout, outputBuf, toCallersStdout, TelnetConnection.DETECTABLE_WINDOWS_PROMPT);
                        TelnetConnection.receive(stdout, outputBuf, toCallersStdout, TelnetConnection.DETECTABLE_WINDOWS_PROMPT);
                        if (TelnetConnection.this.workingDirectory != null) {
                            TelnetConnection.send(stdin, "CD /D " + TelnetConnection.this.workingDirectory.getPath());
                            TelnetConnection.receive(stdout, outputBuf, toCallersStdout, TelnetConnection.DETECTABLE_WINDOWS_PROMPT);
                        }
                        TelnetConnection.send(stdin, cmd.toCommandLine(TelnetConnection.this.os, false));
                        TelnetConnection.receive(stdout, outputBuf, toCallersStdout, TelnetConnection.DETECTABLE_WINDOWS_PROMPT);
                        TelnetConnection.send(stdin, "ECHO \"ERRORLEVEL-PREAMBLE%errorlevel%ERRORLEVEL-POSTAMBLE");
                        TelnetConnection.receive(stdout, outputBuf, toCallersStdout, TelnetConnection.ERRORLEVEL_POSTAMBLE);
                        TelnetConnection.receive(stdout, outputBuf, toCallersStdout, TelnetConnection.ERRORLEVEL_POSTAMBLE);
                        String outputBufStr = outputBuf.toString();
                        int preamblePos = outputBufStr.indexOf(TelnetConnection.ERRORLEVEL_PREAMBLE);
                        int postamblePos = outputBufStr.indexOf(TelnetConnection.ERRORLEVEL_POSTAMBLE);
                        if (preamblePos >= 0 && postamblePos >= 0) {
                            String errorlevelString = outputBufStr.substring(preamblePos + TelnetConnection.ERRORLEVEL_PREAMBLE.length(), postamblePos);
                            logger.debug("Errorlevel string found: {}", (Object)errorlevelString);
                            try {
                                int[] nArray = exitValue;
                                synchronized (exitValue) {
                                    exitValue[0] = Integer.parseInt(errorlevelString);
                                    // ** MonitorExit[var5_6] (shouldn't be in output)
                                    return;
                                }
                            }
                            catch (NumberFormatException exc) {
                                logger.error("Cannot parse errorlevel in Windows output: " + outputBuf);
                            }
                            return;
                        }
                        logger.error("Cannot find errorlevel in Windows output: " + outputBuf);
                        return;
                    }
                    catch (IOException exc) {
                        throw new RuntimeIOException(String.format("Cannot start command [%s] on [%s]", obfuscatedCmd, TelnetConnection.this), exc);
                    }
                    finally {
                        OverthereUtils.closeQuietly(toCallersStdout);
                    }
                }
            };
            outputReaderThread.setDaemon(true);
            outputReaderThread.start();
            return new OverthereProcess(){

                @Override
                public synchronized OutputStream getStdin() {
                    return stdin;
                }

                @Override
                public synchronized InputStream getStdout() {
                    return callersStdout;
                }

                @Override
                public synchronized InputStream getStderr() {
                    return new ByteArrayInputStream(new byte[0]);
                }

                @Override
                public synchronized int waitFor() {
                    if (!tc.isConnected()) {
                        return exitValue[0];
                    }
                    try {
                        try {
                            outputReaderThread.join();
                        }
                        finally {
                            this.disconnect();
                        }
                        return exitValue[0];
                    }
                    catch (InterruptedException exc) {
                        throw new RuntimeIOException(String.format("Cannot start command [%s] on [%s]", obfuscatedCmd, TelnetConnection.this), exc);
                    }
                }

                @Override
                public synchronized void destroy() {
                    if (!tc.isConnected()) {
                        return;
                    }
                    this.disconnect();
                }

                private synchronized void disconnect() {
                    try {
                        tc.disconnect();
                        logger.info("Disconnected from {}", (Object)TelnetConnection.this);
                        OverthereUtils.closeQuietly(toCallersStdout);
                    }
                    catch (IOException exc) {
                        throw new RuntimeIOException(String.format("Cannot disconnect from %s", TelnetConnection.this), exc);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public synchronized int exitValue() {
                    if (tc.isConnected()) {
                        throw new IllegalThreadStateException(String.format("Process for command [%s] on %s is still running", obfuscatedCmd, TelnetConnection.this));
                    }
                    int[] nArray = exitValue;
                    synchronized (exitValue) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return exitValue[0];
                    }
                }
            };
        }
        catch (InvalidTelnetOptionException exc) {
            throw new RuntimeIOException("Cannot execute command " + cmd + " at telnet://" + this.username + "@" + this.address, exc);
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot execute command " + cmd + " at telnet://" + this.username + "@" + this.address, exc);
        }
    }

    @Override
    public void connect() {
    }

    @Override
    public void close() {
    }

    @Override
    public void setWorkingDirectory(OverthereFile workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    private static void receive(InputStream stdout, ByteArrayOutputStream outputBuf, PipedOutputStream toCallersStdout, String expectedString) throws IOException {
        TelnetConnection.receive(stdout, outputBuf, toCallersStdout, expectedString, null);
    }

    private static void receive(InputStream stdout, ByteArrayOutputStream outputBuf, PipedOutputStream toCallersStdout, String expectedString, String unexpectedString) throws IOException {
        String s;
        String outputBufStr;
        boolean lastCharWasCr = false;
        boolean lastCharWasEsc = false;
        do {
            int cInt;
            if ((cInt = stdout.read()) == -1) {
                throw new IOException("End of stream reached");
            }
            outputBuf.write(cInt);
            outputBufStr = outputBuf.toString();
            char c = (char)cInt;
            switch (c) {
                case '\r': {
                    TelnetConnection.handleReceivedLine(outputBuf, outputBufStr, toCallersStdout);
                    break;
                }
                case '\n': {
                    if (lastCharWasCr) break;
                    TelnetConnection.handleReceivedLine(outputBuf, outputBufStr, toCallersStdout);
                    break;
                }
                case '[': {
                    if (!lastCharWasEsc) break;
                    throw new RuntimeIOException("VT100/ANSI escape sequence found in output stream. Please configure the Windows Telnet server to use stream mode (tlntadmn config mode=stream).");
                }
            }
            lastCharWasCr = c == '\r';
            boolean bl = lastCharWasEsc = c == '\u001b';
            if (unexpectedString == null || outputBufStr.length() < unexpectedString.length() || !(s = outputBufStr.substring(outputBufStr.length() - unexpectedString.length(), outputBufStr.length())).equals(unexpectedString)) continue;
            logger.debug("Unexpected string [{}] found in Windows Telnet output", (Object)unexpectedString);
            throw new IOException(String.format("Unexpected string [%s] found in Windows Telnet output", unexpectedString));
        } while (outputBufStr.length() < expectedString.length() || !(s = outputBufStr.substring(outputBufStr.length() - expectedString.length(), outputBufStr.length())).equals(expectedString));
        logger.debug("Expected string [{}] found in Windows Telnet output", (Object)expectedString);
    }

    private static void handleReceivedLine(ByteArrayOutputStream outputBuf, String outputBufStr, PipedOutputStream toCallersStdout) throws IOException {
        if (!outputBufStr.contains(DETECTABLE_WINDOWS_PROMPT)) {
            toCallersStdout.write(outputBuf.toByteArray());
            toCallersStdout.flush();
        }
        outputBuf.reset();
    }

    private static void send(OutputStream stdin, String lineToSend) throws IOException {
        byte[] bytesToSend = (lineToSend + "\r\n").getBytes();
        stdin.write(bytesToSend);
        stdin.flush();
    }
}

