/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.user;

import com.atlassian.crowd.embedded.api.UserComparator;
import com.atlassian.crowd.model.user.User;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;

public final class ImmutableUser
implements User {
    private final long directoryId;
    private final String name;
    private final boolean active;
    private final String emailAddress;
    private final String displayName;
    private final String firstName;
    private final String lastName;
    private final String externalId;

    public ImmutableUser(User user) {
        this(user.getDirectoryId(), user.getName(), user.getDisplayName(), user.getEmailAddress(), user.isActive(), user.getFirstName(), user.getLastName(), user.getExternalId());
    }

    public ImmutableUser(long directoryId, String name, String displayName, String emailAddress, boolean active, String firstName, String lastName, String externalId) {
        this.directoryId = directoryId;
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.displayName = displayName;
        this.emailAddress = emailAddress;
        this.active = active;
        this.firstName = firstName;
        this.lastName = lastName;
        this.externalId = externalId;
    }

    private ImmutableUser(Builder builder) {
        this.directoryId = builder.directoryId;
        this.name = (String)Preconditions.checkNotNull((Object)builder.name);
        this.displayName = builder.displayName;
        this.emailAddress = builder.emailAddress;
        this.active = builder.active;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.externalId = builder.externalId;
    }

    public static ImmutableUser from(User user) {
        if (user instanceof ImmutableUser) {
            return (ImmutableUser)user;
        }
        return ImmutableUser.builder(user).build();
    }

    public static Builder builder(long directoryId, String name) {
        return new Builder(directoryId, name);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static Builder builder(User user) {
        return new Builder(user);
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public long getDirectoryId() {
        return this.directoryId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public boolean equals(Object o) {
        return UserComparator.equalsObject((com.atlassian.crowd.embedded.api.User)this, (Object)o);
    }

    @Override
    public int hashCode() {
        return UserComparator.hashCode((com.atlassian.crowd.embedded.api.User)this);
    }

    public int compareTo(com.atlassian.crowd.embedded.api.User user) {
        return UserComparator.compareTo((com.atlassian.crowd.embedded.api.User)this, (com.atlassian.crowd.embedded.api.User)user);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("directoryId", this.directoryId).add("name", (Object)this.name).add("active", this.active).add("emailAddress", (Object)this.emailAddress).add("displayName", (Object)this.displayName).add("firstName", (Object)this.firstName).add("lastName", (Object)this.lastName).add("externalId", (Object)this.externalId).toString();
    }

    public static class Builder {
        private long directoryId;
        private String name;
        private boolean active;
        private String emailAddress;
        private String displayName;
        private String firstName;
        private String lastName;
        private String externalId;

        public Builder(User user) {
            this.directoryId = user.getDirectoryId();
            this.name = user.getName();
            this.active = user.isActive();
            this.emailAddress = user.getEmailAddress();
            this.displayName = user.getDisplayName();
            this.firstName = user.getFirstName();
            this.lastName = user.getLastName();
            this.externalId = user.getExternalId();
        }

        public Builder(String name) {
            this.name = name;
        }

        public Builder(long directoryId, String name) {
            this.directoryId = directoryId;
            this.name = name;
        }

        public Builder directoryId(long directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public ImmutableUser build() {
            return new ImmutableUser(this);
        }
    }
}

