/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.swing;

import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.swing.MutableTableModelEvent;
import ca.odell.glazedlists.swing.TableModelEventAdapter;
import java.awt.EventQueue;
import javax.swing.table.AbstractTableModel;

class DefaultTableModelEventAdapter<E>
implements TableModelEventAdapter<E> {
    private final MutableTableModelEvent tableModelEvent;
    private final AbstractTableModel tableModel;

    DefaultTableModelEventAdapter(AbstractTableModel tableModel) {
        this.tableModelEvent = new MutableTableModelEvent(tableModel);
        this.tableModel = tableModel;
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        this.checkAccessThread();
        while (listChanges.nextBlock()) {
            int startIndex = listChanges.getBlockStartIndex();
            int endIndex = listChanges.getBlockEndIndex();
            int changeType = listChanges.getType();
            this.tableModelEvent.setValues(startIndex, endIndex, changeType);
            this.tableModel.fireTableChanged(this.tableModelEvent);
        }
    }

    @Override
    public final void fireTableStructureChanged() {
        this.tableModelEvent.setStructureChanged();
        this.tableModel.fireTableChanged(this.tableModelEvent);
    }

    @Override
    public final void fireTableDataChanged() {
        this.tableModelEvent.setAllDataChanged();
        this.tableModel.fireTableChanged(this.tableModelEvent);
    }

    @Override
    public final void fireTableChanged(int startIndex, int endIndex, int listChangeType) {
        this.tableModelEvent.setValues(startIndex, endIndex, listChangeType);
        this.tableModel.fireTableChanged(this.tableModelEvent);
    }

    protected final void checkAccessThread() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Events to " + this.tableModel.getClass().getSimpleName() + " must arrive on the EDT - consider adding GlazedListsSwing.swingThreadProxyList(source) somewhere in your list pipeline");
        }
    }
}

