/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.inspection;

import com.xebialabs.deployit.inspection.InspectionContextAdapter;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Inspector {
    private static final Logger logger = LoggerFactory.getLogger(Inspector.class);

    public static void inspect(ConfigurationItem item, InspectionContext context) {
        Inspector.checkRequiredDiscoveryProperties(item);
        Method inspectMethod = Inspector.findInspectMethod(item);
        if (inspectMethod != null) {
            logger.debug("Invoking @Inspect method on {}", (Object)item);
            Class<?>[] parameterTypes = inspectMethod.getParameterTypes();
            if (parameterTypes[0].equals(InspectionPlanningContext.class)) {
                Inspector.callInspectionMethod(inspectMethod, item, new InspectionContextAdapter(context));
            } else if (parameterTypes[0].equals(InspectionContext.class)) {
                Inspector.callInspectionMethod(inspectMethod, item, context);
            }
            context.inspected(item);
        }
    }

    private static void callInspectionMethod(Method inspectMethod, ConfigurationItem item, Object ctx) {
        try {
            inspectMethod.invoke((Object)item, ctx);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Cannot invoke @Inspect method on " + item, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot invoke @Inspect method on " + item, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error invoking @Inspect method on " + item, e);
        }
    }

    private static void checkRequiredDiscoveryProperties(ConfigurationItem item) {
        Descriptor descriptor = item.getType().getDescriptor();
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            Object o;
            if (!propertyDescriptor.isInspectionProperty() || !propertyDescriptor.isRequiredForInspection() || (o = propertyDescriptor.get(item)) != null) continue;
            throw new IllegalArgumentException("Missing required property for discovery " + propertyDescriptor.getName());
        }
    }

    private static Method findInspectMethod(ConfigurationItem item) {
        Method[] methods;
        for (Method method : methods = item.getClass().getMethods()) {
            if (!method.isAnnotationPresent(Inspect.class)) continue;
            return method;
        }
        return null;
    }
}

