/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.security.RepoUser;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.UserAlreadyExistsException;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.security.authentication.CryptedSimpleCredentials;

public class JackrabbitUserService
implements UserService {
    private final JcrTemplate jcrTemplate;

    public JackrabbitUserService(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    public long countUsers(String username) {
        return -1L;
    }

    public void create(String username, String password) {
        this.jcrTemplate.execute(session -> {
            UserManager um = ((JackrabbitSession)session).getUserManager();
            try {
                um.createUser(username, password);
            }
            catch (AuthorizableExistsException e) {
                throw new UserAlreadyExistsException(username);
            }
            return null;
        });
    }

    public RepoUser read(String username) {
        return (RepoUser)this.jcrTemplate.execute(session -> {
            User u = this.getUser(username, session);
            return new RepoUser(u.getID(), u.isAdmin());
        });
    }

    public List<String> listUsernames() {
        return this.listUsernames(null, null, null);
    }

    public List<String> listUsernames(String username, Paging paging, Ordering order) {
        return (List)this.jcrTemplate.execute(session -> {
            UserManager um = ((JackrabbitSession)session).getUserManager();
            Iterator authorizables = um.findAuthorizables(new Query(){

                public <T> void build(QueryBuilder<T> builder) {
                    builder.setSelector(User.class);
                }
            });
            ArrayList<String> names = new ArrayList<String>();
            while (authorizables.hasNext()) {
                String name = ((Authorizable)authorizables.next()).getPrincipal().getName();
                if ("anonymous".equals(name)) continue;
                names.add(name);
            }
            return names;
        });
    }

    public void modifyPassword(String username, String newPassword) {
        this.jcrTemplate.execute(session -> {
            User u = this.getUser(username, session);
            u.changePassword(newPassword);
            return null;
        });
    }

    public void modifyPassword(String username, String newPassword, String oldPassword) {
        this.jcrTemplate.execute(session -> {
            User u = this.getUser(username, session);
            try {
                u.changePassword(newPassword, oldPassword);
            }
            catch (RepositoryException e) {
                throw new IllegalArgumentException(e);
            }
            return null;
        });
    }

    public void delete(String username) {
        this.jcrTemplate.execute(session -> {
            User u = this.getUser(username, session);
            u.remove();
            return null;
        });
    }

    public void authenticate(String username, String password) throws AuthenticationFailureException {
        if ("jcr_admin".equals(username.toLowerCase())) {
            throw new AuthenticationFailureException("Cannot authenticate [%s]", new Object[]{username});
        }
        this.jcrTemplate.execute(session -> {
            UserManager um = ((JackrabbitSession)session).getUserManager();
            User user = (User)um.getAuthorizable(username);
            if (user == null) {
                throw new AuthenticationFailureException("Cannot authenticate [%s],", new Object[]{username});
            }
            Credentials credentials = user.getCredentials();
            this.validateCredentials(credentials, username, password);
            return null;
        });
    }

    private User getUser(String username, Session session) throws RepositoryException {
        UserManager um = ((JackrabbitSession)session).getUserManager();
        Authorizable authorizable = um.getAuthorizable(username);
        if (authorizable == null) {
            throw new NotFoundException("No such user: " + username, new Object[0]);
        }
        if (authorizable.isGroup()) {
            throw new IllegalStateException("Principal " + username + " is not a user");
        }
        return (User)authorizable;
    }

    private void validateCredentials(Credentials credentials, String username, String password) {
        OverthereUtils.checkState((boolean)(credentials instanceof CryptedSimpleCredentials), (String)"Should have an instance of CryptedSimpleCredentials", (Object[])new Object[0]);
        try {
            if (!((CryptedSimpleCredentials)credentials).matches(new SimpleCredentials(username, password.toCharArray()))) {
                throw new AuthenticationFailureException("Wrong credentials supplied for user [%s]", new Object[]{username});
            }
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new AuthenticationFailureException((Throwable)e);
        }
    }
}

