/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.pool;

import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.pool.BundleDbPersistenceManager;

public class H2PersistenceManager
extends BundleDbPersistenceManager {
    private long lockTimeout = 10000L;

    public String getLockTimeout() {
        return String.valueOf(this.lockTimeout);
    }

    public void setLockTimeout(String lockTimeout) {
        this.lockTimeout = Long.parseLong(lockTimeout);
    }

    @Override
    public void init(PMContext context) throws Exception {
        if (this.getDriver() == null) {
            this.setDriver("org.h2.Driver");
        }
        if (this.getUrl() == null) {
            this.setUrl("jdbc:h2:file:" + context.getHomeDir().getPath() + "/db/itemState");
        }
        if (this.getDatabaseType() == null) {
            this.setDatabaseType("h2");
        }
        if (this.getSchemaObjectPrefix() == null) {
            this.setSchemaObjectPrefix("");
        }
        super.init(context);
        this.conHelper.exec("SET LOCK_TIMEOUT " + this.lockTimeout, new Object[0]);
    }
}

