/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user.action;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.security.user.PasswordUtility;
import org.apache.jackrabbit.core.security.user.action.AbstractAuthorizableAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordValidationAction
extends AbstractAuthorizableAction {
    private static final Logger log = LoggerFactory.getLogger(PasswordValidationAction.class);
    private Pattern pattern;

    @Override
    public void onCreate(User user, String password, Session session) throws RepositoryException {
        this.validatePassword(password, false);
    }

    @Override
    public void onPasswordChange(User user, String newPassword, Session session) throws RepositoryException {
        this.validatePassword(newPassword, true);
    }

    public void setConstraint(String constraint) {
        try {
            this.pattern = Pattern.compile(constraint);
        }
        catch (PatternSyntaxException e) {
            log.warn("Invalid password constraint: {}", (Object)e.getMessage());
        }
    }

    private void validatePassword(String password, boolean forceMatch) throws RepositoryException {
        if (password != null && (forceMatch || PasswordUtility.isPlainTextPassword(password)) && this.pattern != null && !this.pattern.matcher(password).matches()) {
            throw new ConstraintViolationException("Password violates password constraint (" + this.pattern.pattern() + ").");
        }
    }
}

