/*
 * Decompiled with CFR 0.152.
 */
package kamon.metric;

import com.typesafe.config.Config;
import java.io.Serializable;
import kamon.metric.EntityFilter;
import kamon.metric.MetricsSettings;
import kamon.metric.instrument.DefaultInstrumentSettings;
import kamon.metric.instrument.DefaultInstrumentSettings$;
import kamon.metric.instrument.InstrumentCustomSettings;
import kamon.metric.instrument.InstrumentCustomSettings$;
import kamon.metric.instrument.InstrumentFactory;
import kamon.metric.instrument.LazyRefreshScheduler;
import kamon.metric.instrument.RefreshScheduler;
import kamon.util.ConfigTools$;
import kamon.util.ConfigTools$Syntax$;
import kamon.util.GlobPathFilter;
import kamon.util.PathFilter;
import kamon.util.RegexPathFilter;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;

public final class MetricsSettings$
implements scala.Serializable {
    public static MetricsSettings$ MODULE$;

    static {
        new MetricsSettings$();
    }

    public MetricsSettings apply(Config config) {
        Config metricConfig = config.getConfig("kamon.metric");
        FiniteDuration tickInterval = ConfigTools$Syntax$.MODULE$.getFiniteDuration$extension(ConfigTools$.MODULE$.Syntax(metricConfig), "tick-interval");
        int collectBufferSize = metricConfig.getInt("default-collection-context-buffer-size");
        boolean trackUnmatchedEntities = metricConfig.getBoolean("track-unmatched-entities");
        Map<String, EntityFilter> entityFilters = this.loadFilters(metricConfig.getConfig("filters"));
        DefaultInstrumentSettings defaultInstrumentSettings = DefaultInstrumentSettings$.MODULE$.fromConfig(metricConfig.getConfig("default-instrument-settings"));
        LazyRefreshScheduler refreshScheduler = new LazyRefreshScheduler();
        Map<String, InstrumentFactory> instrumentFactories = this.loadInstrumentFactories(metricConfig.getConfig("instrument-settings"), defaultInstrumentSettings, refreshScheduler);
        InstrumentFactory defaultInstrumentFactory = new InstrumentFactory((Map<String, InstrumentCustomSettings>)Predef$.MODULE$.Map().empty(), defaultInstrumentSettings, refreshScheduler);
        return new MetricsSettings(tickInterval, collectBufferSize, trackUnmatchedEntities, entityFilters, instrumentFactories, defaultInstrumentFactory, refreshScheduler);
    }

    public Map<String, EntityFilter> loadFilters(Config filtersConfig) {
        return ((TraversableOnce)ConfigTools$Syntax$.MODULE$.firstLevelKeys$extension(ConfigTools$.MODULE$.Syntax(filtersConfig)).map((Function1 & Serializable & scala.Serializable)category -> {
            boolean asRegex = filtersConfig.hasPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".asRegex"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{category}))) ? filtersConfig.getBoolean(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".asRegex"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{category}))) : false;
            List includes = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(filtersConfig.getStringList(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".includes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{category})))).asScala()).map((Function1 & Serializable & scala.Serializable)inc -> asRegex ? new RegexPathFilter((String)inc) : new GlobPathFilter((String)inc), Buffer$.MODULE$.canBuildFrom())).toList();
            List excludes = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(filtersConfig.getStringList(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".excludes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{category})))).asScala()).map((Function1 & Serializable & scala.Serializable)exc -> asRegex ? new RegexPathFilter((String)exc) : new GlobPathFilter((String)exc), Buffer$.MODULE$.canBuildFrom())).toList();
            return new Tuple2(category, (Object)new EntityFilter((List<PathFilter>)includes, (List<PathFilter>)excludes));
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, InstrumentFactory> loadInstrumentFactories(Config instrumentSettings, DefaultInstrumentSettings defaults, RefreshScheduler refreshScheduler) {
        return ((TraversableOnce)ConfigTools$Syntax$.MODULE$.firstLevelKeys$extension(ConfigTools$.MODULE$.Syntax(instrumentSettings)).map((Function1 & Serializable & scala.Serializable)category -> {
            Config categoryConfig = instrumentSettings.getConfig(category);
            Map customSettings = ((TraversableOnce)ConfigTools$Syntax$.MODULE$.firstLevelKeys$extension(ConfigTools$.MODULE$.Syntax(categoryConfig)).map((Function1 & Serializable & scala.Serializable)instrumentName -> new Tuple2(instrumentName, (Object)InstrumentCustomSettings$.MODULE$.fromConfig(categoryConfig.getConfig(instrumentName))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            return new Tuple2(category, (Object)new InstrumentFactory((Map<String, InstrumentCustomSettings>)customSettings, defaults, refreshScheduler));
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public MetricsSettings apply(FiniteDuration tickInterval, int defaultCollectionContextBufferSize, boolean trackUnmatchedEntities, Map<String, EntityFilter> entityFilters, Map<String, InstrumentFactory> instrumentFactories, InstrumentFactory defaultInstrumentFactory, RefreshScheduler refreshScheduler) {
        return new MetricsSettings(tickInterval, defaultCollectionContextBufferSize, trackUnmatchedEntities, entityFilters, instrumentFactories, defaultInstrumentFactory, refreshScheduler);
    }

    public Option<Tuple7<FiniteDuration, Object, Object, Map<String, EntityFilter>, Map<String, InstrumentFactory>, InstrumentFactory, RefreshScheduler>> unapply(MetricsSettings x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.tickInterval(), (Object)BoxesRunTime.boxToInteger((int)x$0.defaultCollectionContextBufferSize()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.trackUnmatchedEntities()), x$0.entityFilters(), x$0.instrumentFactories(), (Object)x$0.defaultInstrumentFactory(), (Object)x$0.refreshScheduler()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MetricsSettings$() {
        MODULE$ = this;
    }
}

