/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade;

import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.placeholders.PlaceholderRepository;
import com.xebialabs.deployit.repository.sql.CiRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.Version;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001\u0002\b\u0010\u0001iA\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\ti\u0001\u0011\t\u0011)A\u0005]!AQ\u0007\u0001BC\u0002\u0013\u0005a\u0007\u0003\u0005C\u0001\t\u0005\t\u0015!\u00038\u0011!\u0019\u0005A!A!\u0002\u0013!\u0005\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u0011\u0015\u0004!\u0011!Q\u0001\n\u0019DQ!\u001c\u0001\u0005\u00029D\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u0013Aq!a\u0006\u0001\t\u0003\nI\u0002C\u0004\u0002\"\u0001!I!a\t\t\u000f\u0005]\u0003\u0001\"\u0011\u0002Z\tIC)\u001a9m_fLG/\u000f\u00191\u0007&\u0004F.Y2fQ>dG-\u001a:NS\u001e\u0014\u0018\r^5p]V\u0003xM]1eKJT!\u0001E\t\u0002\u000fU\u0004xM]1eK*\u0011!cE\u0001\u0005G>\u0014XM\u0003\u0002\u0015+\u0005AA-\u001a9m_fLGO\u0003\u0002\u0017/\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00021\u0005\u00191m\\7\u0004\u0001M\u0019\u0001a\u0007\u0013\u0011\u0005q\u0011S\"A\u000f\u000b\u0005Aq\"BA\u0010!\u0003\r\t\u0007/\u001b\u0006\u0003CM\taa]3sm\u0016\u0014\u0018BA\u0012\u001e\u0005\u001d)\u0006o\u001a:bI\u0016\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\u000bMdg\r\u000e6\u000b\u0003%\n\u0001b\u001a:jujdW\rZ\u0005\u0003W\u0019\u0012q\u0001T8hO&tw-\u0001\u0006tc2$\u0015.\u00197fGR,\u0012A\f\t\u0003_Ij\u0011\u0001\r\u0006\u0003cE\t1a]9m\u0013\t\u0019\u0004G\u0001\u0006Tc2$\u0015.\u00197fGR\f1b]9m\t&\fG.Z2uA\u0005a!\u000e\u001a2d)\u0016l\u0007\u000f\\1uKV\tq\u0007\u0005\u00029\u00016\t\u0011H\u0003\u0002\u0013u)\u00111\bP\u0001\u0005U\u0012\u00147M\u0003\u0002>}\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001@\u0003\ry'oZ\u0005\u0003\u0003f\u0012AB\u00133cGR+W\u000e\u001d7bi\u0016\fQB\u001b3cGR+W\u000e\u001d7bi\u0016\u0004\u0013A\u0005;sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJ\u0004\"!\u0012%\u000e\u0003\u0019S!a\u0012\u001f\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0003\u0013\u001a\u0013!\u0004\u00157bi\u001a|'/\u001c+sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJDC!B&V-B\u0011AjU\u0007\u0002\u001b*\u0011ajT\u0001\u000bC:tw\u000e^1uS>t'B\u0001)R\u0003\u001d1\u0017m\u0019;pefT!A\u0015\u001f\u0002\u000b\t,\u0017M\\:\n\u0005Qk%!C)vC2Lg-[3s\u0003\u00151\u0018\r\\;fC\u00059\u0016AF7bS:$&/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:)\u0005\u0015I\u0006C\u0001'[\u0013\tYVJA\u0005BkR|w/\u001b:fI\u0006a1-\u001b*fa>\u001c\u0018\u000e^8ssB\u0011aLY\u0007\u0002?*\u0011\u0011\u0007\u0019\u0006\u0003CN\t!B]3q_NLGo\u001c:z\u0013\t\u0019wL\u0001\u0007DSJ+\u0007o\\:ji>\u0014\u0018\u0010\u000b\u0002\u00073\u0006)\u0002\u000f\\1dK\"|G\u000eZ3s%\u0016\u0004xn]5u_JL\bCA4k\u001b\u0005A'BA5a\u00031\u0001H.Y2fQ>dG-\u001a:t\u0013\tY\u0007NA\u000bQY\u0006\u001cW\r[8mI\u0016\u0014(+\u001a9pg&$xN]=)\u0005\u001dI\u0016A\u0002\u001fj]&$h\bF\u0004pcZ\\h0!\u0001\u0011\u0005A\u0004Q\"A\b\t\u000b1B\u0001\u0019\u0001\u0018)\tE\\Uk]\u0011\u0002i\u0006qQ.Y5o'FdG)[1mK\u000e$\bFA9Z\u0011\u0015)\u0004\u00021\u00018Q\u001118*\u0016=\"\u0003e\f\u0001#\\1j]*#'m\u0019+f[Bd\u0017\r^3)\u0005YL\u0006\"B\"\t\u0001\u0004!\u0005\u0006B>L+ZC#a_-\t\u000bqC\u0001\u0019A/)\u0005yL\u0006\"B3\t\u0001\u00041\u0007fAA\u00013\u0006I\u0001+Q$F?NK%,R\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0003\u0003\u001f\tQa]2bY\u0006LA!a\u0005\u0002\u000e\t\u0019\u0011J\u001c;\u0002\u0015A\u000bu)R0T\u0013j+\u0005%A\u0005e_V\u0003xM]1eKR\u0011\u00111\u0004\t\u0005\u0003\u0017\ti\"\u0003\u0003\u0002 \u00055!a\u0002\"p_2,\u0017M\\\u0001\u0013e\u0016\fGmQ5Pe\u000e\u000bGo\u00195FeJ|'\u000f\u0006\u0003\u0002&\u0005u\u0002CBA\u0006\u0003O\tY#\u0003\u0003\u0002*\u00055!AB(qi&|g\u000e\u0005\u0003\u0002.\u0005eRBAA\u0018\u0015\u0011\t\t$a\r\u0002\u0007U$WNC\u0002 \u0003kQ1!a\u000e\u0014\u0003\u0019\u0001H.^4j]&!\u00111HA\u0018\u0005E\u0019uN\u001c4jOV\u0014\u0018\r^5p]&#X-\u001c\u0005\b\u0003\u007fa\u0001\u0019AA!\u0003\tIG\r\u0005\u0003\u0002D\u0005Ec\u0002BA#\u0003\u001b\u0002B!a\u0012\u0002\u000e5\u0011\u0011\u0011\n\u0006\u0004\u0003\u0017J\u0012A\u0002\u001fs_>$h(\u0003\u0003\u0002P\u00055\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002T\u0005U#AB*ue&twM\u0003\u0003\u0002P\u00055\u0011AD;qOJ\fG-\u001a,feNLwN\u001c\u000b\u0003\u00037\u00022\u0001HA/\u0013\r\ty&\b\u0002\b-\u0016\u00148/[8o\u0001")
public class Deployit900CiPlaceholderMigrationUpgrader
extends Upgrade
implements Logging {
    private final SqlDialect sqlDialect;
    private final JdbcTemplate jdbcTemplate;
    @Autowired
    private final CiRepository ciRepository;
    @Autowired
    private final PlaceholderRepository placeholderRepository;
    private final int PAGE_SIZE;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        Deployit900CiPlaceholderMigrationUpgrader deployit900CiPlaceholderMigrationUpgrader = this;
        synchronized (deployit900CiPlaceholderMigrationUpgrader) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    private int PAGE_SIZE() {
        return this.PAGE_SIZE;
    }

    public boolean doUpgrade() {
        Integer count = this.ciRepository.count(new SearchParameters().setAncestor("Applications"));
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Running placeholder migration on ").append(count).append(" CIs in batches of ").append(this.PAGE_SIZE()).append(".").toString());
        IntRef pagesIndexed = IntRef.create((int)0);
        int totalPages = (Predef$.MODULE$.Integer2int(count) + this.PAGE_SIZE() - 1) / this.PAGE_SIZE();
        while (pagesIndexed.elem < totalPages) {
            SearchParameters params = new SearchParameters().setAncestor("Applications").setPage((long)pagesIndexed.elem).setResultsPerPage((long)this.PAGE_SIZE());
            Buffer existingTypeCiIds = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.ciRepository.list(params)).asScala()).flatMap((Function1 & Serializable & scala.Serializable)ciData -> {
                Iterable iterable;
                if (ciData.getType().exists()) {
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)ciData.getId()));
                } else {
                    this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Skipping placeholder migration for '").append(ciData.getId()).append("'. Unknown type: '").append(ciData.getType()).append("'.").toString());
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }, Buffer$.MODULE$.canBuildFrom());
            List cis = ((TraversableOnce)existingTypeCiIds.flatMap((Function1 & Serializable & scala.Serializable)id -> Option$.MODULE$.option2Iterable(this.readCiOrCatchError((String)id)), Buffer$.MODULE$.canBuildFrom())).toList();
            this.placeholderRepository.savePlaceholders(cis);
            ++pagesIndexed.elem;
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Completed batch ").append(pagesIndexed$1.elem).append(" / total: ").append(totalPages).append(".").toString());
        }
        return true;
    }

    private Option<ConfigurationItem> readCiOrCatchError(String id) {
        Some some;
        try {
            String x$1 = id;
            Object x$2 = null;
            boolean x$3 = false;
            int x$4 = 1;
            boolean x$5 = this.ciRepository.read$default$5();
            Some some2 = new Some((Object)this.ciRepository.read(x$1, null, x$4, x$3, x$5));
            some = some2;
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Unable to read ConfigurationItem[").append(id).append("]. Reason: ").append(e.getMessage()).toString());
            some = None$.MODULE$;
        }
        return some;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)"9.0.0");
    }

    public Deployit900CiPlaceholderMigrationUpgrader(@Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect, @Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainTransactionManager") PlatformTransactionManager transactionManager, @Autowired CiRepository ciRepository, @Autowired PlaceholderRepository placeholderRepository) {
        this.sqlDialect = sqlDialect;
        this.jdbcTemplate = jdbcTemplate;
        this.ciRepository = ciRepository;
        this.placeholderRepository = placeholderRepository;
        Logging.$init$((Logging)this);
        this.PAGE_SIZE = 100;
    }
}

