/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.Aeron;
import io.aeron.AvailableCounterHandler;
import io.aeron.AvailableImageHandler;
import io.aeron.ConcurrentPublication;
import io.aeron.Counter;
import io.aeron.DriverEventsAdapter;
import io.aeron.DriverEventsListener;
import io.aeron.DriverProxy;
import io.aeron.ErrorCode;
import io.aeron.ExclusivePublication;
import io.aeron.Image;
import io.aeron.LogBuffers;
import io.aeron.LogBuffersFactory;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.UnavailableCounterHandler;
import io.aeron.UnavailableImageHandler;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.ChannelEndpointException;
import io.aeron.exceptions.ClientTimeoutException;
import io.aeron.exceptions.ConductorServiceTimeoutException;
import io.aeron.exceptions.DriverTimeoutException;
import io.aeron.exceptions.RegistrationException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.ManagedResource;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.CountersReader;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;
import org.agrona.concurrent.status.UnsafeBufferPosition;

class ClientConductor
implements Agent,
DriverEventsListener {
    private static final long NO_CORRELATION_ID = -1L;
    private final long keepAliveIntervalNs;
    private final long driverTimeoutMs;
    private final long driverTimeoutNs;
    private final long interServiceTimeoutNs;
    private long timeOfLastKeepAliveNs;
    private long timeOfLastServiceNs;
    private boolean isClosed;
    private boolean isInCallback;
    private boolean isTerminating;
    private String stashedChannel;
    private RegistrationException driverException;
    private final Aeron.Context ctx;
    private final Lock clientLock;
    private final EpochClock epochClock;
    private final NanoClock nanoClock;
    private final DriverEventsAdapter driverEventsAdapter;
    private final LogBuffersFactory logBuffersFactory;
    private final Long2ObjectHashMap<LogBuffers> logBuffersByIdMap = new Long2ObjectHashMap();
    private final Long2ObjectHashMap<Object> resourceByRegIdMap = new Long2ObjectHashMap();
    private final ArrayList<ManagedResource> lingeringResources = new ArrayList();
    private final AvailableImageHandler defaultAvailableImageHandler;
    private final UnavailableImageHandler defaultUnavailableImageHandler;
    private final AvailableCounterHandler availableCounterHandler;
    private final UnavailableCounterHandler unavailableCounterHandler;
    private final DriverProxy driverProxy;
    private final AgentInvoker driverAgentInvoker;
    private final UnsafeBuffer counterValuesBuffer;
    private final CountersReader countersReader;

    ClientConductor(Aeron.Context ctx) {
        long nowNs;
        this.ctx = ctx;
        this.clientLock = ctx.clientLock();
        this.epochClock = ctx.epochClock();
        this.nanoClock = ctx.nanoClock();
        this.driverProxy = ctx.driverProxy();
        this.logBuffersFactory = ctx.logBuffersFactory();
        this.keepAliveIntervalNs = ctx.keepAliveInterval();
        this.driverTimeoutMs = ctx.driverTimeoutMs();
        this.driverTimeoutNs = TimeUnit.MILLISECONDS.toNanos(this.driverTimeoutMs);
        this.interServiceTimeoutNs = ctx.interServiceTimeout();
        this.defaultAvailableImageHandler = ctx.availableImageHandler();
        this.defaultUnavailableImageHandler = ctx.unavailableImageHandler();
        this.availableCounterHandler = ctx.availableCounterHandler();
        this.unavailableCounterHandler = ctx.unavailableCounterHandler();
        this.driverEventsAdapter = new DriverEventsAdapter(ctx.toClientBuffer(), ctx.clientId(), this);
        this.driverAgentInvoker = ctx.driverAgentInvoker();
        this.counterValuesBuffer = ctx.countersValuesBuffer();
        this.countersReader = new CountersReader((AtomicBuffer)ctx.countersMetaDataBuffer(), (AtomicBuffer)ctx.countersValuesBuffer(), StandardCharsets.US_ASCII);
        this.timeOfLastKeepAliveNs = nowNs = this.nanoClock.nanoTime();
        this.timeOfLastServiceNs = nowNs;
    }

    public void onClose() {
        this.clientLock.lock();
        try {
            if (!this.isClosed) {
                this.isClosed = true;
                this.forceCloseResources();
                Thread.yield();
                int size = this.lingeringResources.size();
                for (int i = 0; i < size; ++i) {
                    this.lingeringResources.get(i).delete();
                }
                this.driverProxy.clientClose();
                this.ctx.close();
            }
        }
        finally {
            this.clientLock.unlock();
        }
    }

    public int doWork() {
        int workCount = 0;
        if (this.clientLock.tryLock()) {
            try {
                if (this.isTerminating) {
                    throw new AgentTerminationException();
                }
                workCount = this.service(-1L);
            }
            finally {
                this.clientLock.unlock();
            }
        }
        return workCount;
    }

    public String roleName() {
        return "aeron-client-conductor";
    }

    boolean isClosed() {
        return this.isClosed;
    }

    boolean isTerminating() {
        return this.isTerminating;
    }

    @Override
    public void onError(long correlationId, int codeValue, ErrorCode errorCode, String message) {
        this.driverException = new RegistrationException(codeValue, errorCode, message);
    }

    @Override
    public void onChannelEndpointError(int statusIndicatorId, String message) {
        Long2ObjectHashMap.ValueIterator iterator = this.resourceByRegIdMap.values().iterator();
        while (iterator.hasNext()) {
            Publication publication;
            Object resource = iterator.next();
            if (resource instanceof Subscription) {
                Subscription subscription = (Subscription)resource;
                if (subscription.channelStatusId() != statusIndicatorId) continue;
                this.handleError(new ChannelEndpointException(statusIndicatorId, message));
                subscription.internalClose();
                iterator.remove();
                continue;
            }
            if (!(resource instanceof Publication) || (publication = (Publication)resource).channelStatusId() != statusIndicatorId) continue;
            this.handleError(new ChannelEndpointException(statusIndicatorId, message));
            publication.internalClose();
            this.releaseLogBuffers(publication.logBuffers(), publication.originalRegistrationId());
            iterator.remove();
        }
    }

    @Override
    public void onNewPublication(long correlationId, long registrationId, int streamId, int sessionId, int publicationLimitId, int statusIndicatorId, String logFileName) {
        ConcurrentPublication publication = new ConcurrentPublication(this, this.stashedChannel, streamId, sessionId, (ReadablePosition)new UnsafeBufferPosition(this.counterValuesBuffer, publicationLimitId), statusIndicatorId, this.logBuffers(registrationId, logFileName), registrationId, correlationId);
        this.resourceByRegIdMap.put(correlationId, (Object)publication);
    }

    @Override
    public void onNewExclusivePublication(long correlationId, long registrationId, int streamId, int sessionId, int publicationLimitId, int statusIndicatorId, String logFileName) {
        ExclusivePublication publication = new ExclusivePublication(this, this.stashedChannel, streamId, sessionId, (ReadablePosition)new UnsafeBufferPosition(this.counterValuesBuffer, publicationLimitId), statusIndicatorId, this.logBuffers(registrationId, logFileName), registrationId, correlationId);
        this.resourceByRegIdMap.put(correlationId, (Object)publication);
    }

    @Override
    public void onNewSubscription(long correlationId, int statusIndicatorId) {
        Subscription subscription = (Subscription)this.resourceByRegIdMap.get(correlationId);
        subscription.channelStatusId(statusIndicatorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAvailableImage(long correlationId, int streamId, int sessionId, long subscriptionRegistrationId, int subscriberPositionId, String logFileName, String sourceIdentity) {
        Subscription subscription = (Subscription)this.resourceByRegIdMap.get(subscriptionRegistrationId);
        if (null != subscription) {
            Image image = new Image(subscription, sessionId, (Position)new UnsafeBufferPosition(this.counterValuesBuffer, subscriberPositionId), this.logBuffers(correlationId, logFileName), this.ctx.errorHandler(), sourceIdentity, correlationId);
            AvailableImageHandler handler = subscription.availableImageHandler();
            if (null != handler) {
                this.isInCallback = true;
                try {
                    handler.onAvailableImage(image);
                }
                catch (Throwable ex) {
                    this.handleError(ex);
                }
                finally {
                    this.isInCallback = false;
                }
            }
            subscription.addImage(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUnavailableImage(long correlationId, long subscriptionRegistrationId, int streamId) {
        UnavailableImageHandler handler;
        Image image;
        Subscription subscription = (Subscription)this.resourceByRegIdMap.get(subscriptionRegistrationId);
        if (null != subscription && null != (image = subscription.removeImage(correlationId)) && null != (handler = subscription.unavailableImageHandler())) {
            this.isInCallback = true;
            try {
                handler.onUnavailableImage(image);
            }
            catch (Throwable ex) {
                this.handleError(ex);
            }
            finally {
                this.isInCallback = false;
            }
        }
    }

    @Override
    public void onNewCounter(long correlationId, int counterId) {
        this.resourceByRegIdMap.put(correlationId, (Object)new Counter(correlationId, this, (AtomicBuffer)this.counterValuesBuffer, counterId));
        this.onAvailableCounter(correlationId, counterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAvailableCounter(long registrationId, int counterId) {
        if (null != this.availableCounterHandler) {
            this.isInCallback = true;
            try {
                this.availableCounterHandler.onAvailableCounter(this.countersReader, registrationId, counterId);
            }
            catch (Exception ex) {
                this.handleError(ex);
            }
            finally {
                this.isInCallback = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUnavailableCounter(long registrationId, int counterId) {
        if (null != this.unavailableCounterHandler) {
            this.isInCallback = true;
            try {
                this.unavailableCounterHandler.onUnavailableCounter(this.countersReader, registrationId, counterId);
            }
            catch (Exception ex) {
                this.handleError(ex);
            }
            finally {
                this.isInCallback = false;
            }
        }
    }

    @Override
    public void onClientTimeout() {
        if (!this.isClosed) {
            this.isTerminating = true;
            this.forceCloseResources();
            this.handleError(new ClientTimeoutException("client timeout from driver"));
        }
    }

    CountersReader countersReader() {
        return this.countersReader;
    }

    void handleError(Throwable ex) {
        this.ctx.errorHandler().onError(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConcurrentPublication addPublication(String channel, int streamId) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            this.stashedChannel = channel;
            long registrationId = this.driverProxy.addPublication(channel, streamId);
            this.awaitResponse(registrationId);
            ConcurrentPublication concurrentPublication = (ConcurrentPublication)this.resourceByRegIdMap.get(registrationId);
            return concurrentPublication;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExclusivePublication addExclusivePublication(String channel, int streamId) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            this.stashedChannel = channel;
            long registrationId = this.driverProxy.addExclusivePublication(channel, streamId);
            this.awaitResponse(registrationId);
            ExclusivePublication exclusivePublication = (ExclusivePublication)this.resourceByRegIdMap.get(registrationId);
            return exclusivePublication;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    void releasePublication(Publication publication) {
        this.clientLock.lock();
        try {
            if (!publication.isClosed()) {
                this.ensureActive();
                this.ensureNotReentrant();
                publication.internalClose();
                if (publication == this.resourceByRegIdMap.remove(publication.registrationId())) {
                    this.releaseLogBuffers(publication.logBuffers(), publication.originalRegistrationId());
                    this.awaitResponse(this.driverProxy.removePublication(publication.registrationId()));
                }
            }
        }
        finally {
            this.clientLock.unlock();
        }
    }

    Subscription addSubscription(String channel, int streamId) {
        return this.addSubscription(channel, streamId, this.defaultAvailableImageHandler, this.defaultUnavailableImageHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Subscription addSubscription(String channel, int streamId, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            long correlationId = this.driverProxy.addSubscription(channel, streamId);
            Subscription subscription = new Subscription(this, channel, streamId, correlationId, availableImageHandler, unavailableImageHandler);
            this.resourceByRegIdMap.put(correlationId, (Object)subscription);
            this.awaitResponse(correlationId);
            Subscription subscription2 = subscription;
            return subscription2;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseSubscription(Subscription subscription) {
        this.clientLock.lock();
        try {
            if (!subscription.isClosed()) {
                this.ensureActive();
                this.ensureNotReentrant();
                subscription.internalClose();
                long registrationId = subscription.registrationId();
                this.resourceByRegIdMap.remove(registrationId);
                this.awaitResponse(this.driverProxy.removeSubscription(registrationId));
            }
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDestination(long registrationId, String endpointChannel) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            this.awaitResponse(this.driverProxy.addDestination(registrationId, endpointChannel));
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDestination(long registrationId, String endpointChannel) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            this.awaitResponse(this.driverProxy.removeDestination(registrationId, endpointChannel));
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRcvDestination(long registrationId, String endpointChannel) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            this.awaitResponse(this.driverProxy.addRcvDestination(registrationId, endpointChannel));
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRcvDestination(long registrationId, String endpointChannel) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            this.awaitResponse(this.driverProxy.removeRcvDestination(registrationId, endpointChannel));
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Counter addCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            if (keyLength < 0 || keyLength > 112) {
                throw new IllegalArgumentException("key length out of bounds: " + keyLength);
            }
            if (labelLength < 0 || labelLength > 380) {
                throw new IllegalArgumentException("label length out of bounds: " + labelLength);
            }
            long registrationId = this.driverProxy.addCounter(typeId, keyBuffer, keyOffset, keyLength, labelBuffer, labelOffset, labelLength);
            this.awaitResponse(registrationId);
            Counter counter = (Counter)((Object)this.resourceByRegIdMap.get(registrationId));
            return counter;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Counter addCounter(int typeId, String label) {
        this.clientLock.lock();
        try {
            this.ensureActive();
            this.ensureNotReentrant();
            if (label.length() > 380) {
                throw new IllegalArgumentException("label length exceeds MAX_LABEL_LENGTH: " + label.length());
            }
            long registrationId = this.driverProxy.addCounter(typeId, label);
            this.awaitResponse(registrationId);
            Counter counter = (Counter)((Object)this.resourceByRegIdMap.get(registrationId));
            return counter;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseCounter(Counter counter) {
        this.clientLock.lock();
        try {
            if (!counter.isClosed()) {
                this.ensureActive();
                this.ensureNotReentrant();
                counter.internalClose();
                long registrationId = counter.registrationId();
                if (null != this.resourceByRegIdMap.remove(registrationId)) {
                    this.awaitResponse(this.driverProxy.removeCounter(registrationId));
                }
            }
        }
        finally {
            this.clientLock.unlock();
        }
    }

    void releaseLogBuffers(LogBuffers logBuffers, long registrationId) {
        if (logBuffers.decRef() == 0) {
            logBuffers.timeOfLastStateChange(this.nanoClock.nanoTime());
            this.logBuffersByIdMap.remove(registrationId);
            this.lingeringResources.add(logBuffers);
        }
    }

    DriverEventsAdapter driverListenerAdapter() {
        return this.driverEventsAdapter;
    }

    long channelStatus(int channelStatusId) {
        switch (channelStatusId) {
            case 0: {
                return 0L;
            }
            case -1: {
                return 1L;
            }
        }
        return this.countersReader.getCounterValue(channelStatusId);
    }

    private void ensureActive() {
        if (this.isClosed || this.isTerminating) {
            throw new AeronException("Aeron client is closed or terminating");
        }
    }

    private void ensureNotReentrant() {
        if (this.isInCallback) {
            throw new AeronException("reentrant calls not permitted during callbacks");
        }
    }

    private LogBuffers logBuffers(long registrationId, String logFileName) {
        LogBuffers logBuffers = (LogBuffers)this.logBuffersByIdMap.get(registrationId);
        if (null == logBuffers) {
            logBuffers = this.logBuffersFactory.map(logFileName);
            this.logBuffersByIdMap.put(registrationId, (Object)logBuffers);
        }
        logBuffers.incRef();
        return logBuffers;
    }

    private int service(long correlationId) {
        int workCount;
        block3: {
            workCount = 0;
            try {
                workCount += this.onCheckTimeouts();
                workCount += this.driverEventsAdapter.receive(correlationId);
            }
            catch (Throwable throwable) {
                this.handleError(throwable);
                if (this.driverEventsAdapter.isInvalid()) {
                    this.onClose();
                }
                if (!ClientConductor.isClientApiCall(correlationId)) break block3;
                throw throwable;
            }
        }
        return workCount;
    }

    private static boolean isClientApiCall(long correlationId) {
        return correlationId != -1L;
    }

    private void awaitResponse(long correlationId) {
        this.driverException = null;
        long deadlineNs = this.nanoClock.nanoTime() + this.driverTimeoutNs;
        do {
            if (null == this.driverAgentInvoker) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ex) {
                    this.isTerminating = true;
                    LangUtil.rethrowUnchecked((Throwable)ex);
                }
            } else {
                this.driverAgentInvoker.invoke();
            }
            this.service(correlationId);
            if (this.driverEventsAdapter.receivedCorrelationId() == correlationId) {
                if (null != this.driverException) {
                    throw this.driverException;
                }
                return;
            }
            if (!Thread.interrupted()) continue;
            this.isTerminating = true;
            LangUtil.rethrowUnchecked((Throwable)new InterruptedException());
        } while (deadlineNs - this.nanoClock.nanoTime() > 0L);
        throw new DriverTimeoutException("no response from MediaDriver within (ns): " + this.driverTimeoutNs);
    }

    private int onCheckTimeouts() {
        int workCount = 0;
        long nowNs = this.nanoClock.nanoTime();
        if (this.timeOfLastServiceNs + Aeron.Configuration.IDLE_SLEEP_NS - nowNs < 0L) {
            this.checkServiceInterval(nowNs);
            this.timeOfLastServiceNs = nowNs;
            workCount += this.checkLiveness(nowNs);
            workCount += this.checkLingeringResources(nowNs);
        }
        return workCount;
    }

    private void checkServiceInterval(long nowNs) {
        if (this.timeOfLastServiceNs + this.interServiceTimeoutNs - nowNs < 0L) {
            this.isTerminating = true;
            this.forceCloseResources();
            Thread.yield();
            throw new ConductorServiceTimeoutException("service interval exceeded (ns): " + this.interServiceTimeoutNs);
        }
    }

    private int checkLiveness(long nowNs) {
        if (this.timeOfLastKeepAliveNs + this.keepAliveIntervalNs - nowNs < 0L) {
            if (this.epochClock.time() > this.driverProxy.timeOfLastDriverKeepaliveMs() + this.driverTimeoutMs) {
                this.isTerminating = true;
                this.forceCloseResources();
                Thread.yield();
                throw new DriverTimeoutException("MediaDriver keepalive older than (ms): " + this.driverTimeoutMs);
            }
            this.driverProxy.sendClientKeepalive();
            this.timeOfLastKeepAliveNs = nowNs;
            return 1;
        }
        return 0;
    }

    private int checkLingeringResources(long nowNs) {
        int lastIndex;
        int workCount = 0;
        ArrayList<ManagedResource> lingeringResources = this.lingeringResources;
        for (int i = lastIndex = lingeringResources.size() - 1; i >= 0; --i) {
            ManagedResource resource = lingeringResources.get(i);
            if (resource.timeOfLastStateChange() + this.ctx.resourceLingerDurationNs() - nowNs >= 0L) continue;
            ArrayListUtil.fastUnorderedRemove(lingeringResources, (int)i, (int)lastIndex--);
            resource.delete();
            ++workCount;
        }
        return workCount;
    }

    private void forceCloseResources() {
        for (Object resource : this.resourceByRegIdMap.values()) {
            if (resource instanceof Subscription) {
                Subscription subscription = (Subscription)resource;
                subscription.internalClose();
                continue;
            }
            if (resource instanceof Publication) {
                Publication publication = (Publication)resource;
                publication.internalClose();
                this.releaseLogBuffers(publication.logBuffers(), publication.originalRegistrationId());
                continue;
            }
            if (!(resource instanceof Counter)) continue;
            Counter counter = (Counter)((Object)resource);
            counter.internalClose();
        }
        this.resourceByRegIdMap.clear();
    }
}

