/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.metrics.prometheus;

import com.zaxxer.hikari.metrics.IMetricsTracker;
import com.zaxxer.hikari.metrics.MetricsTrackerFactory;
import com.zaxxer.hikari.metrics.PoolStats;
import com.zaxxer.hikari.metrics.prometheus.HikariCPCollector;
import com.zaxxer.hikari.metrics.prometheus.PrometheusMetricsTracker;
import io.prometheus.client.CollectorRegistry;

public class PrometheusMetricsTrackerFactory
implements MetricsTrackerFactory {
    private HikariCPCollector collector;
    private CollectorRegistry collectorRegistry;

    public PrometheusMetricsTrackerFactory() {
        this.collectorRegistry = CollectorRegistry.defaultRegistry;
    }

    public PrometheusMetricsTrackerFactory(CollectorRegistry collectorRegistry) {
        this.collectorRegistry = collectorRegistry;
    }

    @Override
    public IMetricsTracker create(String poolName, PoolStats poolStats) {
        this.getCollector().add(poolName, poolStats);
        return new PrometheusMetricsTracker(poolName, this.collectorRegistry);
    }

    private HikariCPCollector getCollector() {
        if (this.collector == null) {
            this.collector = (HikariCPCollector)new HikariCPCollector().register(this.collectorRegistry);
        }
        return this.collector;
    }
}

