/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.BigIntegerDataType;
import org.dbunit.dataset.datatype.BitDataType;
import org.dbunit.dataset.datatype.BlobDataType;
import org.dbunit.dataset.datatype.BooleanDataType;
import org.dbunit.dataset.datatype.ClobDataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.DateDataType;
import org.dbunit.dataset.datatype.DoubleDataType;
import org.dbunit.dataset.datatype.FloatDataType;
import org.dbunit.dataset.datatype.IntegerDataType;
import org.dbunit.dataset.datatype.LongDataType;
import org.dbunit.dataset.datatype.NumberDataType;
import org.dbunit.dataset.datatype.StringDataType;
import org.dbunit.dataset.datatype.TimeDataType;
import org.dbunit.dataset.datatype.TimestampDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.dbunit.dataset.datatype.UnknownDataType;
import org.dbunit.dataset.datatype.UuidAwareBytesDataType;
import org.dbunit.util.RelativeDateTimeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataType {
    private static final Logger logger = LoggerFactory.getLogger(DataType.class);
    public static final DataType UNKNOWN = new UnknownDataType();
    public static final DataType CHAR = new StringDataType("CHAR", 1);
    public static final DataType VARCHAR = new StringDataType("VARCHAR", 12);
    public static final DataType LONGVARCHAR = new StringDataType("LONGVARCHAR", -1);
    public static final DataType CLOB = new ClobDataType();
    public static final DataType NUMERIC = new NumberDataType("NUMERIC", 2);
    public static final DataType DECIMAL = new NumberDataType("DECIMAL", 3);
    public static final DataType BOOLEAN = new BooleanDataType();
    public static final DataType BIT = new BitDataType();
    public static final DataType TINYINT = new IntegerDataType("TINYINT", -6);
    public static final DataType SMALLINT = new IntegerDataType("SMALLINT", 5);
    public static final DataType INTEGER = new IntegerDataType("INTEGER", 4);
    public static final DataType BIGINT = new BigIntegerDataType();
    public static final DataType BIGINT_AUX_LONG = new LongDataType();
    public static final DataType REAL = new FloatDataType();
    public static final DataType FLOAT = new DoubleDataType("FLOAT", 6);
    public static final DataType DOUBLE = new DoubleDataType("DOUBLE", 8);
    public static final RelativeDateTimeParser RELATIVE_DATE_TIME_PARSER = new RelativeDateTimeParser();
    public static final DataType DATE = new DateDataType();
    public static final DataType TIME = new TimeDataType();
    public static final DataType TIMESTAMP = new TimestampDataType();
    public static final DataType BINARY = new UuidAwareBytesDataType("BINARY", -2);
    public static final DataType VARBINARY = new UuidAwareBytesDataType("VARBINARY", -3);
    public static final DataType LONGVARBINARY = new UuidAwareBytesDataType("LONGVARBINARY", -4);
    public static final DataType BLOB = new BlobDataType();
    public static final DataType NCHAR = new StringDataType("NCHAR", -15);
    public static final DataType NVARCHAR = new StringDataType("NVARCHAR", -9);
    public static final DataType LONGNVARCHAR = new StringDataType("LONGNVARCHAR", -16);
    private static final DataType[] TYPES = new DataType[]{VARCHAR, CHAR, LONGVARCHAR, NCHAR, NVARCHAR, LONGNVARCHAR, CLOB, NUMERIC, DECIMAL, BOOLEAN, BIT, INTEGER, TINYINT, SMALLINT, BIGINT, REAL, DOUBLE, FLOAT, DATE, TIME, TIMESTAMP, VARBINARY, BINARY, LONGVARBINARY, BLOB, BIGINT_AUX_LONG};

    public abstract Object typeCast(Object var1) throws TypeCastException;

    public abstract int compare(Object var1, Object var2) throws TypeCastException;

    public abstract int getSqlType();

    public abstract Class getTypeClass();

    public String getSqlTypeName() {
        return null;
    }

    public abstract boolean isNumber();

    public abstract boolean isDateTime();

    public abstract Object getSqlValue(int var1, ResultSet var2) throws SQLException, TypeCastException;

    public abstract void setSqlValue(Object var1, int var2, PreparedStatement var3) throws SQLException, TypeCastException;

    public static String asString(Object value) throws TypeCastException {
        logger.debug("asString(value={}) - start", value);
        return (String)VARCHAR.typeCast(value);
    }

    public static DataType forSqlType(int sqlType) throws DataTypeException {
        if (logger.isDebugEnabled()) {
            logger.debug("forSqlType(sqlType={}) - start", (Object)new Integer(sqlType));
        }
        int i = 0;
        while (i < TYPES.length) {
            if (sqlType == TYPES[i].getSqlType()) {
                return TYPES[i];
            }
            ++i;
        }
        return UNKNOWN;
    }

    public static DataType forSqlTypeName(String sqlTypeName) throws DataTypeException {
        if (logger.isDebugEnabled()) {
            logger.debug("forSqlTypeName(sqlTypeName=" + sqlTypeName + ") - start");
        }
        int i = 0;
        while (i < TYPES.length) {
            if (sqlTypeName.equals(TYPES[i].toString())) {
                return TYPES[i];
            }
            ++i;
        }
        return UNKNOWN;
    }

    public static DataType forObject(Object value) {
        logger.debug("forObject(value={}) - start", value);
        if (value == null) {
            return UNKNOWN;
        }
        int i = 0;
        while (i < TYPES.length) {
            Class typeClass = TYPES[i].getTypeClass();
            if (typeClass.isInstance(value)) {
                return TYPES[i];
            }
            ++i;
        }
        return UNKNOWN;
    }

    protected static boolean isExtendedSyntax(String input) {
        return !input.isEmpty() && input.charAt(0) == '[';
    }
}

