/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.PrintWriter;
import java.io.Writer;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlatDtdWriter {
    private static final Logger logger = LoggerFactory.getLogger(FlatDtdWriter.class);
    public static final ContentModel SEQUENCE = new SequenceModel();
    public static final ContentModel CHOICE = new ChoiceModel();
    private Writer _writer;
    private ContentModel _contentModel;

    public FlatDtdWriter(Writer writer) {
        this._writer = writer;
        this._contentModel = SEQUENCE;
    }

    public void setContentModel(ContentModel contentModel) {
        logger.debug("setContentModel(contentModel={}) - start", (Object)contentModel);
        this._contentModel = contentModel;
    }

    public void write(IDataSet dataSet) throws DataSetException {
        logger.debug("write(dataSet={}) - start", (Object)dataSet);
        PrintWriter printOut = new PrintWriter(this._writer);
        String[] tableNames = dataSet.getTableNames();
        printOut.print("<!ELEMENT dataset (\n");
        int i = 0;
        while (i < tableNames.length) {
            this._contentModel.write(printOut, tableNames[i], i, tableNames.length);
            ++i;
        }
        printOut.print(")>\n");
        printOut.print("\n");
        i = 0;
        while (i < tableNames.length) {
            String tableName = tableNames[i];
            printOut.print("<!ELEMENT ");
            printOut.print(tableName);
            printOut.print(" EMPTY>\n");
            printOut.print("<!ATTLIST ");
            printOut.print(tableName);
            printOut.print("\n");
            Column[] columns = dataSet.getTableMetaData(tableName).getColumns();
            int j = 0;
            while (j < columns.length) {
                Column column = columns[j];
                printOut.print("    ");
                printOut.print(column.getColumnName());
                if (column.getNullable() == Column.NO_NULLS && column.getDefaultValue() == null) {
                    printOut.print(" CDATA #REQUIRED\n");
                } else {
                    printOut.print(" CDATA #IMPLIED\n");
                }
                ++j;
            }
            printOut.print(">\n");
            printOut.print("\n");
            ++i;
        }
        printOut.flush();
    }

    public static class ChoiceModel
    extends ContentModel {
        private static final Logger logger = LoggerFactory.getLogger(ChoiceModel.class);

        private ChoiceModel() {
            super("sequence");
        }

        @Override
        public void write(PrintWriter writer, String tableName, int tableIndex, int tableCount) {
            boolean last;
            if (logger.isDebugEnabled()) {
                logger.debug("write(writer={}, tableName={}, tableIndex={}, tableCount={}) - start", new Object[]{writer, tableName, String.valueOf(tableIndex), String.valueOf(tableCount)});
            }
            boolean first = tableIndex == 0;
            boolean bl = last = tableIndex + 1 == tableCount;
            if (first) {
                writer.print("   (");
            } else {
                writer.print("    ");
            }
            writer.print(tableName);
            if (!last) {
                writer.print("|\n");
            } else {
                writer.print(")*");
            }
        }
    }

    public static abstract class ContentModel {
        private final String _name;

        private ContentModel(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }

        public abstract void write(PrintWriter var1, String var2, int var3, int var4);
    }

    public static class SequenceModel
    extends ContentModel {
        private static final Logger logger = LoggerFactory.getLogger(SequenceModel.class);

        private SequenceModel() {
            super("sequence");
        }

        @Override
        public void write(PrintWriter writer, String tableName, int tableIndex, int tableCount) {
            if (logger.isDebugEnabled()) {
                logger.debug("write(writer={}, tableName={}, tableIndex={}, tableCount={}) - start", new Object[]{writer, tableName, String.valueOf(tableIndex), String.valueOf(tableCount)});
            }
            boolean last = tableIndex + 1 == tableCount;
            writer.print("    ");
            writer.print(tableName);
            writer.print("*");
            if (!last) {
                writer.print(",\n");
            }
        }
    }
}

