/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;
import org.dbunit.dataset.OrderedTableNameMap;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.stream.BufferedConsumer;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.dbunit.dataset.xml.FlatDtdProducer;
import org.dbunit.dataset.xml.XmlProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FlatXmlProducer
extends DefaultHandler
implements IDataSetProducer,
ContentHandler {
    private static final Logger logger = LoggerFactory.getLogger(FlatXmlProducer.class);
    private static final IDataSetConsumer EMPTY_CONSUMER = new DefaultConsumer();
    private static final String DATASET = "dataset";
    private final InputSource _inputSource;
    private final EntityResolver _resolver;
    private boolean _validating = false;
    private IDataSet _metaDataSet;
    private FlatDtdHandler _dtdHandler;
    private int _lineNumber = 0;
    private int _lineNumberGlobal = 0;
    private boolean _columnSensing = false;
    private boolean _caseSensitiveTableNames;
    private IDataSetConsumer _consumer = EMPTY_CONSUMER;
    private OrderedTableNameMap _orderedTableNameMap;

    public FlatXmlProducer(InputSource xmlSource) {
        this(xmlSource, true);
    }

    public FlatXmlProducer(InputSource xmlSource, boolean dtdMetadata) {
        this(xmlSource, dtdMetadata, false);
    }

    public FlatXmlProducer(InputSource xmlSource, IDataSet metaDataSet) {
        this._inputSource = xmlSource;
        this._metaDataSet = metaDataSet;
        this._resolver = this;
        this._caseSensitiveTableNames = metaDataSet.isCaseSensitiveTableNames();
        this.initialize(false);
    }

    public FlatXmlProducer(InputSource xmlSource, EntityResolver resolver) {
        this._inputSource = xmlSource;
        this._resolver = resolver;
        this.initialize(true);
    }

    public FlatXmlProducer(InputSource xmlSource, boolean dtdMetadata, boolean columnSensing) {
        this(xmlSource, dtdMetadata, columnSensing, false);
    }

    public FlatXmlProducer(InputSource xmlSource, boolean dtdMetadata, boolean columnSensing, boolean caseSensitiveTableNames) {
        this._inputSource = xmlSource;
        this._columnSensing = columnSensing;
        this._caseSensitiveTableNames = caseSensitiveTableNames;
        this._resolver = this;
        this.initialize(dtdMetadata);
    }

    private void initialize(boolean dtdMetadata) {
        if (dtdMetadata) {
            this._dtdHandler = new FlatDtdHandler(this);
        }
    }

    public boolean isCaseSensitiveTableNames() {
        return this._caseSensitiveTableNames;
    }

    private ITableMetaData createTableMetaData(String tableName, Attributes attributes) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("createTableMetaData(tableName={}, attributes={}) - start", (Object)tableName, (Object)attributes);
        }
        if (this._metaDataSet != null) {
            return this._metaDataSet.getTableMetaData(tableName);
        }
        Column[] columns = new Column[attributes.getLength()];
        int i = 0;
        while (i < attributes.getLength()) {
            columns[i] = new Column(attributes.getQName(i), DataType.UNKNOWN);
            ++i;
        }
        return new DefaultTableMetaData(tableName, columns);
    }

    private ITableMetaData mergeTableMetaData(List columnsToMerge, ITableMetaData originalMetaData) throws DataSetException {
        Column[] columns = new Column[originalMetaData.getColumns().length + columnsToMerge.size()];
        System.arraycopy(originalMetaData.getColumns(), 0, columns, 0, originalMetaData.getColumns().length);
        int i = 0;
        while (i < columnsToMerge.size()) {
            Column column;
            columns[columns.length - columnsToMerge.size() + i] = column = (Column)columnsToMerge.get(i);
            ++i;
        }
        return new DefaultTableMetaData(originalMetaData.getTableName(), columns);
    }

    private ITableMetaData getActiveMetaData() {
        if (this._orderedTableNameMap != null) {
            String lastTableName = this._orderedTableNameMap.getLastTableName();
            if (lastTableName != null) {
                return (ITableMetaData)this._orderedTableNameMap.get(lastTableName);
            }
            return null;
        }
        return null;
    }

    private boolean isNewTable(String tableName) {
        return !this._orderedTableNameMap.isLastTable(tableName);
    }

    protected void handleMissingColumns(Attributes attributes) throws DataSetException {
        ArrayList<Column> columnsToMerge = new ArrayList<Column>();
        ITableMetaData activeMetaData = this.getActiveMetaData();
        int attributeLength = attributes.getLength();
        int i = 0;
        while (i < attributeLength) {
            try {
                activeMetaData.getColumnIndex(attributes.getQName(i));
            }
            catch (NoSuchColumnException e) {
                columnsToMerge.add(new Column(attributes.getQName(i), DataType.UNKNOWN));
            }
            ++i;
        }
        if (!columnsToMerge.isEmpty()) {
            if (this._columnSensing) {
                logger.debug("Column sensing enabled. Will create a new metaData with potentially new columns if needed");
                activeMetaData = this.mergeTableMetaData(columnsToMerge, activeMetaData);
                this._orderedTableNameMap.update(activeMetaData.getTableName(), activeMetaData);
                this._consumer.startTable(activeMetaData);
            } else {
                StringBuffer extraColumnNames = new StringBuffer();
                for (Column col : columnsToMerge) {
                    extraColumnNames.append(extraColumnNames.length() > 0 ? "," : "").append(col.getColumnName());
                }
                String msg = "Extra columns (" + extraColumnNames.toString() + ") on line " + (this._lineNumber + 1) + " for table " + activeMetaData.getTableName() + " (global line number is " + this._lineNumberGlobal + "). Those columns will be ignored.";
                msg = String.valueOf(msg) + "\n\tPlease add the extra columns to line 1, or use a DTD to make sure the value of those columns are populated or specify 'columnSensing=true' for your FlatXmlProducer.";
                msg = String.valueOf(msg) + "\n\tSee FAQ for more details.";
                logger.warn(msg);
            }
        }
    }

    public void setColumnSensing(boolean columnSensing) {
        this._columnSensing = columnSensing;
    }

    public void setValidating(boolean validating) {
        this._validating = validating;
    }

    @Override
    public void setConsumer(IDataSetConsumer consumer) throws DataSetException {
        logger.debug("setConsumer(consumer) - start");
        this._consumer = this._columnSensing ? new BufferedConsumer(consumer) : consumer;
    }

    @Override
    public void produce() throws DataSetException {
        logger.debug("produce() - start");
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(this._validating);
            XMLReader xmlReader = saxParserFactory.newSAXParser().getXMLReader();
            if (this._dtdHandler != null) {
                FlatDtdHandler.setLexicalHandler(xmlReader, this._dtdHandler);
                FlatDtdHandler.setDeclHandler(xmlReader, this._dtdHandler);
            }
            xmlReader.setContentHandler(this);
            xmlReader.setErrorHandler(this);
            xmlReader.setEntityResolver(this._resolver);
            xmlReader.parse(this._inputSource);
        }
        catch (ParserConfigurationException e) {
            throw new DataSetException(e);
        }
        catch (SAXException e) {
            DataSetException exceptionToRethrow = XmlProducer.buildException(e);
            throw exceptionToRethrow;
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        logger.debug("resolveEntity(publicId={}, systemId={}) - start", (Object)publicId, (Object)systemId);
        if (this._dtdHandler == null || !this._dtdHandler.isDtdPresent()) {
            return new InputSource(new StringReader(""));
        }
        return null;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (logger.isDebugEnabled()) {
            logger.debug("startElement(uri={}, localName={}, qName={}, attributes={}) - start", new Object[]{uri, localName, qName, attributes});
        }
        try {
            int attributesLength;
            ITableMetaData activeMetaData = this.getActiveMetaData();
            if (activeMetaData == null && qName.equals(DATASET)) {
                this._consumer.startDataSet();
                this._orderedTableNameMap = new OrderedTableNameMap(this._caseSensitiveTableNames);
                return;
            }
            if (this.isNewTable(qName)) {
                if (activeMetaData != null) {
                    this._consumer.endTable();
                }
                if (this._orderedTableNameMap.containsTable(qName)) {
                    activeMetaData = (ITableMetaData)this._orderedTableNameMap.get(qName);
                    this._orderedTableNameMap.setLastTable(qName);
                } else {
                    activeMetaData = this.createTableMetaData(qName, attributes);
                    this._orderedTableNameMap.add(activeMetaData.getTableName(), activeMetaData);
                }
                this._consumer.startTable(activeMetaData);
                this._lineNumber = 0;
            }
            if ((attributesLength = attributes.getLength()) > 0) {
                if (this._dtdHandler == null || !this._dtdHandler.isDtdPresent()) {
                    this.handleMissingColumns(attributes);
                    activeMetaData = this.getActiveMetaData();
                }
                ++this._lineNumber;
                ++this._lineNumberGlobal;
                Column[] columns = activeMetaData.getColumns();
                Object[] rowValues = new Object[columns.length];
                int i = 0;
                while (i < attributesLength) {
                    this.determineAndSetRowValue(attributes, activeMetaData, rowValues, i);
                    ++i;
                }
                this._consumer.row(rowValues);
            }
        }
        catch (DataSetException e) {
            throw new SAXException(e);
        }
    }

    protected void determineAndSetRowValue(Attributes attributes, ITableMetaData activeMetaData, Object[] rowValues, int i) throws DataSetException, NoSuchColumnException {
        block2: {
            String attributeQName = attributes.getQName(i);
            String attributeValue = attributes.getValue(i);
            try {
                int colIndex = activeMetaData.getColumnIndex(attributeQName);
                rowValues[colIndex] = attributeValue;
            }
            catch (NoSuchColumnException e) {
                if (!this._columnSensing) break block2;
                throw e;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (logger.isDebugEnabled()) {
            logger.debug("endElement(uri={}, localName={}, qName={}) - start", new Object[]{uri, localName, qName});
        }
        if (qName.equals(DATASET)) {
            try {
                if (this.getActiveMetaData() != null) {
                    this._consumer.endTable();
                }
                this._consumer.endDataSet();
            }
            catch (DataSetException e) {
                throw new SAXException(e);
            }
        }
    }

    private static class FlatDtdHandler
    extends FlatDtdProducer {
        private final Logger logger = LoggerFactory.getLogger(FlatDtdHandler.class);
        private boolean _dtdPresent = false;
        private FlatXmlProducer xmlProducer;

        public FlatDtdHandler(FlatXmlProducer xmlProducer) {
            this.xmlProducer = xmlProducer;
        }

        public boolean isDtdPresent() {
            return this._dtdPresent;
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("startDTD(name={}, publicId={}, systemId={}) - start", new Object[]{name, publicId, systemId});
            }
            this._dtdPresent = true;
            try {
                FlatDtdDataSet metaDataSet = new FlatDtdDataSet();
                this.setConsumer(metaDataSet);
                this.xmlProducer._metaDataSet = metaDataSet;
                super.startDTD(name, publicId, systemId);
            }
            catch (DataSetException e) {
                throw new SAXException(e);
            }
        }
    }
}

