/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RelativeDateTimeParser {
    private static final Pattern inputPattern = Pattern.compile("^\\[[nN][oO][wW]\\s*(([-+][0-9]+[yMdhms]\\s*)*)([0-9:]*)?\\]$");
    private static final int GROUP_DIFFS = 1;
    private static final int GROUP_TIME = 3;
    private static final Pattern diffPattern = Pattern.compile("([+-][0-9]+[yMdhms])");
    private Clock clock;
    private LocalDateTime now;

    public RelativeDateTimeParser() {
        this(Clock.fixed(Instant.now(), ZoneId.systemDefault()));
    }

    public RelativeDateTimeParser(Clock clock) {
        this.clock = clock;
        this.cacheLocalDateTime(clock);
    }

    public LocalDateTime parse(String input) {
        if (input == null || input.isEmpty()) {
            throw new IllegalArgumentException("Relative datetime input must not be null or empty.");
        }
        Matcher matcher = inputPattern.matcher(input);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("'" + input + "' does not match the expected pattern [now{diff}{time}]. " + "Please see the data types documentation for the details. " + "http://dbunit.sourceforge.net/datatypes.html#relativedatetime");
        }
        LocalDateTime datetime = this.initLocalDateTime(matcher);
        String diffStr = matcher.group(1);
        if (diffStr.isEmpty()) {
            return datetime;
        }
        Matcher diffMatcher = diffPattern.matcher(diffStr);
        while (diffMatcher.find()) {
            String diff = diffMatcher.group();
            int amountLength = diff.length() - 1;
            TemporalUnit unit = RelativeDateTimeParser.resolveUnit(diff.charAt(amountLength));
            long amount = Long.parseLong(diff.substring(0, amountLength));
            datetime = datetime.plus(amount, unit);
        }
        return datetime;
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
        this.cacheLocalDateTime(clock);
    }

    private LocalDateTime initLocalDateTime(Matcher matcher) {
        String timeStr = matcher.group(3);
        if (timeStr.isEmpty()) {
            return this.now;
        }
        LocalTime time = LocalTime.parse(timeStr);
        return LocalDateTime.of(this.now.toLocalDate(), time);
    }

    private static TemporalUnit resolveUnit(char c) {
        switch (c) {
            case 'y': {
                return ChronoUnit.YEARS;
            }
            case 'M': {
                return ChronoUnit.MONTHS;
            }
            case 'd': {
                return ChronoUnit.DAYS;
            }
            case 'h': {
                return ChronoUnit.HOURS;
            }
            case 'm': {
                return ChronoUnit.MINUTES;
            }
            case 's': {
                return ChronoUnit.SECONDS;
            }
        }
        throw new IllegalArgumentException("'" + c + "' is not a valid unit. It has to be one of 'yMdhms'.");
    }

    private void cacheLocalDateTime(Clock clock) {
        this.now = LocalDateTime.now(clock);
    }
}

