/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.HostService;
import com.xebialabs.deployit.core.rest.api.RepositoryResource;
import com.xebialabs.deployit.core.service.PaginationService;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.DeploymentInfo;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.DeployedApplicationsRepository;
import com.xebialabs.deployit.repository.EnvironmentRepository;
import java.util.List;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001\u0002\u0007\u000e\u0001iA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u001d)\u0006A1A\u0005\u0002YCa!\u0019\u0001!\u0002\u00139\u0006\"\u00028\u0001\t\u0013y\u0007bBA\t\u0001\u0011\u0005\u00131\u0003\u0005\b\u0003\u001b\u0002A\u0011IA(\u0011\u001d\ti\u0006\u0001C!\u0003?\u0012q\u0002S8tiN+'O^5dK&k\u0007\u000f\u001c\u0006\u0003\u001d=\t1!\u00199j\u0015\t\u0001\u0012#\u0001\u0003sKN$(B\u0001\n\u0014\u0003\u0011\u0019wN]3\u000b\u0005Q)\u0012\u0001\u00033fa2|\u00170\u001b;\u000b\u0005Y9\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005A\u0012aA2p[\u000e\u00011c\u0001\u0001\u001cGA\u0011A$I\u0007\u0002;)\u0011adH\u0001\u0005Y\u0006twMC\u0001!\u0003\u0011Q\u0017M^1\n\u0005\tj\"AB(cU\u0016\u001cG\u000f\u0005\u0002%M5\tQE\u0003\u0002\u000f#%\u0011q%\n\u0002\f\u0011>\u001cHoU3sm&\u001cW-A\u000bf]ZL'o\u001c8nK:$(+\u001a9pg&$xN]=\u0011\u0005)jS\"A\u0016\u000b\u00051\u001a\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011af\u000b\u0002\u0016\u000b:4\u0018N]8o[\u0016tGOU3q_NLGo\u001c:z\u0003y!W\r\u001d7ps\u0016$\u0017\t\u001d9mS\u000e\fG/[8ogJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002+c%\u0011!g\u000b\u0002\u001f\t\u0016\u0004Hn\\=fI\u0006\u0003\b\u000f\\5dCRLwN\\:SKB|7/\u001b;pef\f\u0011\u0003]1hS:\fG/[8o'\u0016\u0014h/[2f!\t)\u0004(D\u00017\u0015\t9\u0014#A\u0004tKJ4\u0018nY3\n\u0005e2$!\u0005)bO&t\u0017\r^5p]N+'O^5dK\u0006\u0011\"/\u001a9pg&$xN]=SKN|WO]2f!\taT(D\u0001\u000e\u0013\tqTB\u0001\nSKB|7/\u001b;pef\u0014Vm]8ve\u000e,\u0017A\u0002\u001fj]&$h\bF\u0003B\u0005\u000e#U\t\u0005\u0002=\u0001!)\u0001&\u0002a\u0001S!)q&\u0002a\u0001a!)1'\u0002a\u0001i!)!(\u0002a\u0001w!\u0012Qa\u0012\t\u0003\u0011Nk\u0011!\u0013\u0006\u0003\u0015.\u000b!\"\u00198o_R\fG/[8o\u0015\taU*A\u0004gC\u000e$xN]=\u000b\u00059{\u0015!\u00022fC:\u001c(B\u0001)R\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001*\u0002\u0007=\u0014x-\u0003\u0002U\u0013\nI\u0011)\u001e;po&\u0014X\rZ\u0001\te\u0016\u001c\bo\u001c8tKV\tq\u000b\u0005\u0002Y?6\t\u0011L\u0003\u0002[7\u0006\u00191\u000f]5\u000b\u0005qk\u0016\u0001\u0003:fgR,\u0017m]=\u000b\u0005y\u000b\u0016!\u00026c_N\u001c\u0018B\u00011Z\u00051AE\u000f\u001e9SKN\u0004xN\\:f\u0003%\u0011Xm\u001d9p]N,\u0007\u0005\u000b\u0002\bGB\u0011A\r\\\u0007\u0002K*\u0011!C\u001a\u0006\u0003O\"\f!A]:\u000b\u0005%T\u0017AA<t\u0015\u0005Y\u0017!\u00026bm\u0006D\u0018BA7f\u0005\u001d\u0019uN\u001c;fqR\f\u0011d\u00195fG.Le-V:fe\"\u000b7\u000fU3s[&\u001c8/[8ogR\u0011\u0001/\u001f\t\u0003c^l\u0011A\u001d\u0006\u0003gR\f1!\u001e3n\u0015\tqQO\u0003\u0002w'\u00051\u0001\u000f\\;hS:L!\u0001\u001f:\u0003#\r{gNZ5hkJ\fG/[8o\u0013R,W\u000eC\u0003{\u0011\u0001\u000710\u0001\u0004i_N$\u0018\n\u001a\t\u0004y\u0006-abA?\u0002\bA\u0019a0a\u0001\u000e\u0003}T1!!\u0001\u001a\u0003\u0019a$o\\8u})\u0011\u0011QA\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003\u0013\t\u0019!\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\tyA\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003\u0013\t\u0019!\u0001\rgS:$G)\u001a9m_f,G-\u00119qY&\u001c\u0017\r^5p]N$\"\"!\u0006\u00024\u0005U\u0012\u0011HA\"!\u0019\t9\"!\b\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0004\u00037y\u0012\u0001B;uS2LA!a\b\u0002\u001a\t!A*[:u!\u0011\t\u0019#a\f\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\t1\u0001\u001a;p\u0015\rq\u00111\u0006\u0006\u0004\u0003[\u0019\u0012AB3oO&tW-\u0003\u0003\u00022\u0005\u0015\"aE\"p]\u001aLw-\u001e:bi&|g.\u0013;f[&#\u0007\"\u0002>\n\u0001\u0004Y\bBBA\u001c\u0013\u0001\u000710A\beKBdw._3e\u0003B\u0004h*Y7f\u0011\u001d\tY$\u0003a\u0001\u0003{\ta\u0001]1hS:<\u0007\u0003BA\u0012\u0003\u007fIA!!\u0011\u0002&\t1\u0001+Y4j]\u001eDq!!\u0012\n\u0001\u0004\t9%A\u0003pe\u0012,'\u000f\u0005\u0003\u0002$\u0005%\u0013\u0002BA&\u0003K\u0011\u0001b\u0014:eKJLgnZ\u0001\u0018G>,h\u000e^#om&\u0014xN\\7f]R\u001c()\u001f%pgR$b!!\u0015\u0002X\u0005e\u0003c\u0001\u000f\u0002T%\u0019\u0011QK\u000f\u0003\u000f%sG/Z4fe\")!P\u0003a\u0001w\"1\u00111\f\u0006A\u0002m\fq\"\u001a8wSJ|g.\\3oi:\u000bW.Z\u0001\u0016O\u0016$XI\u001c<je>tW.\u001a8ug\nK\bj\\:u))\t\t'!\u001b\u0002l\u00055\u0014q\u000e\t\u0007\u0003/\ti\"a\u0019\u0011\t\u0005\r\u0012QM\u0005\u0005\u0003O\n)C\u0001\bEKBdw._7f]RLeNZ8\t\u000bi\\\u0001\u0019A>\t\r\u0005m3\u00021\u0001|\u0011\u001d\tYd\u0003a\u0001\u0003{Aq!!\u0012\f\u0001\u0004\t9\u0005K\u0002\u0001\u0003g\u0002B!!\u001e\u0002|5\u0011\u0011q\u000f\u0006\u0004\u0003sz\u0015AC:uKJ,w\u000e^=qK&!\u0011QPA<\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class HostServiceImpl
implements HostService {
    private final EnvironmentRepository environmentRepository;
    private final DeployedApplicationsRepository deployedApplicationsRepository;
    private final PaginationService paginationService;
    private final RepositoryResource repositoryResource;
    @Context
    private final HttpResponse response;

    public HttpResponse response() {
        return this.response;
    }

    private ConfigurationItem checkIfUserHasPermissions(String hostId) {
        return this.repositoryResource.read(hostId);
    }

    public List<ConfigurationItemId> findDeployedApplications(String hostId, String deployedAppName, Paging paging, Ordering order) {
        this.checkIfUserHasPermissions(hostId);
        this.paginationService.addPagingHeaderIfNeeded(this.paginationService.toSetHeader(this.response()), () -> Predef$.MODULE$.int2Integer($this.deployedApplicationsRepository.countByHost(hostId, deployedAppName)), paging);
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.deployedApplicationsRepository.findByHost(hostId, deployedAppName, paging, order)).asJava();
    }

    public Integer countEnvironmentsByHost(String hostId, String environmentName) {
        this.checkIfUserHasPermissions(hostId);
        return Predef$.MODULE$.int2Integer(this.environmentRepository.count(hostId, Option$.MODULE$.apply((Object)environmentName)));
    }

    public List<DeploymentInfo> getEnvironmentsByHost(String hostId, String environmentName, Paging paging, Ordering order) {
        this.checkIfUserHasPermissions(hostId);
        this.paginationService.addPagingHeaderIfNeeded(this.paginationService.toSetHeader(this.response()), () -> Predef$.MODULE$.int2Integer($this.environmentRepository.count(hostId, Option$.MODULE$.apply((Object)environmentName))), paging);
        return this.environmentRepository.listEnvironmentsByHost(hostId, Option$.MODULE$.apply((Object)environmentName), paging, order);
    }

    @Autowired
    public HostServiceImpl(EnvironmentRepository environmentRepository, DeployedApplicationsRepository deployedApplicationsRepository, PaginationService paginationService, RepositoryResource repositoryResource) {
        this.environmentRepository = environmentRepository;
        this.deployedApplicationsRepository = deployedApplicationsRepository;
        this.paginationService = paginationService;
        this.repositoryResource = repositoryResource;
        this.response = null;
    }
}

