/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.python.google.common.annotations.GwtCompatible;
import org.python.google.common.annotations.VisibleForTesting;
import org.python.google.common.collect.AbstractObjectCountMap;
import org.python.google.common.collect.CollectPreconditions;
import org.python.google.common.collect.Multiset;
import org.python.google.common.collect.ObjectArrays;
import org.python.google.common.collect.ObjectCountHashMap;

@GwtCompatible(serializable=true, emulated=true)
class ObjectCountLinkedHashMap<K>
extends ObjectCountHashMap<K> {
    private static final int ENDPOINT = -2;
    @VisibleForTesting
    transient long[] links;
    private transient int firstEntry;
    private transient int lastEntry;

    public static <K> ObjectCountLinkedHashMap<K> create() {
        return new ObjectCountLinkedHashMap<K>();
    }

    public static <K> ObjectCountLinkedHashMap<K> createWithExpectedSize(int expectedSize) {
        return new ObjectCountLinkedHashMap<K>(expectedSize);
    }

    ObjectCountLinkedHashMap() {
        this(3);
    }

    ObjectCountLinkedHashMap(int expectedSize) {
        this(expectedSize, 1.0f);
    }

    ObjectCountLinkedHashMap(int expectedSize, float loadFactor) {
        super(expectedSize, loadFactor);
    }

    ObjectCountLinkedHashMap(AbstractObjectCountMap<K> map) {
        this.init(map.size(), 1.0f);
        int i = map.firstIndex();
        while (i != -1) {
            this.put(map.getKey(i), map.getValue(i));
            i = map.nextIndex(i);
        }
    }

    @Override
    void init(int expectedSize, float loadFactor) {
        super.init(expectedSize, loadFactor);
        this.firstEntry = -2;
        this.lastEntry = -2;
        this.links = new long[expectedSize];
        Arrays.fill(this.links, -1L);
    }

    @Override
    int firstIndex() {
        return this.firstEntry == -2 ? -1 : this.firstEntry;
    }

    @Override
    int nextIndex(int index) {
        int result2 = this.getSuccessor(index);
        return result2 == -2 ? -1 : result2;
    }

    private int getPredecessor(int entry) {
        return (int)(this.links[entry] >>> 32);
    }

    private int getSuccessor(int entry) {
        return (int)this.links[entry];
    }

    private void setSuccessor(int entry, int succ) {
        long succMask = 0xFFFFFFFFL;
        this.links[entry] = this.links[entry] & (succMask ^ 0xFFFFFFFFFFFFFFFFL) | (long)succ & succMask;
    }

    private void setPredecessor(int entry, int pred) {
        long predMask = -4294967296L;
        this.links[entry] = this.links[entry] & (predMask ^ 0xFFFFFFFFFFFFFFFFL) | (long)pred << 32;
    }

    private void setSucceeds(int pred, int succ) {
        if (pred == -2) {
            this.firstEntry = succ;
        } else {
            this.setSuccessor(pred, succ);
        }
        if (succ == -2) {
            this.lastEntry = pred;
        } else {
            this.setPredecessor(succ, pred);
        }
    }

    @Override
    void insertEntry(int entryIndex, K key, int value, int hash) {
        super.insertEntry(entryIndex, key, value, hash);
        this.setSucceeds(this.lastEntry, entryIndex);
        this.setSucceeds(entryIndex, -2);
    }

    @Override
    void moveLastEntry(int dstIndex) {
        int srcIndex = this.size() - 1;
        this.setSucceeds(this.getPredecessor(dstIndex), this.getSuccessor(dstIndex));
        if (dstIndex < srcIndex) {
            this.setSucceeds(this.getPredecessor(srcIndex), dstIndex);
            this.setSucceeds(dstIndex, this.getSuccessor(srcIndex));
        }
        super.moveLastEntry(dstIndex);
    }

    @Override
    void resizeEntries(int newCapacity) {
        super.resizeEntries(newCapacity);
        this.links = Arrays.copyOf(this.links, newCapacity);
    }

    @Override
    Set<K> createKeySet() {
        return new AbstractObjectCountMap.KeySetView(){

            @Override
            public Object[] toArray() {
                return ObjectArrays.toArrayImpl(this);
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return ObjectArrays.toArrayImpl(this, a);
            }

            @Override
            public Iterator<K> iterator() {
                return new LinkedItr<K>(){

                    @Override
                    K getOutput(int entry) {
                        return ObjectCountLinkedHashMap.this.keys[entry];
                    }
                };
            }
        };
    }

    @Override
    Set<Multiset.Entry<K>> createEntrySet() {
        return new AbstractObjectCountMap.EntrySetView(){

            @Override
            public Iterator<Multiset.Entry<K>> iterator() {
                return new LinkedItr<Multiset.Entry<K>>(){

                    @Override
                    Multiset.Entry<K> getOutput(int entry) {
                        return new AbstractObjectCountMap.MapEntry(ObjectCountLinkedHashMap.this, entry);
                    }
                };
            }
        };
    }

    @Override
    public void clear() {
        super.clear();
        this.firstEntry = -2;
        this.lastEntry = -2;
    }

    private abstract class LinkedItr<T>
    implements Iterator<T> {
        private int nextEntry;
        private int toRemove;
        private int expectedModCount;

        private LinkedItr() {
            this.nextEntry = ObjectCountLinkedHashMap.this.firstEntry;
            this.toRemove = -1;
            this.expectedModCount = ObjectCountLinkedHashMap.this.modCount;
        }

        private void checkForConcurrentModification() {
            if (ObjectCountLinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != -2;
        }

        abstract T getOutput(int var1);

        @Override
        public T next() {
            this.checkForConcurrentModification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T result2 = this.getOutput(this.nextEntry);
            this.toRemove = this.nextEntry;
            this.nextEntry = ObjectCountLinkedHashMap.this.getSuccessor(this.nextEntry);
            return result2;
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            CollectPreconditions.checkRemove(this.toRemove != -1);
            ObjectCountLinkedHashMap.this.remove(ObjectCountLinkedHashMap.this.keys[this.toRemove]);
            if (this.nextEntry >= ObjectCountLinkedHashMap.this.size()) {
                this.nextEntry = this.toRemove;
            }
            this.expectedModCount = ObjectCountLinkedHashMap.this.modCount;
            this.toRemove = -1;
        }
    }
}

