/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseViolationException;
import com.xebialabs.license.service.LicenseService;
import java.io.IOException;
import java.util.HashSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class LicenseValidationFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(LicenseValidationFilter.class);
    public static final String WHITE_LISTED_PATHS = "whiteListedPaths";
    @Autowired
    private LicenseService licenseService;
    private HashSet<String> whiteList = new HashSet();

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.trace("Added LicenseCheckFilter to the mix.");
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext((Object)this);
        String whiteListedPathsString = filterConfig.getInitParameter(WHITE_LISTED_PATHS);
        this.whiteList = new HashSet(Strings.split((String)whiteListedPathsString, (String)","));
    }

    public void setLicenseService(LicenseService licenseService) {
        Checks.checkNotNull((Object)licenseService, (String)"LicenseCheckFilter: Could not find license check service");
        this.licenseService = licenseService;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            return;
        }
        License license = this.licenseService.getLicense();
        String pathInfo = ((HttpServletRequest)request).getPathInfo();
        if (this.whiteList.contains(pathInfo)) {
            logger.debug("Path {} is white listed", (Object)pathInfo);
            chain.doFilter(request, response);
        } else if (license.isDummyLicense() || !this.licenseIsValid()) {
            logger.debug("This license is invalid: {}", (Object)license);
            ((HttpServletResponse)response).sendError(402, "License expired");
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean licenseIsValid() {
        try {
            this.licenseService.validate();
        }
        catch (LicenseViolationException e) {
            logger.debug("Invalid license:", (Throwable)e);
            return false;
        }
        return true;
    }

    public void destroy() {
    }
}

