/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.database.anonymizer.filter;

import com.xebialabs.database.anonymizer.model.AnonymizerRules;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;

public class AnonymizerDatabaseSequenceFilter
extends DatabaseSequenceFilter {
    private final AnonymizerRules anonymizerRules;

    public AnonymizerDatabaseSequenceFilter(AnonymizerRules anonymizerRules, IDatabaseConnection connection) throws DataSetException, SQLException {
        super(connection);
        this.anonymizerRules = anonymizerRules;
    }

    private Boolean tableNameIs(String tableNameWithSchema, List<String> excludedTables) {
        String lowerCasedName = tableNameWithSchema.toLowerCase();
        List insensitiveTableNames = excludedTables.stream().map(String::toLowerCase).collect(Collectors.toList());
        if (lowerCasedName.contains(".")) {
            String[] tokens = lowerCasedName.split("\\.");
            String tableName = tokens[tokens.length - 1].toLowerCase();
            return insensitiveTableNames.contains(tableName);
        }
        return insensitiveTableNames.contains(lowerCasedName);
    }

    public String[] getTableNames(IDataSet dataSet) throws DataSetException {
        String[] tableNames = super.getTableNames(dataSet);
        return (String[])Arrays.stream(tableNames).filter(tableName -> this.tableNameIs((String)tableName, this.anonymizerRules.getTablesToNotExport()) == false).toArray(String[]::new);
    }
}

