/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.qourum;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.cluster.qourum.BooleanVote;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumVote;
import org.apache.activemq.artemis.core.server.cluster.qourum.ServerConnectVote;
import org.apache.activemq.artemis.core.server.cluster.qourum.Vote;

public class QuorumVoteServerConnect
extends QuorumVote<ServerConnectVote, Boolean> {
    public static final SimpleString LIVE_FAILOVER_VOTE = new SimpleString("LiveFailoverQuorumVote");
    private final CountDownLatch latch;
    private final String targetNodeId;
    private int votesNeeded;
    private int total = 0;
    private boolean decision = false;
    private boolean requestToStayLive = false;

    public QuorumVoteServerConnect(int size, String targetNodeId, boolean requestToStayLive) {
        super(LIVE_FAILOVER_VOTE);
        this.targetNodeId = targetNodeId;
        double majority = size <= 2 ? (double)size / 2.0 : (double)size / 2.0 + 1.0;
        this.votesNeeded = (int)majority;
        this.latch = new CountDownLatch(this.votesNeeded);
        if (this.votesNeeded == 0) {
            this.decision = true;
        }
        this.requestToStayLive = requestToStayLive;
    }

    public QuorumVoteServerConnect(int size, String targetNodeId) {
        this(size, targetNodeId, false);
    }

    @Override
    public Vote connected() {
        return new ServerConnectVote(this.targetNodeId, this.requestToStayLive);
    }

    @Override
    public Vote notConnected() {
        return new BooleanVote(false);
    }

    @Override
    public synchronized void vote(ServerConnectVote vote) {
        if (this.decision) {
            return;
        }
        if (vote.getVote().booleanValue()) {
            ++this.total;
            this.latch.countDown();
            if (this.total >= this.votesNeeded) {
                this.decision = true;
            }
        }
    }

    @Override
    public void allVotesCast(Topology voteTopology) {
        while (this.latch.getCount() > 0L) {
            this.latch.countDown();
        }
    }

    @Override
    public Boolean getDecision() {
        return this.decision;
    }

    public void await(int latchTimeout, TimeUnit unit) throws InterruptedException {
        ActiveMQServerLogger.LOGGER.waitingForQuorumVoteResults(latchTimeout, unit.toString().toLowerCase());
        if (this.latch.await(latchTimeout, unit)) {
            ActiveMQServerLogger.LOGGER.receivedAllQuorumVotes();
        } else {
            ActiveMQServerLogger.LOGGER.timeoutWaitingForQuorumVoteResponses();
        }
    }

    public boolean isRequestToStayLive() {
        return this.requestToStayLive;
    }
}

