/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.exts.config;

import com.sksamuel.exts.Logging;
import com.sksamuel.exts.OptionImplicits$;
import com.sksamuel.exts.config.ConfigLoaderParams;
import com.sksamuel.exts.config.ConfigLoaderParams$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.sys.package$;

public final class ConfigLoader$
implements Logging {
    public static ConfigLoader$ MODULE$;
    private final String ConfigKey;
    private final String LocalEnv;
    private final Logger logger;

    static {
        new ConfigLoader$();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$sksamuel$exts$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String ConfigKey() {
        return this.ConfigKey;
    }

    public String LocalEnv() {
        return this.LocalEnv;
    }

    public Config load(ConfigLoaderParams params) {
        String env = (String)Option$.MODULE$.apply(package$.MODULE$.props().apply((Object)this.ConfigKey())).orElse((Function0 & java.io.Serializable & Serializable)() -> package$.MODULE$.env().get((Object)MODULE$.ConfigKey())).getOrElse((Function0 & java.io.Serializable & Serializable)() -> MODULE$.LocalEnv());
        String resolvedEnvConfFilename = params.envConfFilename().replace("$ENV", env);
        String userHome = System.getProperty("user.home");
        Config refconf = ConfigFactory.defaultReference();
        Config appconf = ConfigFactory.parseResources((String)params.applicationConfName());
        Config envconf = this.envConf$1(params, resolvedEnvConfFilename, userHome);
        Config overrideconf = ConfigLoader$.overrideConf$1(params, userHome);
        return overrideconf.withFallback((ConfigMergeable)envconf).withFallback((ConfigMergeable)appconf).withFallback((ConfigMergeable)refconf).resolve();
    }

    public ConfigLoaderParams load$default$1() {
        return new ConfigLoaderParams(ConfigLoaderParams$.MODULE$.apply$default$1(), ConfigLoaderParams$.MODULE$.apply$default$2(), ConfigLoaderParams$.MODULE$.apply$default$3(), ConfigLoaderParams$.MODULE$.apply$default$4(), ConfigLoaderParams$.MODULE$.apply$default$5(), ConfigLoaderParams$.MODULE$.apply$default$6(), ConfigLoaderParams$.MODULE$.apply$default$7(), ConfigLoaderParams$.MODULE$.apply$default$8(), ConfigLoaderParams$.MODULE$.apply$default$9());
    }

    public Config apply(String appName) {
        String env = (String)Option$.MODULE$.apply(package$.MODULE$.props().apply((Object)this.ConfigKey())).orElse((Function0 & java.io.Serializable & Serializable)() -> package$.MODULE$.env().get((Object)MODULE$.ConfigKey())).getOrElse((Function0 & java.io.Serializable & Serializable)() -> MODULE$.LocalEnv());
        Config refConf = ConfigFactory.defaultReference();
        Config appConf = ConfigFactory.parseResources((String)new StringBuilder(5).append(appName).append(".conf").toString());
        Config envConf = ConfigLoader$.locateAndLoadEnvConf$1(env);
        Config overConf = ConfigLoader$.locateAndLoadOverrideConf$1("override.conf");
        return overConf.withFallback((ConfigMergeable)envConf).withFallback((ConfigMergeable)appConf).withFallback((ConfigMergeable)refConf).resolve();
    }

    public String apply$default$1() {
        return "application";
    }

    private static final Config loadPath$1(Path path2) {
        return (Config)OptionImplicits$.MODULE$.RichPathOptionImplicits(path2.toAbsolutePath()).some().map((Function1 & java.io.Serializable & Serializable)path -> {
            MODULE$.logger().info(new StringBuilder(13).append("Loading path:").append(path).toString());
            return ConfigFactory.parseFile((File)path.toFile());
        }).getOrElse((Function0 & java.io.Serializable & Serializable)() -> ConfigFactory.empty());
    }

    private final Config loadResource$1(String resource) {
        this.logger().info(new StringBuilder(31).append("Loading classpath:").append(resource).append(" (if present)").toString());
        return ConfigFactory.parseResources((String)resource);
    }

    private static final Config loadOverrideFromDir$1(String path, ConfigLoaderParams params$1) {
        return ConfigLoader$.loadPath$1(Paths.get(path, new String[0]).resolve(params$1.overrideConfName()));
    }

    private static final Config overrideConf$1(ConfigLoaderParams params$1, String userHome$1) {
        Config workingDirConf = params$1.overrideConfInWorkingDir() ? ConfigLoader$.loadOverrideFromDir$1(".", params$1) : ConfigFactory.empty();
        Config userHomeConf = params$1.overrideConfInUserHome() ? ConfigLoader$.loadOverrideFromDir$1(userHome$1, params$1) : ConfigFactory.empty();
        return workingDirConf.withFallback((ConfigMergeable)userHomeConf);
    }

    private static final Config loadEnvConfFromDir$1(String path, String resolvedEnvConfFilename$1) {
        return ConfigLoader$.loadPath$1(Paths.get(path, new String[0]).resolve(resolvedEnvConfFilename$1));
    }

    private final Config envConf$1(ConfigLoaderParams params$1, String resolvedEnvConfFilename$1, String userHome$1) {
        Config workingDirConf = params$1.envConfInWorkingDir() ? ConfigLoader$.loadEnvConfFromDir$1(".", resolvedEnvConfFilename$1) : ConfigFactory.empty();
        Config userHomeConf = params$1.envConfInUserHome() ? ConfigLoader$.loadEnvConfFromDir$1(userHome$1, resolvedEnvConfFilename$1) : ConfigFactory.empty();
        Config classpathConf = this.loadResource$1(resolvedEnvConfFilename$1);
        return workingDirConf.withFallback((ConfigMergeable)userHomeConf).withFallback((ConfigMergeable)classpathConf);
    }

    private static final Config locateAndLoadOverrideConf$1(String name) {
        Path overrideConfPath = Paths.get(".", new String[0]).resolve(name).toAbsolutePath();
        return (Config)OptionImplicits$.MODULE$.RichPathOptionImplicits(overrideConfPath).some().map((Function1 & java.io.Serializable & Serializable)path -> {
            MODULE$.logger().info(new StringBuilder(17).append("Loading OVERRIDE:").append(path).toString());
            return ConfigFactory.parseFile((File)path.toFile());
        }).getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
            MODULE$.logger().info(new StringBuilder(28).append("No override conf located at ").append(overrideConfPath).toString());
            return ConfigFactory.empty();
        });
    }

    private static final Config locateAndLoadEnvConf$1(String env) {
        String confFilename = new StringBuilder(5).append(env).append(".conf").toString();
        Option<Path> cwdConfFile = OptionImplicits$.MODULE$.RichPathOptionImplicits(Paths.get(".", new String[0]).resolve(confFilename).toAbsolutePath()).some();
        Option<Path> homeFolderConfFile = OptionImplicits$.MODULE$.RichPathOptionImplicits(Paths.get((String)package$.MODULE$.props().apply((Object)"user.home"), new String[0]).resolve(confFilename).toAbsolutePath()).some();
        return (Config)cwdConfFile.orElse((Function0 & java.io.Serializable & Serializable)() -> homeFolderConfFile).map((Function1 & java.io.Serializable & Serializable)path -> {
            MODULE$.logger().info(new StringBuilder(25).append("Loading ENV:").append(env).append(" config from ").append(path).toString());
            return ConfigFactory.parseFile((File)path.toFile());
        }).getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
            MODULE$.logger().info(new StringBuilder(47).append("Loading ENV:").append(env).append(" config from classpath (if present)").toString());
            return ConfigFactory.parseResources((String)confFilename);
        });
    }

    private ConfigLoader$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.ConfigKey = "CONFIG_ENV";
        this.LocalEnv = "LOCAL";
    }
}

