/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.BytesDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobDataType
extends BytesDataType {
    private static final Logger logger = LoggerFactory.getLogger(BlobDataType.class);

    public BlobDataType() {
        super("BLOB", 2004);
    }

    public BlobDataType(String name, int sqlType) {
        super(name, sqlType);
    }

    @Override
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        Blob value;
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)String.valueOf(column), (Object)resultSet);
        }
        if ((value = resultSet.getBlob(column)) == null || resultSet.wasNull()) {
            return null;
        }
        return this.typeCast(value);
    }

    @Override
    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, String.valueOf(column), statement});
        }
        statement.setObject(column, this.typeCast(value), super.getSqlType());
    }
}

