/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.EnrichDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Enricher;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.reifier.ExpressionReifier;

public class EnrichReifier
extends ExpressionReifier<EnrichDefinition> {
    public EnrichReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (EnrichDefinition)EnrichDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        AggregationStrategy strategy;
        Expression exp = this.createExpression(((EnrichDefinition)this.definition).getExpression());
        boolean isShareUnitOfWork = this.parseBoolean(((EnrichDefinition)this.definition).getShareUnitOfWork(), false);
        boolean isIgnoreInvalidEndpoint = this.parseBoolean(((EnrichDefinition)this.definition).getIgnoreInvalidEndpoint(), false);
        Enricher enricher = new Enricher(exp);
        enricher.setShareUnitOfWork(isShareUnitOfWork);
        enricher.setIgnoreInvalidEndpoint(isIgnoreInvalidEndpoint);
        if (((EnrichDefinition)this.definition).getCacheSize() != null) {
            enricher.setCacheSize(this.parseInt(((EnrichDefinition)this.definition).getCacheSize()).intValue());
        }
        if ((strategy = this.createAggregationStrategy()) != null) {
            enricher.setAggregationStrategy(strategy);
        }
        if (((EnrichDefinition)this.definition).getAggregateOnException() != null) {
            enricher.setAggregateOnException(this.parseBoolean(((EnrichDefinition)this.definition).getAggregateOnException(), false));
        }
        return enricher;
    }

    private AggregationStrategy createAggregationStrategy() {
        AggregationStrategy strategy = ((EnrichDefinition)this.definition).getAggregationStrategy();
        if (strategy == null && ((EnrichDefinition)this.definition).getAggregationStrategyRef() != null) {
            Object aggStrategy = this.lookup(((EnrichDefinition)this.definition).getAggregationStrategyRef(), Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, ((EnrichDefinition)this.definition).getAggregationStrategyMethodName());
                if (((EnrichDefinition)this.definition).getAggregationStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(this.parseBoolean(((EnrichDefinition)this.definition).getAggregationStrategyMethodAllowNull(), false));
                    adapter.setAllowNullOldExchange(this.parseBoolean(((EnrichDefinition)this.definition).getAggregationStrategyMethodAllowNull(), false));
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + ((EnrichDefinition)this.definition).getAggregationStrategyRef());
            }
        }
        if (strategy instanceof CamelContextAware) {
            ((CamelContextAware)strategy).setCamelContext(this.camelContext);
        }
        return strategy;
    }
}

