/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Role
implements Serializable {
    private String id;
    private String name;
    private List<String> principals = new ArrayList<String>();
    private List<String> roles = new ArrayList<String>();

    public Role(String id, String name, List<String> principals, List<String> roles) {
        this(id, name, principals);
        this.roles = new ArrayList<String>(roles);
    }

    public Role(String id, String name, List<String> principals) {
        this(id, name);
        this.principals = new ArrayList<String>(principals);
    }

    public Role(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public Role(String name) {
        this(null, name);
    }

    public Role withPrincipals(String ... newPrincipals) {
        this.setPrincipals(new ArrayList<String>(Arrays.asList(newPrincipals)));
        return this;
    }

    public Role withRoles(String ... newRoles) {
        this.setRoles(new ArrayList<String>(Arrays.asList(newRoles)));
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrincipals(List<String> principals) {
        this.principals = principals;
    }

    @Deprecated
    public List<String> getPrincipalsAssigned() {
        return this.getPrincipals();
    }

    public List<String> getPrincipals() {
        return this.principals;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Role) {
            Role o = (Role)obj;
            return this.id == null && o.id == null ? this.name.equals(o.name) : this.id != null && this.id.equals(o.id);
        }
        return false;
    }
}

