/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere;

import com.xebialabs.deployit.plugin.api.flow.StagingTarget;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.TypeIcon;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.credentials.HostCredentials;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.utils.Strings;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(root=Metadata.ConfigurationItemRoot.INFRASTRUCTURE, virtual=true, description="Machine that runs middleware, on which scripts can be executed, etc.")
@TypeIcon(value="icons/types/overthere.Host.svg")
public class Host
extends BaseContainer
implements HostContainer,
StagingTarget {
    @Property(description="Protocol to use when connecting to this host", hidden=true)
    private String protocol;
    @Property(label="Operating system", description="Operating system the host runs")
    private OperatingSystemFamily os;
    @Property(label="Executable shell", description="Executable shell program", required=false, hidden=true)
    private String shell;
    @Property(category="Advanced", description="Directory into which temporary files are stored. Will be cleaned up when the connection is closed.", required=false)
    private String temporaryDirectoryPath;
    @Property(category="Advanced", description="Directory into which staged files are stored. Will be cleaned up when the task is finished.", required=false)
    private String stagingDirectoryPath;
    @Property(category="Advanced", description="Instance of xl-satellite that can manage this host.", required=false)
    private Satellite satellite;
    private static Logger logger = LoggerFactory.getLogger(Host.class);

    @Override
    public OverthereConnection getConnection() {
        logger.debug("Using connection protocol {}", (Object)this.protocol);
        return Overthere.getConnection((String)this.protocol, (ConnectionOptions)this.getConnectionOptions());
    }

    @Override
    public Host getHost() {
        return this;
    }

    public OperatingSystemFamily getOs() {
        return this.os;
    }

    public void setOs(OperatingSystemFamily os) {
        this.os = os;
    }

    public String getTemporaryDirectoryPath() {
        return this.temporaryDirectoryPath;
    }

    public void setTemporaryDirectoryPath(String temporaryDirectoryPath) {
        this.temporaryDirectoryPath = temporaryDirectoryPath;
    }

    @Override
    public String getStagingDirectoryPath() {
        return this.stagingDirectoryPath;
    }

    public void setStagingDirectoryPath(String stagingDirectoryPath) {
        this.stagingDirectoryPath = stagingDirectoryPath;
    }

    private ConnectionOptions getConnectionOptions() {
        return new ConnectionOptionsBuilder().getConnectionOptions(this);
    }

    public String getShell() {
        return this.shell;
    }

    public Satellite getSatellite() {
        return this.satellite;
    }

    public static class ConnectionOptionsBuilder {
        private List<String> jumpStationsSeen = new ArrayList<String>();
        private List<String> winrsProxiesSeen = new ArrayList<String>();

        public ConnectionOptions getConnectionOptions(Host host) {
            ConnectionOptions options = new ConnectionOptions();
            this.copyPropertiesToConnectionOptions(options, host);
            String temporaryDirectoryPath = host.getTemporaryDirectoryPath();
            if (temporaryDirectoryPath != null && !temporaryDirectoryPath.trim().isEmpty()) {
                this.setConnectionOption(options, "tmp", temporaryDirectoryPath);
            }
            this.applyCredentials(options);
            logger.debug("Created connection options: {}", (Object)options);
            return options;
        }

        protected void copyPropertiesToConnectionOptions(ConnectionOptions options, ConfigurationItem ci) {
            for (PropertyDescriptor pd : ci.getType().getDescriptor().getPropertyDescriptors()) {
                Object value = pd.get(ci);
                this.setConnectionOption(options, pd.getName(), value);
            }
        }

        private void applyCredentials(ConnectionOptions options) {
            Object credentials = options.getOptional("credentials");
            if (credentials != null) {
                ((HostCredentials)credentials).applyProperties((key, value) -> this.setConnectionOption(options, (String)key, value));
            }
        }

        private void setConnectionOption(ConnectionOptions options, String key, Object value) {
            if (key.equals("temporaryDirectoryPath")) {
                return;
            }
            if (value == null || value.toString().isEmpty()) {
                return;
            }
            if (value instanceof Integer && (Integer)value == 0) {
                logger.debug("Activating workaround for DEPLOYITPB-4775: Integer with value of 0 not passed to Overthere.");
                return;
            }
            if (key.equals("jumpstation")) {
                ConfigurationItem item = (ConfigurationItem)value;
                this.checkCircularReference((ConfigurationItem)value, this.jumpStationsSeen, "jumpstations");
                ConnectionOptions jumpstationOptions = new ConnectionOptions();
                this.copyPropertiesToConnectionOptions(jumpstationOptions, item);
                options.set(key, (Object)jumpstationOptions);
            } else if (key.equals("winrsProxy")) {
                ConfigurationItem item = (ConfigurationItem)value;
                this.checkCircularReference((ConfigurationItem)value, this.winrsProxiesSeen, "winrs proxies");
                options.set("winrsProxyProtocol", item.getProperty("protocol"));
                ConnectionOptions winrsProxyOptions = new ConnectionOptions();
                this.copyPropertiesToConnectionOptions(winrsProxyOptions, item);
                options.set("winrsProxyConnectionOptions", (Object)winrsProxyOptions);
            } else {
                options.set(key, value);
            }
        }

        private void checkCircularReference(ConfigurationItem value, List<String> list, String what) {
            if (list.contains(value.getId())) {
                list.add(value.getId());
                String loop = Strings.mkString(list, " -> ");
                throw new IllegalStateException("Detected loop in " + what + ": " + loop);
            }
            list.add(value.getId());
        }
    }
}

