/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.deployit.engine.api.dto.AbstractDto;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.FormParam;
import org.jboss.resteasy.annotations.providers.multipart.PartType;

@PublicApiRef
public class ArtifactAndData
extends AbstractDto {
    @FormParam(value="configurationItem")
    @PartType(value="application/xml")
    private Artifact artifact;
    @FormParam(value="filename")
    @PartType(value="application/xml")
    private String filename;
    @FormParam(value="fileData")
    @PartType(value="application/octet-stream")
    private File file;
    @FormParam(value="fileStream")
    @PartType(value="application/octet-stream")
    private InputStream data;

    public ArtifactAndData() {
    }

    public ArtifactAndData(Artifact artifact, File file) {
        this.artifact = artifact;
        this.filename = this.filename;
        this.file = file;
    }

    @Deprecated
    public ArtifactAndData(Artifact artifact, String filename, InputStream data) {
        this.artifact = artifact;
        this.filename = filename;
        this.data = data;
    }

    @Deprecated
    public ArtifactAndData(Artifact artifact, String filename, byte[] data) {
        this(artifact, filename, new ByteArrayInputStream(data));
    }

    @Deprecated
    public ArtifactAndData(Artifact artifact, InputStream data) {
        this(artifact, null, data);
    }

    @Deprecated
    public ArtifactAndData(Artifact artifact, byte[] data) {
        this(artifact, null, data);
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public InputStream getDataInputStream() {
        if (this.data == null && this.file != null) {
            try {
                this.data = new BufferedInputStream(new FileInputStream(this.file));
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Could not read the artifact file");
            }
        }
        return this.data;
    }

    public void setDataInputStream(InputStream data) {
        this.data = data;
    }

    @Deprecated
    public byte[] getData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ArtifactAndData.write(this.getDataInputStream(), byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @Deprecated
    public void setData(byte[] data) {
        this.data = new ByteArrayInputStream(data);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    private static void write(InputStream from, OutputStream to) {
        try {
            int nRead;
            byte[] bytes = new byte[131072];
            while ((nRead = from.read(bytes, 0, bytes.length)) != -1) {
                to.write(bytes, 0, nRead);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

