/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.Configuration;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.Subscribable;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.driver.status.SystemCounters;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.LogBufferUnblocker;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;

public final class IpcPublication
implements DriverManagedResource,
Subscribable {
    private static final ReadablePosition[] EMPTY_POSITIONS = new ReadablePosition[0];
    private final long registrationId;
    private final long unblockTimeoutNs;
    private final long lingerTimeoutNs;
    private final long tag;
    private final int sessionId;
    private final int streamId;
    private final int tripGain;
    private final int termBufferLength;
    private final int termWindowLength;
    private final int positionBitsToShift;
    private final int initialTermId;
    private long tripLimit;
    private long consumerPosition;
    private long lastConsumerPosition;
    private long timeOfLastConsumerPositionUpdateNs;
    private long cleanPosition;
    private long timeOfLastStateChangeNs;
    private int refCount = 0;
    private boolean reachedEndOfLife = false;
    private final boolean isExclusive;
    private State state = State.ACTIVE;
    private final UnsafeBuffer[] termBuffers;
    private ReadablePosition[] subscriberPositions = EMPTY_POSITIONS;
    private final Position publisherPos;
    private final Position publisherLimit;
    private final UnsafeBuffer metaDataBuffer;
    private final RawLog rawLog;
    private final AtomicCounter unblockedPublications;

    public IpcPublication(long registrationId, long tag, int sessionId, int streamId, Position publisherPos, Position publisherLimit, RawLog rawLog, long unblockTimeoutNs, long lingerTimeoutNs, long nowNs, SystemCounters systemCounters, boolean isExclusive) {
        int termLength;
        this.registrationId = registrationId;
        this.tag = tag;
        this.sessionId = sessionId;
        this.streamId = streamId;
        this.isExclusive = isExclusive;
        this.termBuffers = rawLog.termBuffers();
        this.initialTermId = LogBufferDescriptor.initialTermId((UnsafeBuffer)rawLog.metaData());
        this.termBufferLength = termLength = rawLog.termLength();
        this.positionBitsToShift = LogBufferDescriptor.positionBitsToShift((int)termLength);
        this.termWindowLength = Configuration.ipcPublicationTermWindowLength(termLength);
        this.tripGain = this.termWindowLength / 8;
        this.publisherPos = publisherPos;
        this.publisherLimit = publisherLimit;
        this.rawLog = rawLog;
        this.unblockTimeoutNs = unblockTimeoutNs;
        this.lingerTimeoutNs = lingerTimeoutNs;
        this.unblockedPublications = systemCounters.get(SystemCounterDescriptor.UNBLOCKED_PUBLICATIONS);
        this.metaDataBuffer = rawLog.metaData();
        this.lastConsumerPosition = this.consumerPosition = this.producerPosition();
        this.cleanPosition = this.consumerPosition;
        this.timeOfLastConsumerPositionUpdateNs = nowNs;
        this.timeOfLastStateChangeNs = nowNs;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int streamId() {
        return this.streamId;
    }

    public long registrationId() {
        return this.registrationId;
    }

    public long tag() {
        return this.tag;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public RawLog rawLog() {
        return this.rawLog;
    }

    public int publisherLimitId() {
        return this.publisherLimit.id();
    }

    public int termBufferLength() {
        return this.termBufferLength;
    }

    public int mtuLength() {
        return LogBufferDescriptor.mtuLength((UnsafeBuffer)this.metaDataBuffer);
    }

    @Override
    public boolean free() {
        return this.rawLog.free();
    }

    @Override
    public void close() {
        this.publisherPos.close();
        this.publisherLimit.close();
        for (ReadablePosition position : this.subscriberPositions) {
            position.close();
        }
        this.rawLog.close();
    }

    @Override
    public void addSubscriber(ReadablePosition subscriberPosition) {
        LogBufferDescriptor.isConnected((UnsafeBuffer)this.metaDataBuffer, (boolean)true);
        this.subscriberPositions = (ReadablePosition[])ArrayUtil.add((Object[])this.subscriberPositions, (Object)subscriberPosition);
    }

    @Override
    public void removeSubscriber(ReadablePosition subscriberPosition) {
        this.consumerPosition = Math.max(this.consumerPosition, subscriberPosition.getVolatile());
        this.subscriberPositions = (ReadablePosition[])ArrayUtil.remove((Object[])this.subscriberPositions, (Object)subscriberPosition);
        subscriberPosition.close();
        if (this.subscriberPositions.length == 0) {
            LogBufferDescriptor.isConnected((UnsafeBuffer)this.metaDataBuffer, (boolean)false);
        }
    }

    @Override
    public void onTimeEvent(long timeNs, long timeMs, DriverConductor conductor) {
        switch (this.state) {
            case ACTIVE: {
                long producerPosition = this.producerPosition();
                this.publisherPos.setOrdered(producerPosition);
                if (this.isExclusive) break;
                this.checkForBlockedPublisher(producerPosition, timeNs);
                break;
            }
            case INACTIVE: {
                long producerPosition = this.producerPosition();
                this.publisherPos.setOrdered(producerPosition);
                if (this.isDrained(producerPosition)) {
                    this.state = State.LINGER;
                    this.timeOfLastStateChangeNs = timeNs;
                    conductor.transitionToLinger(this);
                    break;
                }
                if (!LogBufferUnblocker.unblock((UnsafeBuffer[])this.termBuffers, (UnsafeBuffer)this.metaDataBuffer, (long)this.consumerPosition, (int)this.termBufferLength)) break;
                this.unblockedPublications.incrementOrdered();
                break;
            }
            case LINGER: {
                if (this.timeOfLastStateChangeNs + this.lingerTimeoutNs - timeNs >= 0L) break;
                this.reachedEndOfLife = true;
                conductor.cleanupIpcPublication(this);
            }
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    public void incRef() {
        ++this.refCount;
    }

    public void decRef() {
        if (0 == --this.refCount) {
            this.state = State.INACTIVE;
            long producerPosition = this.producerPosition();
            if (this.publisherLimit.get() > producerPosition) {
                this.publisherLimit.setOrdered(producerPosition);
            }
            LogBufferDescriptor.endOfStreamPosition((UnsafeBuffer)this.metaDataBuffer, (long)producerPosition);
        }
    }

    int updatePublisherLimit() {
        int workCount = 0;
        long minSubscriberPosition = Long.MAX_VALUE;
        long maxSubscriberPosition = this.consumerPosition;
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            long position = subscriberPosition.getVolatile();
            minSubscriberPosition = Math.min(minSubscriberPosition, position);
            maxSubscriberPosition = Math.max(maxSubscriberPosition, position);
        }
        if (this.subscriberPositions.length > 0) {
            long proposedLimit;
            if (maxSubscriberPosition > this.consumerPosition) {
                this.consumerPosition = maxSubscriberPosition;
            }
            if ((proposedLimit = minSubscriberPosition + (long)this.termWindowLength) > this.tripLimit) {
                this.publisherLimit.setOrdered(proposedLimit);
                this.tripLimit = proposedLimit + (long)this.tripGain;
                this.cleanBuffer(minSubscriberPosition);
                workCount = 1;
            }
        } else if (this.publisherLimit.get() > this.consumerPosition) {
            this.tripLimit = this.consumerPosition;
            this.publisherLimit.setOrdered(this.consumerPosition);
        }
        return workCount;
    }

    long joinPosition() {
        return this.consumerPosition;
    }

    long producerPosition() {
        long rawTail = LogBufferDescriptor.rawTailVolatile((UnsafeBuffer)this.metaDataBuffer);
        int termOffset = LogBufferDescriptor.termOffset((long)rawTail, (long)this.termBufferLength);
        return LogBufferDescriptor.computePosition((int)LogBufferDescriptor.termId((long)rawTail), (int)termOffset, (int)this.positionBitsToShift, (int)this.initialTermId);
    }

    long consumerPosition() {
        return this.consumerPosition;
    }

    State state() {
        return this.state;
    }

    private boolean isDrained(long producerPosition) {
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            if (subscriberPosition.getVolatile() >= producerPosition) continue;
            return false;
        }
        return true;
    }

    private void checkForBlockedPublisher(long producerPosition, long timeNs) {
        long consumerPosition = this.consumerPosition;
        if (consumerPosition == this.lastConsumerPosition && this.isPossiblyBlocked(producerPosition, consumerPosition)) {
            if (this.timeOfLastConsumerPositionUpdateNs + this.unblockTimeoutNs - timeNs < 0L && LogBufferUnblocker.unblock((UnsafeBuffer[])this.termBuffers, (UnsafeBuffer)this.metaDataBuffer, (long)consumerPosition, (int)this.termBufferLength)) {
                this.unblockedPublications.incrementOrdered();
            }
        } else {
            this.timeOfLastConsumerPositionUpdateNs = timeNs;
            this.lastConsumerPosition = consumerPosition;
        }
    }

    private boolean isPossiblyBlocked(long producerPosition, long consumerPosition) {
        int expectedTermCount;
        int producerTermCount = LogBufferDescriptor.activeTermCount((UnsafeBuffer)this.metaDataBuffer);
        if (producerTermCount != (expectedTermCount = (int)(consumerPosition >> this.positionBitsToShift))) {
            return true;
        }
        return producerPosition > consumerPosition;
    }

    private void cleanBuffer(long minConsumerPosition) {
        long cleanPosition = this.cleanPosition;
        UnsafeBuffer dirtyTerm = this.termBuffers[LogBufferDescriptor.indexByPosition((long)cleanPosition, (int)this.positionBitsToShift)];
        int bytesForCleaning = (int)(minConsumerPosition - cleanPosition);
        int bufferCapacity = this.termBufferLength;
        int termOffset = (int)cleanPosition & bufferCapacity - 1;
        int length = Math.min(bytesForCleaning, bufferCapacity - termOffset);
        if (length > 0) {
            dirtyTerm.setMemory(termOffset, length, (byte)0);
            this.cleanPosition = cleanPosition + (long)length;
        }
    }

    static enum State {
        ACTIVE,
        INACTIVE,
        LINGER;

    }
}

