/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.status;

import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.UnsafeBufferPosition;

public class StreamPositionCounter {
    public static final int REGISTRATION_ID_OFFSET = 0;
    public static final int SESSION_ID_OFFSET = 8;
    public static final int STREAM_ID_OFFSET = 12;
    public static final int CHANNEL_OFFSET = 16;
    public static final int MAX_CHANNEL_LENGTH = 92;

    public static UnsafeBufferPosition allocate(MutableDirectBuffer tempBuffer, String name, int typeId, CountersManager countersManager, long registrationId, int sessionId, int streamId, String channel) {
        return new UnsafeBufferPosition((UnsafeBuffer)countersManager.valuesBuffer(), StreamPositionCounter.allocateCounterId(tempBuffer, name, typeId, countersManager, registrationId, sessionId, streamId, channel), countersManager);
    }

    public static int allocateCounterId(MutableDirectBuffer tempBuffer, String name, int typeId, CountersManager countersManager, long registrationId, int sessionId, int streamId, String channel) {
        tempBuffer.putLong(0, registrationId);
        tempBuffer.putInt(8, sessionId);
        tempBuffer.putInt(12, streamId);
        int channelLength = tempBuffer.putStringWithoutLengthAscii(20, channel, 0, 92);
        tempBuffer.putInt(16, channelLength);
        int keyLength = 20 + channelLength;
        int labelOffset = BitUtil.align((int)keyLength, (int)4);
        int labelLength = 0;
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, name);
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, ": ");
        labelLength += tempBuffer.putLongAscii(labelOffset + labelLength, registrationId);
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, " ");
        labelLength += tempBuffer.putIntAscii(labelOffset + labelLength, sessionId);
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, " ");
        labelLength += tempBuffer.putIntAscii(labelOffset + labelLength, streamId);
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, " ");
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, channel, 0, 380 - labelLength);
        return countersManager.allocate(typeId, (DirectBuffer)tempBuffer, 0, keyLength, (DirectBuffer)tempBuffer, labelOffset, labelLength);
    }

    public static UnsafeBufferPosition allocate(MutableDirectBuffer tempBuffer, String name, int typeId, CountersManager countersManager, long registrationId, int sessionId, int streamId, String channel, long joinPosition) {
        tempBuffer.putLong(0, registrationId);
        tempBuffer.putInt(8, sessionId);
        tempBuffer.putInt(12, streamId);
        int channelLength = tempBuffer.putStringWithoutLengthAscii(20, channel, 0, 92);
        tempBuffer.putInt(16, channelLength);
        int keyLength = 20 + channelLength;
        int labelOffset = BitUtil.align((int)keyLength, (int)4);
        int labelLength = 0;
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, name);
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, ": ");
        labelLength += tempBuffer.putLongAscii(labelOffset + labelLength, registrationId);
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, " ");
        labelLength += tempBuffer.putIntAscii(labelOffset + labelLength, sessionId);
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, " ");
        labelLength += tempBuffer.putIntAscii(labelOffset + labelLength, streamId);
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, " ");
        labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, channel, 0, 380 - labelLength);
        if (labelLength < 360) {
            labelLength += tempBuffer.putStringWithoutLengthAscii(labelOffset + labelLength, " @");
            labelLength += tempBuffer.putLongAscii(labelOffset + labelLength, joinPosition);
        }
        int counterId = countersManager.allocate(typeId, (DirectBuffer)tempBuffer, 0, keyLength, (DirectBuffer)tempBuffer, labelOffset, labelLength);
        return new UnsafeBufferPosition((UnsafeBuffer)countersManager.valuesBuffer(), counterId, countersManager);
    }

    public static String labelName(int typeId) {
        switch (typeId) {
            case 1: {
                return "pub-lmt";
            }
            case 2: {
                return "snd-pos";
            }
            case 3: {
                return "rcv-hwm";
            }
            case 4: {
                return "sub-pos";
            }
            case 5: {
                return "rcv-pos";
            }
            case 9: {
                return "snd-lmt";
            }
            case 12: {
                return "pub-pos (sample)";
            }
        }
        return "<unknown>";
    }
}

