/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public abstract class FileBasedNodeManager
extends NodeManager {
    protected static final byte FIRST_TIME_START = 48;
    public static final String SERVER_LOCK_NAME = "server.lock";
    public static final String SERVER_ACTIVATION_SEQUENCE_NAME = "server.activation.sequence";
    private static final String ACCESS_MODE = "rw";
    private final File directory;
    protected FileChannel channel;
    protected FileChannel activationSequenceChannel;

    public FileBasedNodeManager(boolean replicatedBackup, File directory) {
        super(replicatedBackup);
        this.directory = directory;
        if (directory != null) {
            directory.mkdirs();
        }
    }

    protected void useActivationSequenceChannel() throws IOException {
        if (this.activationSequenceChannel != null) {
            return;
        }
        this.activationSequenceChannel = FileChannel.open(this.newFile(SERVER_ACTIVATION_SEQUENCE_NAME).toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
    }

    @Override
    public long readNodeActivationSequence() throws NodeManager.NodeManagerException {
        if (!this.isStarted()) {
            throw new NodeManager.NodeManagerException(new IllegalStateException("node manager must be started first"));
        }
        try {
            this.useActivationSequenceChannel();
            ByteBuffer tmpBuffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
            if (this.activationSequenceChannel.read(tmpBuffer, 0L) != 8) {
                return 0L;
            }
            tmpBuffer.flip();
            return tmpBuffer.getLong(0);
        }
        catch (IOException ie) {
            throw new NodeManager.NodeManagerException(ie);
        }
    }

    @Override
    public void writeNodeActivationSequence(long version) throws NodeManager.NodeManagerException {
        if (!this.isStarted()) {
            throw new NodeManager.NodeManagerException(new IllegalStateException("node manager must be started first"));
        }
        try {
            this.useActivationSequenceChannel();
            ByteBuffer tmpBuffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
            tmpBuffer.putLong(0, version);
            this.activationSequenceChannel.write(tmpBuffer, 0L);
            this.activationSequenceChannel.force(false);
            this.setNodeActivationSequence(version);
        }
        catch (IOException ie) {
            throw new NodeManager.NodeManagerException(ie);
        }
    }

    protected synchronized void setUpServerLockFile() throws IOException {
        File serverLockFile = this.newFile(SERVER_LOCK_NAME);
        boolean fileCreated = false;
        int count = 0;
        while (!serverLockFile.exists()) {
            try {
                fileCreated = serverLockFile.createNewFile();
            }
            catch (RuntimeException e) {
                ActiveMQServerLogger.LOGGER.nodeManagerCantOpenFile(e, serverLockFile);
                throw e;
            }
            catch (IOException e) {
                if (count < 5) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++count;
                    continue;
                }
                ActiveMQServerLogger.LOGGER.nodeManagerCantOpenFile(e, serverLockFile);
                throw e;
            }
        }
        RandomAccessFile raFile = new RandomAccessFile(serverLockFile, ACCESS_MODE);
        this.channel = raFile.getChannel();
        if (fileCreated) {
            ByteBuffer id = ByteBuffer.allocateDirect(3);
            byte[] bytes = new byte[]{48, 48, 48};
            id.put(bytes, 0, 3);
            id.position(0);
            this.channel.write(id, 0L);
            this.channel.force(true);
        }
        this.createNodeId();
    }

    protected final File newFile(String fileName) {
        return new File(this.directory, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void createNodeId() throws IOException {
        Object object = this.nodeIDGuard;
        synchronized (object) {
            ByteBuffer id = ByteBuffer.allocateDirect(16);
            int read = this.channel.read(id, 3L);
            if (this.replicatedBackup) {
                id.position(0);
                id.put(this.getUUID().asBytes(), 0, 16);
                id.position(0);
                this.channel.write(id, 3L);
                this.channel.force(true);
            } else if (read != 16) {
                this.setUUID(UUIDGenerator.getInstance().generateUUID());
                id.put(this.getUUID().asBytes(), 0, 16);
                id.position(0);
                this.channel.write(id, 3L);
                this.channel.force(true);
            } else {
                byte[] bytes = new byte[16];
                id.position(0);
                id.get(bytes);
                this.setUUID(new UUID(1, bytes));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() throws Exception {
        FileChannel channelCopy = this.channel;
        try {
            if (channelCopy != null) {
                channelCopy.close();
            }
        }
        finally {
            try {
                FileChannel dataVersionChannel = this.activationSequenceChannel;
                this.activationSequenceChannel = null;
                if (dataVersionChannel != null) {
                    dataVersionChannel.close();
                }
            }
            finally {
                super.stop();
            }
        }
    }

    @Override
    public void stopBackup() throws NodeManager.NodeManagerException {
        if (this.replicatedBackup && this.getNodeId() != null) {
            try {
                this.setUpServerLockFile();
            }
            catch (IOException e) {
                throw new NodeManager.NodeManagerException(e);
            }
        }
        super.stopBackup();
    }
}

