/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.impl.jdbc.LOBStreamControl;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.error.ExceptionUtil;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;

public class LOBOutputStream
extends OutputStream {
    private boolean closed = false;
    private final LOBStreamControl control;
    private long pos;

    LOBOutputStream(LOBStreamControl lOBStreamControl, long l) {
        this.control = lOBStreamControl;
        this.pos = l;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage((String)"J104", (Object[])new Object[0]));
        }
        try {
            this.pos = this.control.write(n, this.pos);
        }
        catch (StandardException standardException) {
            throw Util.newIOException(standardException);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage((String)"J104", (Object[])new Object[0]));
        }
        try {
            this.pos = this.control.write(byArray, n, n2, this.pos);
        }
        catch (StandardException standardException) {
            if (standardException.getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier((String)"XJ078.S"))) {
                throw new ArrayIndexOutOfBoundsException(standardException.getMessage());
            }
            throw Util.newIOException(standardException);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

